/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.SelectionUtil;
import com.tssap.dtr.client.eclipse.ui.actions.WorkerThreadProgressMonitor;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ViewPart;

public abstract class VfsObjectSelectionAction
implements IObjectActionDelegate,
IExecutableExtension {
    protected static final Object[] EMPTY_OBJECTS = new Object[0];
    protected IWorkbenchPart m_targetPart;
    private IConfigurationElement m_configuration;
    private IStructuredSelection m_selectedElement;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$VfsObjectSelectionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$VfsObjectSelectionAction = VfsObjectSelectionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$VfsObjectSelectionAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$VfsObjectSelectionAction;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.m_targetPart = targetPart;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.m_configuration = config;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.resetSavedSelection();
        if (action == null) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        this.m_selectedElement = (IStructuredSelection)selection;
        try {
            SelectionUtil.getInstance().checkSelection(this.m_selectedElement);
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            action.setEnabled(false);
            return;
        }
        if (SelectionUtil.getInstance().isConvertionFailed()) {
            action.setEnabled(false);
            return;
        }
        if (!this.isSelectionPlausible(this.m_selectedElement)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection convertedSelection = SelectionUtil.getInstance().getConvertedSelection();
        if (convertedSelection == null || convertedSelection.size() == 0) {
            action.setEnabled(false);
            return;
        }
        action.setEnabled(this.isEnabled(convertedSelection));
    }

    private void resetSavedSelection() {
        this.m_selectedElement = null;
    }

    private boolean isSelectionPlausible(IStructuredSelection selection) {
        return !selection.isEmpty() && (selection.size() <= 1 || this.allowedMultipleSelection());
    }

    protected IResource[] getSelectedProjectResources() {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.m_selectedElement != null && !this.m_selectedElement.isEmpty()) {
            Iterator elements = this.m_selectedElement.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = ((IAdaptable)next).getAdapter(class$org$eclipse$core$resources$IResource == null ? VfsObjectSelectionAction.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) instanceof IResource)) continue;
                resources.add(adapter);
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected Shell getShell() {
        if (this.m_targetPart != null) {
            return this.m_targetPart.getSite().getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    private IStructuredSelection getSelectionForAction() {
        if (this.getFolderItemsFromSelectedResources() != null) {
            return this.getFolderItemsFromSelectedResources();
        }
        return this.m_selectedElement;
    }

    protected String getConfigProperty(String propertyName, String defaultValue) {
        String value;
        if (this.m_configuration != null && (value = this.m_configuration.getAttribute(propertyName)) != null && !value.equals("")) {
            return value;
        }
        if (defaultValue != null && !defaultValue.equals("")) {
            return defaultValue;
        }
        return "?";
    }

    protected boolean isActionEnabled(IVfsFolderItem selection, VfsActionOnFolderItem action) {
        if (selection != null) {
            VfsActionOnFolderItem[] actions = SelectionUtil.getInstance().getAllowedActions(selection);
            int i = 0;
            while (i < actions.length) {
                if (actions[i] == action) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean isActionEnabled(IVfsActivity selection, VfsActionOnActivity action) {
        if (selection != null) {
            try {
                VfsActionOnActivity[] actions = SelectionUtil.getInstance().getAllowedActions(selection);
                if (actions != null) {
                    int i = 0;
                    while (i < actions.length) {
                        if (actions[i] == action) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return false;
    }

    protected boolean comeSelectionsFromSameWorkspace(IStructuredSelection selection) {
        return SelectionUtil.getInstance().comeSelectionsFromSameWorkspace(selection);
    }

    protected boolean isSelectedInView(String viewId) {
        if (viewId != null) {
            IViewSite viewSite;
            if (this.m_targetPart instanceof RepositoryView) {
                return viewId.equals(((RepositoryView)this.m_targetPart).getViewID());
            }
            if (this.m_targetPart instanceof ViewPart && (viewSite = ((ViewPart)this.m_targetPart).getViewSite()) != null) {
                return viewId.equalsIgnoreCase(viewSite.getId());
            }
        }
        return false;
    }

    protected Object[] getParentObjectForTreeSelection(Object selectedObject, int aboveLevel) {
        HashSet<Object> parents = new HashSet<Object>();
        if (this.m_targetPart instanceof RepositoryView) {
            if (aboveLevel < 1) {
                return new Object[]{selectedObject};
            }
            HashSet<TreeItem> correspondingTreeItems = new HashSet<TreeItem>();
            TreeItem[] selectedTreeItems = ((RepositoryView)this.m_targetPart).getRepositoryTreeViewer().getTreeViewer().getTree().getSelection();
            int i = 0;
            while (i < selectedTreeItems.length) {
                if (selectedTreeItems[i].getData().equals(selectedObject)) {
                    correspondingTreeItems.add(selectedTreeItems[i]);
                }
                ++i;
            }
            Iterator iter = correspondingTreeItems.iterator();
            while (iter.hasNext()) {
                TreeItem parentTreeItem = (TreeItem)iter.next();
                int i2 = 0;
                while (i2 < aboveLevel) {
                    if ((parentTreeItem = parentTreeItem.getParentItem()) == null) break;
                    ++i2;
                }
                if (parentTreeItem == null) continue;
                parents.add(parentTreeItem.getData());
            }
        }
        return parents.toArray();
    }

    protected void showMessage(String message, int messageType) {
        if (this.m_targetPart instanceof IViewPart) {
            IStatusLineManager statusLine = ((IViewPart)this.m_targetPart).getViewSite().getActionBars().getStatusLineManager();
            statusLine.setErrorMessage(null);
            statusLine.setMessage(null);
            switch (messageType) {
                case 3: {
                    statusLine.setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
                    break;
                }
                case 1: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_info_image"), message);
                    break;
                }
                case 2: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_warning_image"), message);
                    break;
                }
                default: {
                    statusLine.setMessage(message);
                    break;
                }
            }
        } else {
            switch (messageType) {
                case 3: {
                    Logbook.getErrorChapter().println(message);
                    break;
                }
                case 1: {
                    Logbook.getInfoChapter().println(message);
                    break;
                }
                case 2: {
                    Logbook.getWarnChapter().println(message);
                    break;
                }
                default: {
                    Logbook.getPlainChapter().println(message);
                }
            }
        }
    }

    protected void showErrorMessage(String message) {
        this.showMessage(message, 3);
    }

    public IStructuredSelection getFolderItemsFromSelectedResources() {
        return SelectionUtil.getInstance().getConvertedSelection();
    }

    protected IResource getProjectResource(IVfsFolderItem folderItem) {
        if (folderItem != null) {
            IVirtualFile localFile = folderItem.getLocalFile();
            if (localFile == null) {
                return null;
            }
            try {
                if (folderItem.asFile() != null) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(localFile.getCanonicalPath()));
                }
                return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(localFile.getCanonicalPath()));
            }
            catch (IOException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    protected IResource getProjectResource(IVfsVersion version, IVfsWorkspace workspace) {
        if (version != null) {
            try {
                return this.getProjectResource((IVfsFolderItem)version.getCorrespondingFile(workspace));
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    protected boolean isIgnoredForAdding(IVfsFolderItem folderItem) {
        return this.isIgnoredForAdding(this.getProjectResource(folderItem));
    }

    protected boolean isIgnoredForAdding(IResource resource) {
        return SelectionUtil.getInstance().isIgnoredForAdding(resource);
    }

    public void run(IAction action) {
        IStructuredSelection selection;
        if (this.m_targetPart instanceof IViewPart) {
            IStatusLineManager statusLine = ((IViewPart)this.m_targetPart).getViewSite().getActionBars().getStatusLineManager();
            statusLine.setErrorMessage(null);
            statusLine.setMessage(null);
        }
        if ((selection = this.getSelectionForAction()) == null) {
            this.showErrorMessage("Selection is <null>.");
            return;
        }
        if (this.showCommandOutputViewBeforeExecution()) {
            this.openCommandOutputView();
        }
        if (this.runWithinWorkerThread()) {
            this.execute(selection, action, new WorkerThreadProgressMonitor(this.m_targetPart));
        } else {
            this.execute(selection, action, null);
        }
        SelectionUtil.getInstance().clearCaches();
    }

    protected void executeFinalVfsAction(IVfsAction action) {
        if (this.runWithinWorkerThread()) {
            VfsActionManager.getInstance().doAsynchronously(action);
        } else {
            VfsActionManager.getInstance().doSynchronously(action);
        }
    }

    protected boolean showCommandOutputViewBeforeExecution() {
        return false;
    }

    protected void openCommandOutputView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)VfsObjectSelectionAction.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        IWorkbenchWindow actWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (actWindow == null) {
                            1.access$000(this.this$1).showErrorMessage("Active window is <null>.");
                            return;
                        }
                        IWorkbenchPage actPage = actWindow.getActivePage();
                        if (actPage == null) {
                            1.access$000(this.this$1).showErrorMessage("Active page is <null>.");
                            return;
                        }
                        try {
                            actPage.showView("com.tssap.dtr.client.eclipse.ui.loggerview");
                        }
                        catch (PartInitException x) {
                            LogUtil.logException((Location)VfsObjectSelectionAction.access$100(), (Throwable)x);
                        }
                    }
                });
            }

            static /* synthetic */ VfsObjectSelectionAction access$000(1 x0) {
                return x0.VfsObjectSelectionAction.this;
            }
        });
    }

    protected void showInConflictView(final IVfsWorkspace workspace) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)VfsObjectSelectionAction.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (3.access$200(this.this$1) != null) {
                            TreeViewer treeViewer;
                            RepositoryView conflictView = VfsObjectSelectionAction.access$400(3.access$300(this.this$1));
                            if (conflictView != null && (treeViewer = conflictView.getRepositoryTreeViewer().getTreeViewer()) != null) {
                                treeViewer.expandToLevel(2);
                                treeViewer.setSelection((ISelection)new StructuredSelection((Object)3.access$200(this.this$1)), true);
                                if (treeViewer.testFindItem((Object)3.access$200(this.this$1)) == null) {
                                    3.access$300(this.this$1).showErrorMessage("Could not find the workspace \"" + 3.access$200(this.this$1).getAbsoluteRemotePath() + "\". Check your workspace filter settings.");
                                } else {
                                    treeViewer.expandToLevel((Object)3.access$200(this.this$1), 1);
                                }
                            }
                        } else {
                            3.access$300(this.this$1).showErrorMessage("Could not find the corresponding workspace in Integration Conflict View.");
                        }
                    }
                });
            }

            static /* synthetic */ IVfsWorkspace access$200(3 x0) {
                return x0.workspace;
            }

            static /* synthetic */ VfsObjectSelectionAction access$300(3 x0) {
                return x0.VfsObjectSelectionAction.this;
            }
        });
    }

    private RepositoryView getIntegrationConflictView() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow actWindow = workbench.getActiveWorkbenchWindow();
        if (actWindow == null) {
            return null;
        }
        IWorkbenchPage actPage = actWindow.getActivePage();
        if (actPage == null) {
            return null;
        }
        IViewPart repositoryBrowser = null;
        IViewReference[] viewReferences = actPage.getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            IViewPart viewPart = viewReferences[i].getView(false);
            if (viewPart instanceof RepositoryView && ((RepositoryView)viewPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenCollisionView")) {
                repositoryBrowser = viewPart;
                break;
            }
            ++i;
        }
        if (repositoryBrowser == null) {
            try {
                if (!actPage.getPerspective().getId().equals("com.tssap.dtr.client.eclipse.DTRPerspective")) {
                    workbench.showPerspective("com.tssap.dtr.client.eclipse.DTRPerspective", actWindow);
                    actPage = actWindow.getActivePage();
                }
                repositoryBrowser = actPage.showView("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenCollisionView");
            }
            catch (WorkbenchException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        if (repositoryBrowser instanceof RepositoryView) {
            actPage.activate(repositoryBrowser);
            repositoryBrowser.setFocus();
        }
        this.setActivePart(null, actPage.getActivePart());
        return (RepositoryView)repositoryBrowser;
    }

    protected String[] getFilesWithIntegrationConflict(IVfsActivityRecordedFolderItem[] folderItems) {
        ArrayList<String> filesWithConflict = new ArrayList<String>();
        int i = 0;
        while (i < folderItems.length) {
            if (folderItems[i] instanceof IVfsFile && folderItems[i].asFile().hasIntegrateConflict()) {
                filesWithConflict.add(folderItems[i].getName());
            }
            ++i;
        }
        return filesWithConflict.toArray(new String[filesWithConflict.size()]);
    }

    protected abstract boolean allowedMultipleSelection();

    protected abstract boolean isEnabled(IStructuredSelection var1);

    protected abstract boolean runWithinWorkerThread();

    protected abstract void execute(IStructuredSelection var1, IAction var2, IVfsProgressMonitor var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Location access$100() {
        return LOCATION;
    }

    static /* synthetic */ RepositoryView access$400(VfsObjectSelectionAction x0) {
        return x0.getIntegrationConflictView();
    }
}

