/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionRelation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VersionRelationSelectionAction
extends VfsObjectSelectionAction {
    private static final String ACTION_NAME_ATTRIBUTE = "ActionName";
    private static final String NAVIGATE_TO_COLLISION_VIEW = "NavigateToCollisionView";
    private static final String UNDO_DISCARD = "UndoDiscard";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$VersionRelationSelectionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$VersionRelationSelectionAction = VersionRelationSelectionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.VersionRelationSelectionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$VersionRelationSelectionAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$VersionRelationSelectionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IVfsVersionRelation) {
            String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
            VfsVersionRelation versionRelation = (VfsVersionRelation)selection.getFirstElement();
            if (actionName.equalsIgnoreCase(UNDO_DISCARD)) {
                try {
                    if (versionRelation.getRelationType() != VfsVersionRelationType.DISCARD_MERGE || versionRelation.getCreatingActivity().getState() != VfsActivityState.OPEN) {
                        return false;
                    }
                }
                catch (VfsException e) {
                    this.showErrorMessage(e.getMessage());
                    LOCATION.errorT("Caught: " + e.getMessage());
                    return false;
                }
            }
            return versionRelation.getRelationType() == VfsVersionRelationType.PRED_SUCC_COLLISION || !actionName.equalsIgnoreCase(NAVIGATE_TO_COLLISION_VIEW);
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
        VfsVersionRelation versionRelation = (VfsVersionRelation)selection.getFirstElement();
        if (actionName.equalsIgnoreCase(UNDO_DISCARD)) {
            this.undoDiscard(versionRelation);
        } else if (actionName.equalsIgnoreCase(NAVIGATE_TO_COLLISION_VIEW)) {
            this.openCollisionView();
        }
    }

    private void openCollisionView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart view = page.showView("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenCollisionView");
            if (view instanceof RepositoryView) {
                ((RepositoryView)view).setFocus();
            }
        }
        catch (PartInitException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    private void undoDiscard(VfsVersionRelation versionRelation) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

