/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.actions.FolderItemAndActivityTuppel;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UndoCheckoutFolderAction
extends VfsObjectSelectionAction {
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Uncheckout Folder";
    private static final String DEFAULT_DIALOG_MESSAGE = "Select the activities the folder should be reverted in,\nbecause the selected folder was checked-out in several activities.";

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem = selection.getFirstElement();
        return selectedItem instanceof IVfsFolder && this.isActionEnabled((IVfsFolderItem)((IVfsFolder)selectedItem), VfsActionOnFolderItem.UNCHECKOUT);
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFolder folder = (IVfsFolder)selection.getFirstElement();
        IVfsActivity[] activities = folder.getOpenActivities();
        if (activities.length > 1) {
            if (this.m_targetPart instanceof RepositoryView && ((RepositoryView)this.m_targetPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView")) {
                Object[] parentObjects = this.getParentObjectForTreeSelection(folder, 1);
                if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsActivity) {
                    this.openCommandOutputView();
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem)folder, (IVfsActivity)parentObjects[0], workerThreadMonitor));
                }
            } else {
                String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
                String dialogMessage = this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE);
                SelectActivityDialog actDialog = new SelectActivityDialog(this.getShell(), activities, activities[0].getWorkspace(), true, dialogTitle, dialogMessage, 4, true);
                if (actDialog.open() == 0) {
                    this.openCommandOutputView();
                    IVfsActivity[] selectedActivities = actDialog.getActivitySelection();
                    FolderItemAndActivityTuppel[] tuppels = new FolderItemAndActivityTuppel[selectedActivities.length];
                    int i = 0;
                    while (i < selectedActivities.length) {
                        tuppels[i] = new FolderItemAndActivityTuppel((IVfsActivityRecordedFolderItem)folder, selectedActivities[i]);
                        ++i;
                    }
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction(tuppels, workerThreadMonitor));
                }
            }
        } else {
            this.openCommandOutputView();
            this.executeFinalVfsAction((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem)folder, workerThreadMonitor));
        }
    }
}

