/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.ActivitySelectionLabelProvider;
import com.tssap.dtr.client.eclipse.ui.MultipleSelectionMessageDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class UndoCheckoutAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$UndoCheckoutAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$UndoCheckoutAction = UndoCheckoutAction.class$("com.tssap.dtr.client.eclipse.ui.actions.UndoCheckoutAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$UndoCheckoutAction));
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Undo Checkout";
    private static final String DEFAULT_DIALOG_MESSAGE = "This action will result in the loss of all changes of non-local files. \n\nProceed with revert of selected resources?";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$UndoCheckoutAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFile;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivity;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivityElement;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof IVfsFile || item instanceof IVfsActivity || item instanceof IVfsActivityElement)) {
                return false;
            }
            if (item instanceof IVfsFile && !this.isActionEnabled((IVfsFolderItem)((IVfsFile)item), VfsActionOnFolderItem.UNCHECKOUT)) {
                return false;
            }
            if (item instanceof IVfsActivity && !this.isActionEnabled((IVfsActivity)item, VfsActionOnActivity.UNCHECKOUT)) {
                return false;
            }
            if (!(item instanceof IVfsActivityElement) || ((IVfsActivityElement)item).getAsVersion() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        Object firstSelected = selection.getFirstElement();
        if (firstSelected instanceof IVfsActivityElement) {
            this.handleUndoDiscard(selection);
            return;
        }
        String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
        String dialogMessage = this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE);
        if (selection.size() > 1) {
            if (firstSelected instanceof IVfsFile) {
                IVfsFile[] files = (IVfsFile[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFile == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFile = UndoCheckoutAction.class$("com.tssap.dtr.client.lib.vfs.IVfsFile")) : class$com$tssap$dtr$client$lib$vfs$IVfsFile);
                MultipleSelectionMessageDialog selectionDialog = new MultipleSelectionMessageDialog(this.getShell(), dialogTitle, dialogMessage, 4, (IVfsFolderItem[])files, (IVfsFolderItem[])files);
                if (selectionDialog.open() == 0) {
                    this.openCommandOutputView();
                    IStructuredSelection selected = selectionDialog.getReturnedSelection();
                    if (selected.size() != selection.size()) {
                        files = (IVfsFile[])Util.getArrayFromIterator(selected.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFile == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFile = UndoCheckoutAction.class$("com.tssap.dtr.client.lib.vfs.IVfsFile")) : class$com$tssap$dtr$client$lib$vfs$IVfsFile);
                    }
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem[])files, workerThreadMonitor));
                }
            } else if (firstSelected instanceof IVfsActivity) {
                IVfsActivity[] activities = (IVfsActivity[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = UndoCheckoutAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity);
                MultipleSelectionMessageDialog selectionDialog = new MultipleSelectionMessageDialog(this.getShell(), dialogTitle, dialogMessage, 4, activities);
                if (selectionDialog.open() == 0) {
                    this.openCommandOutputView();
                    IStructuredSelection selected = selectionDialog.getReturnedSelection();
                    if (selected.size() != selection.size()) {
                        activities = (IVfsActivity[])Util.getArrayFromIterator(selected.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = UndoCheckoutAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity);
                    }
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction(activities, workerThreadMonitor));
                }
            }
        } else {
            MessageDialog dialog = new MessageDialog(this.getShell(), dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (dialog.open() == 0) {
                this.openCommandOutputView();
                if (firstSelected instanceof IVfsFile) {
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction((IVfsActivityRecordedFolderItem)((IVfsFile)firstSelected), workerThreadMonitor));
                } else if (firstSelected instanceof IVfsActivity) {
                    this.executeFinalVfsAction((IVfsAction)new UncheckoutAction((IVfsActivity)firstSelected, workerThreadMonitor));
                }
            }
        }
    }

    private void handleUndoDiscard(IStructuredSelection selection) {
        if (selection.size() > 1) {
            MultipleSelectionMessageDialog warningDialog = new MultipleSelectionMessageDialog(this.getShell(), "Undo Discard", "Are you sure you want to revert the selected discard target versions?", 4, new ActivityElementContentProvider(), (ILabelProvider)new ActivitySelectionLabelProvider(), (IVfsActivityElement[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityElement == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityElement = UndoCheckoutAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityElement")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityElement));
            if (warningDialog.open() == 0) {
                this.openCommandOutputView();
                selection = warningDialog.getReturnedSelection();
            } else {
                return;
            }
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IVfsVersion targetVersion = null;
            IVfsActivity activity = null;
            IVfsActivityElement activityElement = (IVfsActivityElement)iter.next();
            if (activityElement == null) {
                this.showErrorMessage("Internal error: Unable to obtain activity element object.");
                continue;
            }
            targetVersion = activityElement.getAsVersion();
            if (targetVersion == null) {
                this.showErrorMessage("Internal error: Unable to obtain version object to undo discard.");
                continue;
            }
            IVfsActivity[] activities = activityElement.getActivities();
            if (activities == null || activities.length != 1 || activities[0] == null) {
                this.showErrorMessage("Internal error: Unable to obtain activity object.");
                continue;
            }
            activity = activities[0];
            try {
                targetVersion.undoDiscard(activity);
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ActivityElementContentProvider
    implements IStructuredContentProvider {
        private ActivityElementContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IVfsActivityElement[]) {
                return (IVfsActivityElement[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

