/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.calendar.CalendarInputDialog;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.SyncAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SyncToDateAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$SyncToDateAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$SyncToDateAction = SyncToDateAction.class$("com.tssap.dtr.client.eclipse.ui.actions.SyncToDateAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$SyncToDateAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$SyncToDateAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof IVfsFolderItem)) {
                return false;
            }
            if (this.isActionEnabled((IVfsFolderItem)item, VfsActionOnFolderItem.SYNC_TO_PREVIOUS)) continue;
            return false;
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.getDefault());
        CalendarInputDialog dialog = new CalendarInputDialog(this.getShell(), "Sync To Date", "Enter a date in the following format:\t" + dateFormat.format(new Date()) + "\n\n", dateFormat.format(new Date()), new IInputValidator(){

            public String isValid(String newText) {
                try {
                    dateFormat.parse(newText);
                    return null;
                }
                catch (ParseException x) {
                    return "Incorrect date format!";
                }
            }
        });
        if (dialog.open() == 0) {
            try {
                Date date = dateFormat.parse(dialog.getValue());
                IVfsFolderItem[] folderItems = (IVfsFolderItem[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem = SyncToDateAction.class$("com.tssap.dtr.client.lib.vfs.IVfsFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem);
                this.openCommandOutputView();
                this.executeFinalVfsAction((IVfsAction)new SyncAction(folderItems, date, workerThreadMonitor));
            }
            catch (ParseException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

