/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.OpenEditorAction;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SingleVersionSelectionAction
extends VfsObjectSelectionAction {
    private static final String ACTION_NAME_ATTRIBUTE = "ActionName";
    private static final String VIEW_VERSION = "ViewVersion";
    private static final String SYNC_TO_VERSION = "SyncToVersion";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$SingleVersionSelectionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$SingleVersionSelectionAction = SingleVersionSelectionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.SingleVersionSelectionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$SingleVersionSelectionAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$SingleVersionSelectionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        try {
            if (selected instanceof IVfsVersion && ((IVfsVersion)selected).isFile()) {
                IVfsVersion selectedVersion = (IVfsVersion)selected;
                String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
                return !actionName.equalsIgnoreCase(SYNC_TO_VERSION) || !selectedVersion.isOpen();
            }
            if (selected instanceof IVfsRevision && ((IVfsRevision)selected).getVersion().isFile()) {
                return true;
            }
            if (selected instanceof IVfsActivityElement) {
                return ((IVfsActivityElement)selected).getAsVersion() != null;
            }
        }
        catch (VfsException e) {
            this.showErrorMessage(e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        Object selected = selection.getFirstElement();
        IVfsVersion selectedVersion = selected instanceof IVfsVersion ? (IVfsVersion)selected : (selected instanceof IVfsRevision ? ((IVfsRevision)selected).getVersion() : ((IVfsActivityElement)selected).getAsVersion());
        try {
            if (!selectedVersion.isFile()) {
                return;
            }
        }
        catch (VfsException e) {
            this.showErrorMessage(e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return;
        }
        String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
        if (actionName != null) {
            if (actionName.equalsIgnoreCase(VIEW_VERSION)) {
                IVfsWorkspace workspace = null;
                workspace = this.m_targetPart instanceof VersionTreeView ? ((VersionTreeView)this.m_targetPart).getActiveWorkspace() : selectedVersion.getCreatorWorkspace();
                OpenEditorAction.showVersion(selectedVersion, workspace);
            } else if (actionName.equalsIgnoreCase(SYNC_TO_VERSION)) {
                this.syncToVersion(selectedVersion, selected);
            }
        } else {
            Logbook.getPlainChapter((int)3).println("Unknown action !");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void syncToVersion(final IVfsVersion version, Object selectedObject) {
        Object[] parentWorkspaces;
        String workspacePath = null;
        Shell activeShell = this.m_targetPart.getSite().getShell().getDisplay().getActiveShell();
        if (activeShell.getData() instanceof RevisionHistoryDialog) {
            RevisionHistoryDialog revisionHistoryDialog = (RevisionHistoryDialog)((Object)activeShell.getData());
            workspacePath = revisionHistoryDialog.getWorkspace().getAbsoluteRemotePath();
        } else if (this.m_targetPart instanceof VersionTreeView) {
            IVfsWorkspace workspace = ((VersionTreeView)this.m_targetPart).getActiveWorkspace();
            if (workspace == null) {
                this.showErrorMessage("Unable to sync to this version: workspace object not found ( " + ((VersionTreeView)this.m_targetPart).getActiveWorkspacePath() + " )");
                return;
            }
            workspacePath = workspace.getAbsoluteRemotePath();
        } else if (this.m_targetPart instanceof RepositoryView && (parentWorkspaces = this.getParentObjectForTreeSelection(selectedObject, 2)).length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
            workspacePath = ((IVfsWorkspace)parentWorkspaces[0]).getAbsoluteRemotePath();
        }
        final IVfsContext context = version.getVersionedFileSystemManager().getCurrentContext();
        final String workspaceRemotePath = workspacePath;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                try {
                    version.syncToVersion(workspaceRemotePath, context);
                }
                catch (VfsException e) {
                    SingleVersionSelectionAction.this.showErrorMessage(e.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

