/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowVersionGraphAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$ShowVersionGraphAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$ShowVersionGraphAction = ShowVersionGraphAction.class$("com.tssap.dtr.client.eclipse.ui.actions.ShowVersionGraphAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$ShowVersionGraphAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$ShowVersionGraphAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof IVfsFile && !((IVfsFile)selected).getLocationState().equals(VfsFolderItemLocationState.LOCAL_ONLY) && !((IVfsFile)selected).isInconsistent()) {
            return true;
        }
        if (selected instanceof IVfsVersion) {
            Shell activeShell = this.m_targetPart.getSite().getShell().getDisplay().getActiveShell();
            if (activeShell.getData() instanceof RevisionHistoryDialog) {
                return false;
            }
            if (this.m_targetPart instanceof RepositoryView) {
                try {
                    if (((IVfsVersion)selected).isFile()) {
                        return true;
                    }
                }
                catch (VfsException x) {
                    this.showErrorMessage(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            }
        } else if (selected instanceof IVfsActivityElement) {
            return true;
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(final IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IViewPart view = page.showView("com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView");
                    if (view instanceof VersionTreeView) {
                        ((VersionTreeView)view).setWorkspaceSelection(ShowVersionGraphAction.this.getWorkspace(selection));
                        ((VersionTreeView)view).selectReveal((ISelection)selection);
                    }
                }
                catch (PartInitException x) {
                    ShowVersionGraphAction.this.showErrorMessage("Show version graph failed: " + x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private IVfsWorkspace getWorkspace(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof IVfsFile) {
            return ((IVfsFile)selected).getWorkspace();
        }
        if (selected instanceof IVfsVersion) {
            IVfsVersion version = (IVfsVersion)selected;
            if (this.m_targetPart instanceof RepositoryView) {
                Object[] parentObjects = this.getParentObjectForTreeSelection(selected, 1);
                if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsIntegrateCollision) {
                    IVfsIntegrateCollision parentCollision = (IVfsIntegrateCollision)parentObjects[0];
                    try {
                        if (version.getVersionId().equalsIgnoreCase(parentCollision.getActiveVersion().getVersionId())) {
                            return parentCollision.getWorkspace();
                        }
                        return parentCollision.getIntegratedActivity().getCreationWorkspace();
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        return null;
                    }
                }
                Object[] parentWorkspaces = this.getParentObjectForTreeSelection(selected, 2);
                if (parentWorkspaces.length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
                    return (IVfsWorkspace)parentWorkspaces[0];
                }
            }
        } else {
            if (selected instanceof IVfsIntegrateCollision) {
                return ((IVfsIntegrateCollision)selected).getWorkspace();
            }
            if (selected instanceof IVfsActivityElement) {
                return ((IVfsActivityElement)selected).getWorkspace();
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

