/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowRevisionHistoryAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$ShowRevisionHistoryAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$ShowRevisionHistoryAction = ShowRevisionHistoryAction.class$("com.tssap.dtr.client.eclipse.ui.actions.ShowRevisionHistoryAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$ShowRevisionHistoryAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$ShowRevisionHistoryAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof IVfsFile && !((IVfsFile)selected).getLocationState().equals(VfsFolderItemLocationState.LOCAL_ONLY) && !((IVfsFile)selected).isInconsistent()) {
            return true;
        }
        if (selected instanceof IVfsVersion) {
            Shell activeShell = this.m_targetPart.getSite().getShell().getDisplay().getActiveShell();
            if (activeShell.getData() instanceof RevisionHistoryDialog) {
                return false;
            }
            if (this.m_targetPart instanceof RepositoryView || this.m_targetPart instanceof VersionTreeView) {
                try {
                    if (((IVfsVersion)selected).isFile()) {
                        return true;
                    }
                }
                catch (VfsException x) {
                    this.showErrorMessage(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            }
        } else if (selected instanceof IVfsIntegrateCollision || selected instanceof IVfsActivityElement) {
            return true;
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        final Object selected = selection.getFirstElement();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                IVfsRevision[] allRevisions = null;
                IVfsWorkspace workspace = null;
                IVfsVersionHistory versionHistory = null;
                IVfsVersion version = null;
                if (selected instanceof IVfsFile) {
                    IVfsFile file = (IVfsFile)selected;
                    try {
                        version = file.refreshAndGetVersion();
                    }
                    catch (VfsException e) {
                        ShowRevisionHistoryAction.this.showErrorMessage("Unable to show revision history : " + e.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        return;
                    }
                    workspace = file.getWorkspace();
                } else if (selected instanceof IVfsVersion) {
                    version = (IVfsVersion)selected;
                    if (ShowRevisionHistoryAction.this.m_targetPart instanceof VersionTreeView) {
                        workspace = ((VersionTreeView)ShowRevisionHistoryAction.this.m_targetPart).getActiveWorkspace();
                    } else if (ShowRevisionHistoryAction.this.m_targetPart instanceof RepositoryView) {
                        workspace = ShowRevisionHistoryAction.this.getWorkspaceFromRepositoryViewSelection(selected);
                    }
                } else if (selected instanceof IVfsIntegrateCollision) {
                    IVfsIntegrateCollision collision = (IVfsIntegrateCollision)selected;
                    version = collision.getActiveVersion();
                    workspace = collision.getWorkspace();
                } else if (selected instanceof IVfsActivityElement) {
                    version = ((IVfsActivityElement)selected).getAsVersion();
                    if (version != null) {
                        workspace = ((IVfsActivityElement)selected).getWorkspace();
                    } else {
                        IVfsFile file;
                        IVfsActivityRecordedFolderItem folderItem = ((IVfsActivityElement)selected).getAsActivityRecordedFolderItem();
                        if (folderItem != null && (file = folderItem.asFile()) != null) {
                            try {
                                version = file.refreshAndGetVersion();
                            }
                            catch (VfsException e) {
                                ShowRevisionHistoryAction.this.showErrorMessage("Unable to show revision history : " + e.getMessage());
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                                return;
                            }
                            workspace = file.getWorkspace();
                        }
                    }
                }
                if (workspace == null) {
                    ShowRevisionHistoryAction.this.showErrorMessage("Unable to show revision history : could not retrieve workspace object. ");
                    return;
                }
                versionHistory = version.getVersionHistory();
                if (versionHistory == null) {
                    ShowRevisionHistoryAction.this.showErrorMessage("Unable to show revision history : could not retrieve version history of resource. ");
                    return;
                }
                allRevisions = versionHistory.getRevisionsInWorkspace(workspace.getAbsoluteRemotePath());
                ArrayList<IVfsRevision> listOfRevisions = new ArrayList<IVfsRevision>();
                int i = 0;
                while (i < allRevisions.length) {
                    listOfRevisions.add(allRevisions[i]);
                    ++i;
                }
                RevisionHistoryDialog dialog = new RevisionHistoryDialog(ShowRevisionHistoryAction.this.getShell(), "Revision History", null);
                IVfsVersion syncdVersion = versionHistory.getVersionInClientWorkspace(workspace);
                dialog.setInput(listOfRevisions, workspace, syncdVersion);
                dialog.open();
            }
        });
    }

    private IVfsWorkspace getWorkspaceFromRepositoryViewSelection(Object version) {
        Object[] parentObjects = this.getParentObjectForTreeSelection(version, 1);
        if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsIntegrateCollision && version instanceof IVfsVersion) {
            IVfsIntegrateCollision parentCollision = (IVfsIntegrateCollision)parentObjects[0];
            try {
                if (((IVfsVersion)version).getVersionId().equalsIgnoreCase(parentCollision.getActiveVersion().getVersionId())) {
                    return parentCollision.getWorkspace();
                }
                return parentCollision.getIntegratedActivity().getWorkspace();
            }
            catch (VfsException e) {
                this.showErrorMessage("Unable to show in Revision History : " + e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        } else {
            Object[] parentWorkspaces = this.getParentObjectForTreeSelection(version, 2);
            if (parentWorkspaces.length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
                return (IVfsWorkspace)parentWorkspaces[0];
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

