/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ShowInRepositoryBrowserAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$ShowInRepositoryBrowserAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$ShowInRepositoryBrowserAction = ShowInRepositoryBrowserAction.class$("com.tssap.dtr.client.eclipse.ui.actions.ShowInRepositoryBrowserAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$ShowInRepositoryBrowserAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$ShowInRepositoryBrowserAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        if (this.m_targetPart instanceof RepositoryView && ((RepositoryView)this.m_targetPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView")) {
            return false;
        }
        Object selected = selection.getFirstElement();
        if (selected instanceof IVfsFolderItem) {
            return !(selected instanceof IVfsActivityRecordedFolderItem) || !((IVfsActivityRecordedFolderItem)selected).isInconsistent();
        }
        if (selected instanceof IVfsIntegrateCollision || selected instanceof IVfsActivityElement) {
            return true;
        }
        if (selected instanceof IVfsVersion) {
            Shell activeShell = this.m_targetPart.getSite().getShell().getDisplay().getActiveShell();
            if (activeShell.getData() instanceof RevisionHistoryDialog) {
                return false;
            }
            if (this.m_targetPart instanceof VersionTreeView) {
                IVfsWorkspace workspace = ((VersionTreeView)this.m_targetPart).getActiveWorkspace();
                if (workspace != null) {
                    IVfsVersion selectedVersion = (IVfsVersion)selected;
                    try {
                        if (selectedVersion.isVisibleInWorkspace(workspace.getAbsoluteRemotePath())) {
                            return true;
                        }
                    }
                    catch (VfsException e) {}
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        final Object selected = selection.getFirstElement();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IVfsFolderItem folderItem = null;
                try {
                    IVfsVersion version;
                    if (selected instanceof IVfsFolderItem) {
                        folderItem = (IVfsFolderItem)selected;
                    } else if (selected instanceof IVfsVersion) {
                        IVfsWorkspace workspace;
                        version = (IVfsVersion)selected;
                        if (ShowInRepositoryBrowserAction.this.m_targetPart instanceof RepositoryView) {
                            Object[] parentObjects = ShowInRepositoryBrowserAction.this.getParentObjectForTreeSelection(version, 1);
                            if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsIntegrateCollision) {
                                IVfsIntegrateCollision parentCollision = (IVfsIntegrateCollision)parentObjects[0];
                                if (version.getVersionId().equalsIgnoreCase(parentCollision.getActiveVersion().getVersionId())) {
                                    folderItem = version.getCorrespondingFolderItem(parentCollision.getWorkspace());
                                } else {
                                    IVfsWorkspace sourceWorkspace = parentCollision.getIntegratedActivity().getWorkspace();
                                    folderItem = version.getCorrespondingFolderItem(sourceWorkspace);
                                }
                            } else {
                                Object[] parentWorkspaces = ShowInRepositoryBrowserAction.this.getParentObjectForTreeSelection(version, 2);
                                if (parentWorkspaces.length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
                                    folderItem = version.getCorrespondingFolderItem((IVfsWorkspace)parentWorkspaces[0]);
                                }
                            }
                        } else if (ShowInRepositoryBrowserAction.this.m_targetPart instanceof VersionTreeView && (workspace = ((VersionTreeView)ShowInRepositoryBrowserAction.this.m_targetPart).getActiveWorkspace()) != null) {
                            folderItem = version.getCorrespondingFolderItem(workspace);
                        }
                    } else if (selected instanceof IVfsIntegrateCollision) {
                        folderItem = ((IVfsIntegrateCollision)selected).getActiveVersionFolderItem();
                    } else if (selected instanceof IVfsActivityElement && (folderItem = ((IVfsActivityElement)selected).getAsActivityRecordedFolderItem()) == null && (version = ((IVfsActivityElement)selected).getAsVersion()) != null) {
                        folderItem = version.getCorrespondingFolderItem(((IVfsActivityElement)selected).getWorkspace());
                    }
                }
                catch (VfsException x) {
                    ShowInRepositoryBrowserAction.this.showErrorMessage("Show in repository browser failed: " + x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    return;
                }
                if (folderItem != null) {
                    TreeViewer treeViewer;
                    RepositoryView repositoryBrowser = ShowInRepositoryBrowserAction.this.getRepositoryBrowser();
                    if (repositoryBrowser != null && (treeViewer = repositoryBrowser.getRepositoryTreeViewer().getTreeViewer()) != null) {
                        treeViewer.setSelection((ISelection)new StructuredSelection((Object)folderItem), true);
                        if (treeViewer.testFindItem((Object)folderItem) == null) {
                            try {
                                ShowInRepositoryBrowserAction.this.showErrorMessage("Could not find \"" + folderItem.getBrowsePath() + "\".");
                            }
                            catch (VfsException x) {
                                ShowInRepositoryBrowserAction.this.showErrorMessage("Could not find the corresponding folder item in repository browser.");
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                            }
                        }
                    }
                } else {
                    ShowInRepositoryBrowserAction.this.showErrorMessage("Could not find the corresponding folder item in repository browser.");
                }
            }
        });
    }

    private RepositoryView getRepositoryBrowser() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow actWindow = workbench.getActiveWorkbenchWindow();
        if (actWindow == null) {
            return null;
        }
        IWorkbenchPage actPage = actWindow.getActivePage();
        if (actPage == null) {
            return null;
        }
        IViewPart repositoryBrowser = null;
        IViewReference[] viewReferences = actPage.getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            IViewPart viewPart = viewReferences[i].getView(false);
            if (viewPart instanceof RepositoryView && ((RepositoryView)viewPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView")) {
                repositoryBrowser = viewPart;
                break;
            }
            ++i;
        }
        if (repositoryBrowser == null) {
            try {
                if (!actPage.getPerspective().getId().equals("com.tssap.dtr.client.eclipse.DTRPerspective")) {
                    workbench.showPerspective("com.tssap.dtr.client.eclipse.DTRPerspective", actWindow);
                    actPage = actWindow.getActivePage();
                }
                repositoryBrowser = actPage.showView("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView");
            }
            catch (WorkbenchException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        if (repositoryBrowser instanceof RepositoryView) {
            actPage.activate(repositoryBrowser);
            repositoryBrowser.setFocus();
        }
        this.setActivePart(null, actPage.getActivePart());
        return (RepositoryView)repositoryBrowser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

