/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.ShowInActivityViewAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ShowInOpenActivityViewAction
extends ShowInActivityViewAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$ShowInOpenActivityViewAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$ShowInOpenActivityViewAction = ShowInOpenActivityViewAction.class$("com.tssap.dtr.client.eclipse.ui.actions.ShowInOpenActivityViewAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$ShowInOpenActivityViewAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$ShowInOpenActivityViewAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        IVfsVersion version;
        if (selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            return ((IVfsIntegrateCollision)selection.getFirstElement()).getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT);
        }
        if (selection.getFirstElement() instanceof IVfsVersion && (version = (IVfsVersion)selection.getFirstElement()).isOpen()) {
            IVfsFile file;
            try {
                if (version.getCreatorWorkspace() == null) {
                    return false;
                }
                file = version.getRepresentingFile(version.getCreatorWorkspace());
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return false;
            }
            if (file != null && file.getLocalFile().exists()) {
                return true;
            }
        }
        if (this.m_targetPart instanceof RepositoryView && ((RepositoryView)this.m_targetPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView")) {
            return false;
        }
        Object selected = selection.getFirstElement();
        return selected instanceof IVfsActivityRecordedFolderItem && !VfsFolderItemActivityState.NOT_CHECKED_OUT.equals(((IVfsActivityRecordedFolderItem)selected).getActivityState());
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsActivity[] activities;
        IVfsActivityRecordedFolderItem folderItem;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IVfsIntegrateCollision) {
            selectedElement = ((IVfsIntegrateCollision)selectedElement).getMergeVersion();
        }
        if (selectedElement instanceof IVfsVersion) {
            IVfsVersion version = (IVfsVersion)selectedElement;
            try {
                IVfsWorkspace workspace = version.getCreatorWorkspace();
                if (workspace == null) {
                    this.showErrorMessage("Unable to retrieve workspace from selected version : " + version.getCreatorWorkspaceName());
                    return;
                }
                folderItem = version.getRepresentingFile(workspace);
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                this.showErrorMessage("Unable to rerieve file representing selected version: " + version.getDisplayName());
                return;
            }
        } else {
            folderItem = (IVfsActivityRecordedFolderItem)selectedElement;
        }
        if ((activities = folderItem.getOpenActivities()) == null || activities[0] == null) {
            this.showErrorMessage("Invalid activity state.");
            return;
        }
        RepositoryView openActivityView = this.getActivityView("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView");
        this.navigateToView(openActivityView, folderItem, activities);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

