/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class ShowInActivityViewAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$ShowInActivityViewAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$ShowInActivityViewAction = ShowInActivityViewAction.class$("com.tssap.dtr.client.eclipse.ui.actions.ShowInActivityViewAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$ShowInActivityViewAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$ShowInActivityViewAction;

    private void navigateToActivityView(TreeViewer treeViewer, IVfsActivity[] activities, IVfsWorkspace[] workspaces) {
        int hits = 0;
        treeViewer.expandToLevel(2);
        treeViewer.setSelection((ISelection)new StructuredSelection((Object[])workspaces), false);
        int i = 0;
        while (i < workspaces.length) {
            if (treeViewer.testFindItem((Object)workspaces[i]) != null) {
                treeViewer.expandToLevel((Object)workspaces[i], 1);
            }
            ++i;
        }
        treeViewer.setSelection((ISelection)new StructuredSelection((Object[])activities), true);
        int i2 = 0;
        while (i2 < activities.length) {
            if (treeViewer.testFindItem((Object)activities[i2]) != null) {
                ++hits;
                treeViewer.expandToLevel((Object)activities[i2], 1);
            }
            ++i2;
        }
        if (hits == activities.length) {
            this.showMessage("The selected resource was checked-out in " + hits + " different activities.", 1);
        } else {
            int notFound = activities.length - hits;
            String act = notFound > 1 ? "activities" : "activity";
            this.showErrorMessage("The selected resource was checked-out in " + hits + " different activities. " + notFound + " " + act + " could not be found in open activity view.");
        }
    }

    private void navigateToActivityView(TreeViewer treeViewer, Object destination, Object activity, IVfsWorkspace workspace) {
        treeViewer.expandToLevel(2);
        treeViewer.setSelection((ISelection)new StructuredSelection((Object)workspace), false);
        if (treeViewer.testFindItem((Object)workspace) != null) {
            treeViewer.expandToLevel((Object)workspace, 1);
            treeViewer.setSelection((ISelection)new StructuredSelection(activity), false);
            if (treeViewer.testFindItem(activity) != null) {
                treeViewer.expandToLevel(activity, 1);
                treeViewer.setSelection((ISelection)new StructuredSelection(destination), true);
            }
        }
        if (treeViewer.testFindItem(destination) == null) {
            this.showErrorMessage("Could not find the corresponding resource in open activity view.");
        }
    }

    protected RepositoryView getActivityView(String viewID) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow actWindow = workbench.getActiveWorkbenchWindow();
        if (actWindow == null) {
            return null;
        }
        IWorkbenchPage actPage = actWindow.getActivePage();
        if (actPage == null) {
            return null;
        }
        IViewPart openActivityView = null;
        IViewReference[] viewReferences = actPage.getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            IViewPart viewPart = viewReferences[i].getView(false);
            if (viewPart instanceof RepositoryView && ((RepositoryView)viewPart).getViewID().equals(viewID)) {
                openActivityView = viewPart;
                break;
            }
            ++i;
        }
        if (openActivityView == null) {
            try {
                if (!actPage.getPerspective().getId().equals("com.tssap.dtr.client.eclipse.DTRPerspective")) {
                    workbench.showPerspective("com.tssap.dtr.client.eclipse.DTRPerspective", actWindow);
                    actPage = actWindow.getActivePage();
                }
                openActivityView = actPage.showView(viewID);
            }
            catch (WorkbenchException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        if (openActivityView instanceof RepositoryView) {
            actPage.activate(openActivityView);
            openActivityView.setFocus();
        }
        this.setActivePart(null, actPage.getActivePart());
        return (RepositoryView)openActivityView;
    }

    protected void navigateToView(final RepositoryView activityView, final Object destination, final Object activities) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){
            static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;

            public void run() {
                if (activityView == null) {
                    ShowInActivityViewAction.this.showErrorMessage("Retrieving activity view faild.");
                    return;
                }
                TreeViewer treeViewer = activityView.getRepositoryTreeViewer().getTreeViewer();
                if (treeViewer == null) {
                    return;
                }
                if (activities instanceof ClosedActivityWrapper) {
                    IVfsWorkspace workspace = ((ClosedActivityWrapper)activities).workspace;
                    ShowInActivityViewAction.this.navigateToActivityView(treeViewer, destination, activities, workspace);
                    return;
                }
                if (activities instanceof IVfsActivity[]) {
                    IVfsActivity[] act = (IVfsActivity[])activities;
                    if (act.length == 1) {
                        IVfsWorkspace workspace = act[0].getWorkspace();
                        ShowInActivityViewAction.this.navigateToActivityView(treeViewer, destination, act[0], workspace);
                    } else if (act.length > 1) {
                        HashSet<IVfsWorkspace> workspaces = new HashSet<IVfsWorkspace>();
                        int i = 0;
                        while (i < act.length) {
                            IVfsWorkspace workspace = act[i].getWorkspace();
                            if (workspace != null) {
                                workspaces.add(workspace);
                            }
                            ++i;
                        }
                        if (!workspaces.isEmpty()) {
                            ShowInActivityViewAction.this.navigateToActivityView(treeViewer, act, (IVfsWorkspace[])Util.getArrayFromIterator(workspaces.iterator(), 1.class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (1.class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = 1.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : 1.class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace));
                        }
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

