/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class SetDefaultActivityAction
extends VfsObjectSelectionAction {
    private static final String MSG_DLG_TITLE = "Select Default Activity";
    private static final String MSG_DLG_MESSAGE_1 = "Currently you do not have any open activity for workspace";
    private static final String MSG_DLG_MESSAGE_2 = "A default activity will be used on demand.";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$SetDefaultActivityAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$SetDefaultActivityAction = SetDefaultActivityAction.class$("com.tssap.dtr.client.eclipse.ui.actions.SetDefaultActivityAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$SetDefaultActivityAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$SetDefaultActivityAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem = selection.getFirstElement();
        if (selectedItem instanceof IVfsWorkspace) {
            return true;
        }
        if (selectedItem instanceof IVfsActivity) {
            try {
                if (((IVfsActivity)selectedItem).isOpen() && !((IVfsActivity)selectedItem).isDefaultActivity()) {
                    return true;
                }
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        Object selectedItem = selection.getFirstElement();
        try {
            if (selectedItem instanceof IVfsWorkspace) {
                IVfsWorkspace ws = (IVfsWorkspace)selectedItem;
                if (ws.getActivities(VfsActivityState.OPEN).length + ws.getEmptyActivities().length < 1) {
                    String wsName = ws.getDisplayName();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)MSG_DLG_TITLE, (String)("Currently you do not have any open activity for workspace \"" + wsName + "\".\n" + MSG_DLG_MESSAGE_2));
                    if (!WorkspacesWithDefaultActivity.usingDefaultActivity(ws)) {
                        this.openCommandOutputView();
                    }
                    WorkspacesWithDefaultActivity.addWorkspace(ws);
                } else {
                    SelectActivityDialog selectActivity = new SelectActivityDialog(this.getShell(), ws);
                    if (selectActivity.open() == 0) {
                        ws.setDefaultActivity(selectActivity.getActivitySelection()[0]);
                        if (!WorkspacesWithDefaultActivity.usingDefaultActivity(ws)) {
                            this.openCommandOutputView();
                        }
                        WorkspacesWithDefaultActivity.addWorkspace(ws);
                    }
                }
            } else if (selectedItem instanceof IVfsActivity) {
                IVfsWorkspace ws = ((IVfsActivity)selectedItem).getWorkspace();
                ws.setDefaultActivity((IVfsActivity)selectedItem);
                if (!WorkspacesWithDefaultActivity.usingDefaultActivity(ws)) {
                    this.openCommandOutputView();
                }
                WorkspacesWithDefaultActivity.addWorkspace(ws);
            }
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

