/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.workspaceMonitor.MonitorType;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.Team;

final class SelectionUtil {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$SelectionUtil == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$SelectionUtil = SelectionUtil.class$("com.tssap.dtr.client.eclipse.ui.actions.SelectionUtil")) : class$com$tssap$dtr$client$eclipse$ui$actions$SelectionUtil));
    private static SelectionUtil m_instance;
    private IStructuredSelection m_currentSelection;
    private Set m_setOfCurrentSelection;
    private IStructuredSelection m_convertedSelection;
    private boolean m_convertionFailed;
    private Map m_mapVfsObjectAndAllowedActions = new HashMap();
    private Map m_mapSelectionCompareResults = new HashMap();
    private Map m_mapProjectAndExcludedResources = new HashMap();
    private Boolean m_isSelectionFromSameWorkspace;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$SelectionUtil;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public static synchronized SelectionUtil getInstance() {
        if (m_instance == null) {
            m_instance = new SelectionUtil();
        }
        return m_instance;
    }

    private SelectionUtil() {
    }

    void checkSelection(IStructuredSelection selection) throws VfsException {
        if (selection == null && this.m_currentSelection != null) {
            this.resetSelection(selection);
            this.resetCaches(selection);
        } else if (selection != null && !selection.equals(this.m_currentSelection)) {
            this.resetSelection(selection);
            if (this.isReallyDifferentSelection(selection)) {
                this.resetCaches(selection);
            }
        }
    }

    private void resetSelection(IStructuredSelection selection) {
        this.m_currentSelection = selection;
        this.m_setOfCurrentSelection = null;
    }

    private void resetCaches(IStructuredSelection selection) throws VfsException {
        this.clearCaches();
        this.m_convertionFailed = false;
        this.m_convertedSelection = this.convertAdaptableObjectSelection(selection);
    }

    void clearCaches() {
        this.m_mapSelectionCompareResults.clear();
        this.m_mapVfsObjectAndAllowedActions.clear();
        this.m_mapProjectAndExcludedResources.clear();
        this.m_isSelectionFromSameWorkspace = null;
    }

    private boolean isReallyDifferentSelection(IStructuredSelection newSelection) {
        if (!this.m_mapSelectionCompareResults.containsKey(newSelection)) {
            if (this.m_currentSelection == null || this.m_currentSelection.size() != newSelection.size()) {
                this.m_mapSelectionCompareResults.put(newSelection, Boolean.TRUE);
            } else {
                if (this.m_setOfCurrentSelection == null) {
                    this.m_setOfCurrentSelection = new HashSet(this.m_currentSelection.toList());
                }
                HashSet setOfNewSelection = new HashSet(newSelection.toList());
                this.m_setOfCurrentSelection.retainAll(setOfNewSelection);
                this.m_mapSelectionCompareResults.put(newSelection, new Boolean(this.m_currentSelection.size() != 0));
            }
        }
        return (Boolean)this.m_mapSelectionCompareResults.get(newSelection);
    }

    private IStructuredSelection convertAdaptableObjectSelection(IStructuredSelection selection) throws VfsException {
        if (selection != null) {
            if (selection.getFirstElement() instanceof IAdaptable) {
                HashSet<IVfsFolderItem> folderItems = new HashSet<IVfsFolderItem>();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    Object adapter = ((IAdaptable)iter.next()).getAdapter(class$org$eclipse$core$resources$IResource == null ? SelectionUtil.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                    if (!(adapter instanceof IResource)) continue;
                    IResource resource = (IResource)adapter;
                    IPath path = resource.getLocation();
                    if (path == null) {
                        this.m_convertionFailed = true;
                        LOCATION.warningT("No eclipse resource path");
                        return null;
                    }
                    String resourcePath = path.toOSString();
                    DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(resource);
                    if (provider == null) {
                        this.m_convertionFailed = true;
                        LOCATION.warningT("No team provider for resouce \"" + resourcePath + "\"");
                        return null;
                    }
                    IVersionedFileSystemManager manager = provider.getVFSManager();
                    if (manager == null) {
                        this.m_convertionFailed = true;
                        LOCATION.warningT("No VFS managerfor resouce \"" + resourcePath + "\"");
                        return null;
                    }
                    IVfsFolderItem item = manager.getFolderItem(resourcePath);
                    if (item != null) {
                        folderItems.add(item);
                        continue;
                    }
                    this.m_convertionFailed = true;
                    LOCATION.warningT("No folder item resouce \"" + resourcePath + "\"");
                    return null;
                }
                return new StructuredSelection(folderItems.toArray());
            }
            return selection;
        }
        return null;
    }

    IStructuredSelection getConvertedSelection() {
        return this.m_convertedSelection;
    }

    boolean isConvertionFailed() {
        return this.m_convertionFailed;
    }

    VfsActionOnFolderItem[] getAllowedActions(IVfsFolderItem folderItem) {
        if (folderItem == null) {
            return null;
        }
        if (!this.m_mapVfsObjectAndAllowedActions.containsKey(folderItem)) {
            this.m_mapVfsObjectAndAllowedActions.put(folderItem, folderItem.getActionsForCurrentState());
        }
        return (VfsActionOnFolderItem[])this.m_mapVfsObjectAndAllowedActions.get(folderItem);
    }

    VfsActionOnActivity[] getAllowedActions(IVfsActivity activity) throws VfsException {
        if (activity == null) {
            return null;
        }
        if (!this.m_mapVfsObjectAndAllowedActions.containsKey(activity)) {
            this.m_mapVfsObjectAndAllowedActions.put(activity, null);
            this.m_mapVfsObjectAndAllowedActions.put(activity, activity.getActionsForCurrentState());
        }
        return (VfsActionOnActivity[])this.m_mapVfsObjectAndAllowedActions.get(activity);
    }

    boolean comeSelectionsFromSameWorkspace(IStructuredSelection selection) {
        if (this.m_isSelectionFromSameWorkspace == null) {
            this.m_isSelectionFromSameWorkspace = Boolean.TRUE;
            if (selection != null && selection.size() > 1) {
                IVfsWorkspace firstWS = null;
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (!(item instanceof IVfsActivityRecordedFolderItem)) {
                        this.m_isSelectionFromSameWorkspace = Boolean.FALSE;
                        break;
                    }
                    IVfsWorkspace workspace = ((IVfsActivityRecordedFolderItem)item).getWorkspace();
                    if (firstWS == null) {
                        firstWS = workspace;
                        continue;
                    }
                    if (firstWS.equals(workspace)) continue;
                    this.m_isSelectionFromSameWorkspace = Boolean.FALSE;
                    break;
                }
            }
        }
        return this.m_isSelectionFromSameWorkspace;
    }

    boolean isIgnoredForAdding(IResource resource) {
        if (resource != null) {
            IPath path = resource.getLocation();
            if (path == null) {
                return true;
            }
            if (Team.isIgnoredHint((IResource)resource)) {
                return true;
            }
            IProject project = this.checkExcludedProjectResources(resource);
            if (project == null) {
                return true;
            }
            IResource[] ignoredResources = (IResource[])this.m_mapProjectAndExcludedResources.get(project);
            if (ignoredResources != null) {
                int i = 0;
                while (i < ignoredResources.length) {
                    if (ignoredResources[i].getType() == 2) {
                        IPath ignoredFolderPath = ignoredResources[i].getLocation();
                        if (ignoredFolderPath == null) {
                            return true;
                        }
                        if (ignoredFolderPath.isPrefixOf(path)) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private IProject checkExcludedProjectResources(IResource resource) {
        IProject project;
        if (resource != null && (project = resource.getProject()) != null) {
            if (!this.m_mapProjectAndExcludedResources.containsKey(project)) {
                IResource[] resources = WorkspaceMonitor.getInstance().getExcludedResources(project, MonitorType.ADD);
                this.m_mapProjectAndExcludedResources.put(project, resources);
            }
            return project;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

