/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.remoteeditor.EditorInputFactory;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.dialogEditor.DialogEditor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenEditorAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$OpenEditorAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$OpenEditorAction = OpenEditorAction.class$("com.tssap.dtr.client.eclipse.ui.actions.OpenEditorAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$OpenEditorAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$OpenEditorAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        return selected instanceof IVfsFile || selected instanceof IVfsActivityElement;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsVersion version;
        Object selected = selection.getFirstElement();
        if (selected instanceof IVfsFile) {
            OpenEditorAction.showFile((IVfsFile)selected);
        } else if (selected instanceof IVfsActivityElement && (version = ((IVfsActivityElement)selected).getAsVersion()) != null) {
            OpenEditorAction.showVersion(version, ((IVfsActivityElement)selected).getWorkspace());
        }
    }

    public static void showVersion(IVfsVersion version, IVfsWorkspace workspace) {
        if (version == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Show version failed", (String)"Version is <null>.");
            return;
        }
        IStorageEditorInput editorInput = EditorInputFactory.getEditorInput(version, workspace);
        if (editorInput == null) {
            return;
        }
        boolean localState = editorInput instanceof FileEditorInput;
        String title = version.getDisplayName() + (localState ? "    ( Local state of version " : "    ( Version ") + version.getBranchSequenceNumber() + " in workspace : " + (localState ? workspace.getAbsoluteRemotePath() : version.getCreatorWorkspaceName()) + " )";
        OpenEditorAction.showInput(editorInput, title);
    }

    public static void showFile(IVfsFile file) {
        String title;
        IStorageEditorInput input;
        if (file.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && file.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE && file.getLocalFile() != null && file.getLocalFile().exists()) {
            input = EditorInputFactory.getEditorInput(file, file.getWorkspace());
            if (file.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && file.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                title = file.getName() + "    ( Local )";
            } else {
                IVfsVersion version = file.getSyncedVersion();
                boolean checkedOut = file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT;
                title = file.getName() + (checkedOut ? "    ( Local state of checked-out version" : "    ( Local state of version " + version.getBranchSequenceNumber()) + " in workspace : " + (version != null ? version.getCreatorWorkspaceName() : file.getWorkspace().getAbsoluteRemotePath()) + " )";
            }
        } else {
            if (file.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"File not found", (String)("File " + file.getLocalFile().getAbsolutePath() + " is missing on local filesystem.\n" + "File was probably deleted directly from your filesystem.\n" + "To fix this problem press REFRESH in Repository Browser."));
                return;
            }
            if (file.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Show version.", (String)("File " + file.getLocalFile().getAbsolutePath() + " is " + file.getActivityState() + "."));
                return;
            }
            if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                if (file.isInconsistent() && file.getCauseOfInconsistency() != null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"File not found", (String)file.getCauseOfInconsistency().getMessage());
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"File not found", (String)("File " + file.getLocalFile().getAbsolutePath() + " is missing on local filesystem.\n" + "File was probably deleted directly from your filesystem.\n"));
                }
                return;
            }
            try {
                OpenEditorAction.showVersion(file.refreshAndGetVersion(), file.getWorkspace());
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Show version failed", (String)e.getMessage());
            }
            return;
        }
        OpenEditorAction.showInput(input, title);
    }

    private static void showInput(IStorageEditorInput input, String title) {
        IWorkbenchWindow window = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        try {
            if (Team.getType((IStorage)input.getStorage()) == 2) {
                try {
                    String absolutePath;
                    if (input instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        absolutePath = file.getLocation().toOSString();
                    } else {
                        absolutePath = OpenEditorAction.createTempFile(input.getStorage().getContents(), input.getName()).toString();
                    }
                    Platform.getPlatform().openWithDefaultApplication(absolutePath);
                    return;
                }
                catch (UnsupportedOperationException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
            IEditorDescriptor desc = DialogEditor.findEditorDescriptor(input.getStorage().getName(), false);
            IEditorPart editor = DialogEditor.createEditor(desc);
            editor.init(DialogEditor.getEditorSite(desc), (IEditorInput)input);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editor.getSite().getId());
        }
        catch (PartInitException e) {
            try {
                IEditorDescriptor desc = DialogEditor.findEditorDescriptor("a.txt", true);
                IEditorPart editor = DialogEditor.createEditor(desc);
                editor.init(DialogEditor.getEditorSite(desc), (IEditorInput)input);
                DialogEditor dialog = new DialogEditor(shell, editor, title, null);
                dialog.open();
            }
            catch (PartInitException e1) {
                OpenEditorAction.showErrorMessage2("Can't create editor part: " + e1.getLocalizedMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)e1);
            }
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        catch (CoreException ex) {
            OpenEditorAction.showErrorMessage2("Can't get input storage: " + ex.getLocalizedMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File createTempFile(InputStream input, String fileName) {
        int bytes;
        File file = null;
        FileOutputStream str = null;
        file = File.createTempFile("_tmp", "");
        file.deleteOnExit();
        String tempDir = file.getParent();
        file = new File(tempDir, "_tmp_" + fileName);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        file.deleteOnExit();
        str = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        while ((bytes = input.read(buffer)) != -1) {
            void var6_8;
            str.write(buffer, 0, (int)var6_8);
        }
        Object var8_9 = null;
        if (str == null) return file;
        try {
            str.close();
            return file;
        }
        catch (IOException e2) {}
        return file;
        {
            catch (FileNotFoundException e) {
                Object var8_10 = null;
                if (str == null) return file;
                try {
                    str.close();
                    return file;
                }
                catch (IOException e2) {}
                return file;
            }
            catch (IOException e) {
                Object var8_11 = null;
                if (str == null) return file;
                try {
                    str.close();
                    return file;
                }
                catch (IOException e2) {}
                return file;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (str == null) throw throwable;
            try {
                str.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static void showErrorMessage2(String message) {
        IWorkbenchWindow activeWindow = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart workbenchPart = activeWindow.getActivePage().getActivePart();
        if (workbenchPart instanceof IViewPart) {
            IStatusLineManager statusLine = ((IViewPart)workbenchPart).getViewSite().getActionBars().getStatusLineManager();
            statusLine.setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
        } else {
            Logbook.getErrorChapter().println(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

