/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.MoveFileIntoActivityAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.actions.FolderItemAndActivityTuppel;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.MoveAction;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MoveFolderIntoActivityAction
extends MoveFileIntoActivityAction {
    private static final String DIALOG_TITLE_STEP_1 = "(Step 1/2)";
    private static final String DIALOG_TITLE_STEP_2 = "(Step 2/2)";
    private static final String DIALOG_MESSAGE_CHOOSE_SOURCEACT = "The selected folder was checked-out in several activities. \nPlease select source activity/-ies.";

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem = selection.getFirstElement();
        return selectedItem instanceof IVfsFolder && this.isActionEnabled((IVfsFolderItem)((IVfsFolder)selectedItem), VfsActionOnFolderItem.MOVE_INTO_ACTIVITY);
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFolder folder = (IVfsFolder)selection.getFirstElement();
        IVfsActivity[] checkoutActivities = folder.getOpenActivities();
        IVfsWorkspace workspace = folder.getWorkspace();
        HashSet<IVfsActivity> activitiesToExclude = new HashSet<IVfsActivity>();
        if (checkoutActivities.length > 1) {
            if (this.m_targetPart instanceof RepositoryView && ((RepositoryView)this.m_targetPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView")) {
                Object[] parentObjects = this.getParentObjectForTreeSelection(folder, 1);
                if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsActivity) {
                    activitiesToExclude.add((IVfsActivity)parentObjects[0]);
                    SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), this.getPotentialDestinationActivities(workspace, activitiesToExclude), workspace, false, "Move into Activity", "Select a destination activity for moving.", 2, false);
                    if (dialog.open() == 0) {
                        this.openCommandOutputView();
                        this.executeFinalVfsAction((IVfsAction)new MoveAction((IVfsActivityRecordedFolderItem)folder, (IVfsActivity)parentObjects[0], dialog.getActivitySelection()[0], workerThreadMonitor));
                    }
                }
            } else {
                SelectActivityDialog srcDialog = new SelectActivityDialog(this.getShell(), checkoutActivities, workspace, true, "Move into Activity (Step 1/2)", DIALOG_MESSAGE_CHOOSE_SOURCEACT, 4, true);
                if (srcDialog.open() == 0) {
                    IVfsActivity[] srcActivities = srcDialog.getActivitySelection();
                    int i = 0;
                    while (i < srcActivities.length) {
                        activitiesToExclude.add(srcActivities[i]);
                        ++i;
                    }
                    SelectActivityDialog dstDialog = new SelectActivityDialog(this.getShell(), this.getPotentialDestinationActivities(workspace, activitiesToExclude), workspace, false, "Move into Activity (Step 2/2)", "Select a destination activity for moving.", 2, false);
                    if (dstDialog.open() == 0) {
                        this.openCommandOutputView();
                        if (srcActivities.length > 1) {
                            FolderItemAndActivityTuppel[] tuppels = new FolderItemAndActivityTuppel[srcActivities.length];
                            int i2 = 0;
                            while (i2 < srcActivities.length) {
                                tuppels[i2] = new FolderItemAndActivityTuppel((IVfsActivityRecordedFolderItem)folder, srcActivities[i2]);
                                ++i2;
                            }
                            this.executeFinalVfsAction((IVfsAction)new MoveAction(tuppels, dstDialog.getActivitySelection()[0], workerThreadMonitor));
                        } else {
                            this.executeFinalVfsAction((IVfsAction)new MoveAction((IVfsActivityRecordedFolderItem)folder, srcActivities[0], dstDialog.getActivitySelection()[0], workerThreadMonitor));
                        }
                    }
                }
            }
        } else {
            activitiesToExclude.add(checkoutActivities[0]);
            SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), this.getPotentialDestinationActivities(workspace, activitiesToExclude), workspace, false, "Move into Activity", "Select a destination activity for moving.", 2, false);
            if (dialog.open() == 0) {
                this.openCommandOutputView();
                this.executeFinalVfsAction((IVfsAction)new MoveAction((IVfsActivityRecordedFolderItem)folder, checkoutActivities[0], dialog.getActivitySelection()[0], workerThreadMonitor));
            }
        }
    }
}

