/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.FolderItemAndActivityTuppel;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.MoveAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MoveFileIntoActivityAction
extends VfsObjectSelectionAction {
    protected static final String DIALOG_TITLE = "Move into Activity";
    protected static final String DIALOG_MESSAGE = "Select a destination activity for moving.";
    private static final Location LOACTION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$MoveFileIntoActivityAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$MoveFileIntoActivityAction = MoveFileIntoActivityAction.class$("com.tssap.dtr.client.eclipse.ui.actions.MoveFileIntoActivityAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$MoveFileIntoActivityAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$MoveFileIntoActivityAction;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        if (!this.comeSelectionsFromSameWorkspace(selection)) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof IVfsFile)) {
                return false;
            }
            if (this.isActionEnabled((IVfsFolderItem)((IVfsFile)item), VfsActionOnFolderItem.MOVE_INTO_ACTIVITY)) continue;
            return false;
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        FolderItemAndActivityTuppel[] tuppels = new FolderItemAndActivityTuppel[selection.size()];
        HashSet<IVfsActivity> srcActivitySet = new HashSet<IVfsActivity>();
        int i = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IVfsFile file = (IVfsFile)iter.next();
            IVfsActivity activity = file.getOpenActivities()[0];
            if (activity == null) continue;
            tuppels[i++] = new FolderItemAndActivityTuppel((IVfsActivityRecordedFolderItem)file, activity);
            srcActivitySet.add(activity);
        }
        IVfsWorkspace workspace = ((IVfsFile)selection.getFirstElement()).getWorkspace();
        SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), this.getPotentialDestinationActivities(workspace, srcActivitySet), workspace, false, DIALOG_TITLE, DIALOG_MESSAGE, 2, false);
        if (dialog.open() == 0) {
            this.openCommandOutputView();
            IVfsActivity dstActivity = dialog.getActivitySelection()[0];
            this.executeFinalVfsAction((IVfsAction)new MoveAction(tuppels, dstActivity, workerThreadMonitor));
        }
    }

    protected IVfsActivity[] getPotentialDestinationActivities(IVfsWorkspace workspace, Set activitiesToExclude) {
        int i;
        HashSet<IVfsActivity> activitiesToChooseSet = new HashSet<IVfsActivity>();
        try {
            IVfsActivity[] openActivities = workspace.getActivities(VfsActivityState.OPEN);
            i = 0;
            while (i < openActivities.length) {
                if (!activitiesToExclude.contains(openActivities[i])) {
                    activitiesToChooseSet.add(openActivities[i]);
                }
                ++i;
            }
            IVfsActivity[] emptyActivities = workspace.getEmptyActivities();
            int i2 = 0;
            while (i2 < emptyActivities.length) {
                activitiesToChooseSet.add(emptyActivities[i2]);
                ++i2;
            }
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOACTION, (Throwable)x);
        }
        if (!activitiesToChooseSet.isEmpty()) {
            IVfsActivity[] activitiesToChoose = new IVfsActivity[activitiesToChooseSet.size()];
            i = 0;
            Iterator iter = activitiesToChooseSet.iterator();
            while (iter.hasNext()) {
                activitiesToChoose[i++] = (IVfsActivity)iter.next();
            }
            return activitiesToChoose;
        }
        return new IVfsActivity[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

