/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.security.KeyStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class MenuActionBase
implements IWorkbenchWindowActionDelegate,
IIDELoginListener,
IConfigurationListener {
    private IWorkbenchWindow m_window;

    public void dispose() {
        if (this.notifyIDELoginEvent()) {
            VfsManagerProvider.getInstance().removeIDELoginListener(this);
        }
        if (this.notifyClientConfigurationChangeEvent()) {
            Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
        if (this.notifyIDELoginEvent() && VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().addIDELoginListener(this);
        }
        if (this.notifyClientConfigurationChangeEvent()) {
            Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        }
    }

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean notifyIDELoginEvent() {
        return false;
    }

    protected boolean notifyClientConfigurationChangeEvent() {
        return false;
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
    }

    public void onUserLoggedOut() {
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    protected Shell getShell() {
        if (this.m_window != null) {
            return this.m_window.getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    protected void showMessage(String message, int messageType) {
        IWorkbenchPart part;
        if (this.m_window == null) {
            this.m_window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((part = this.m_window.getPartService().getActivePart()) instanceof IViewPart) {
            IStatusLineManager statusLine = ((IViewPart)part).getViewSite().getActionBars().getStatusLineManager();
            statusLine.setMessage(null);
            switch (messageType) {
                case 3: {
                    statusLine.setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
                    break;
                }
                case 1: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_info_image"), message);
                    break;
                }
                case 2: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_warning_image"), message);
                    break;
                }
                default: {
                    statusLine.setMessage(message);
                    break;
                }
            }
        } else {
            switch (messageType) {
                case 3: {
                    Logbook.getErrorChapter().println(message);
                    break;
                }
                case 1: {
                    Logbook.getInfoChapter().println(message);
                    break;
                }
                case 2: {
                    Logbook.getWarnChapter().println(message);
                    break;
                }
                default: {
                    Logbook.getPlainChapter().println(message);
                }
            }
        }
    }

    protected void showErrorMessage(String message) {
        this.showMessage(message, 3);
    }
}

