/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LoginAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$LoginAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$LoginAction = LoginAction.class$("com.tssap.dtr.client.eclipse.ui.actions.LoginAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$LoginAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$LoginAction;

    public void selectionChanged(IAction action, ISelection selection) {
        if (!VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            action.setText(IDialogConstants.RETRY_LABEL);
        }
        super.selectionChanged(action, selection);
    }

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        return Configuration.getConfiguration().clients().hasNext();
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    IVfsContext context = Configuration.getConfiguration().getActiveClient().getContext();
                    VfsManagerProvider.getInstance().logIn(context);
                }
                catch (VfsException e) {
                    Logbook.getErrorChapter((int)1).println(e.getMessage());
                    LoginAction.this.showErrorMessage(e.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
        });
    }

    protected boolean showCommandOutputViewBeforeExecution() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

