/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.remoteeditor.RemoteFileEditorInput;
import com.tssap.dtr.client.eclipse.ui.ActivityDescribeDialog;
import com.tssap.dtr.client.eclipse.ui.ObjectDescriptionDialog;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.eclipse.ui.dialogEditor.DialogEditor;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class IntegrateCollisionSelectionAction
extends VfsObjectSelectionAction
implements ObjectDescriptionDialog.IButtonPressedAction {
    protected static final String ACTION_NAME_ATTRIBUTE = "ActionName";
    protected static final String VIEW_ACTIVE_VERSION = "ViewActiveVersion";
    protected static final String VIEW_COLLIDING_VERSION = "ViewCollidingVersion";
    protected static final String VIEW_MERGE_VERSION = "ViewMergeVersion";
    protected static final String VIEW_VERSION_GRAPH = "ViewVersionGraph";
    protected static final String RESOLVE = "MergeIntegrateCollision";
    protected static final String AUTO_RESOLVE = "ShowUI";
    protected static final String DISCARD_ACTIVE_VERSION = "DiscardActive";
    protected static final String DISCARD_COLLIDING_VERSION = "DiscardColliding";
    protected static final String UNDO_DISCARD = "UndoDiscard";
    protected static final String UNDO_MERGE = "UndoMerge";
    protected static final String ACCEPT_ACTIVE = "AcceptActive";
    protected static final String ACCEPT_COLLIDING = "AcceptColliding";
    protected static final String ACCEPT_ACTIVE_RESOURCE = "AcceptActiveResource";
    protected static final String ACCEPT_COLLIDING_RESOURCE = "AcceptCollidingResource";
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$IntegrateCollisionSelectionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$IntegrateCollisionSelectionAction = IntegrateCollisionSelectionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.IntegrateCollisionSelectionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$IntegrateCollisionSelectionAction));
    private IVfsIntegrateCollision m_currentCollision;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$IntegrateCollisionSelectionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Iterator selectedCollisions = selection.iterator();
        while (selectedCollisions.hasNext()) {
            Object collision = selectedCollisions.next();
            if (this.isCollisionValid(collision)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCollisionValid(Object collision) {
        String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
        if (collision instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)collision;
            IVfsIntegrateCollision.VfsIntegrateCollisionInternalState collisionState = selectedCollision.getInternalState();
            if (!selectedCollision.getWorkspace().isModifiable() && (actionName.equalsIgnoreCase(DISCARD_ACTIVE_VERSION) || actionName.equalsIgnoreCase(ACCEPT_ACTIVE_RESOURCE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING_RESOURCE) || actionName.equalsIgnoreCase(DISCARD_COLLIDING_VERSION) || actionName.equalsIgnoreCase(RESOLVE) || actionName.equalsIgnoreCase(AUTO_RESOLVE) || actionName.equalsIgnoreCase(UNDO_MERGE) || actionName.equalsIgnoreCase(UNDO_DISCARD) || actionName.equalsIgnoreCase(ACCEPT_ACTIVE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING))) {
                return false;
            }
            if (selectedCollision.getCollisionType() == VfsCollisionType.NAME_CLASH) {
                if (actionName.equalsIgnoreCase(DISCARD_ACTIVE_VERSION) || actionName.equalsIgnoreCase(VIEW_MERGE_VERSION) || actionName.equalsIgnoreCase(DISCARD_COLLIDING_VERSION) || actionName.equalsIgnoreCase(UNDO_MERGE) || actionName.equalsIgnoreCase(UNDO_DISCARD) || actionName.equalsIgnoreCase(ACCEPT_ACTIVE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING)) {
                    return false;
                }
                if ((actionName.equalsIgnoreCase(ACCEPT_ACTIVE_RESOURCE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING_RESOURCE)) && selectedCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED)) {
                    return false;
                }
            } else if (actionName.equalsIgnoreCase(ACCEPT_ACTIVE_RESOURCE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING_RESOURCE)) {
                return false;
            }
            if ((actionName.equalsIgnoreCase(ACCEPT_ACTIVE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING)) && selectedCollision.getCollisionType().equals(VfsCollisionType.CYCLIC_MERGE)) {
                return false;
            }
            if ((actionName.equalsIgnoreCase(ACCEPT_ACTIVE) || actionName.equalsIgnoreCase(ACCEPT_COLLIDING) || actionName.equalsIgnoreCase(RESOLVE)) && (collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED))) {
                return false;
            }
            if (actionName.equalsIgnoreCase(UNDO_DISCARD) && selectedCollision.getDiscardTargets() == IVfsIntegrateCollision.VfsDiscardTargetVersion.NONE) {
                return false;
            }
            return !actionName.equalsIgnoreCase(UNDO_MERGE) && !actionName.equalsIgnoreCase(VIEW_MERGE_VERSION) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN);
        }
        return collision instanceof IVfsVersion;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        if (!(selection.getFirstElement() instanceof IVfsIntegrateCollision)) {
            return;
        }
        IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selection.getFirstElement();
        String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
        try {
            if (actionName != null) {
                if (actionName.equalsIgnoreCase(VIEW_ACTIVE_VERSION)) {
                    IVfsVersion version = selectedCollision.getActiveVersion();
                    this.viewVersion(version);
                } else if (actionName.equalsIgnoreCase(VIEW_COLLIDING_VERSION)) {
                    IVfsVersion version = selectedCollision.getCollidingVersion();
                    this.viewVersion(version);
                } else if (actionName.equalsIgnoreCase(VIEW_VERSION_GRAPH)) {
                    this.viewVersionGraph(selectedCollision);
                } else if (actionName.equalsIgnoreCase(VIEW_MERGE_VERSION)) {
                    IVfsMergeVersion mergeVersion = IntegrateCollisionUtil.getMergedVersion(selectedCollision, this.getShell());
                    this.viewMergeVersion(mergeVersion, selectedCollision);
                } else if (actionName.equalsIgnoreCase(UNDO_MERGE)) {
                    IntegrateCollisionUtil.undoMerge(selectedCollision);
                } else if (actionName.equalsIgnoreCase(ACCEPT_ACTIVE)) {
                    if (EnvironmentVariables.USE_IMMEDIATE_DISCARD) {
                        this.discard(selectedCollision, actionName, "Discard Conflicting Version");
                    } else {
                        this.discard(selectedCollision, actionName);
                    }
                } else if (actionName.equalsIgnoreCase(ACCEPT_COLLIDING)) {
                    if (EnvironmentVariables.USE_IMMEDIATE_DISCARD) {
                        this.discard(selectedCollision, actionName, "Discard Active Version");
                    } else {
                        this.discard(selectedCollision, actionName);
                    }
                } else if (actionName.equalsIgnoreCase(ACCEPT_ACTIVE_RESOURCE)) {
                    this.acceptActiveResource(selectedCollision);
                } else if (actionName.equalsIgnoreCase(ACCEPT_COLLIDING_RESOURCE)) {
                    this.acceptCollidingResource(selection);
                }
            }
        }
        catch (VfsException e) {
            this.showErrorMessage("Resolving conflict: " + e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    private void viewVersion(IVfsVersion version) {
        RemoteFileEditorInput input = new RemoteFileEditorInput(version);
        String title = version.getDisplayName() + "    ( Version " + String.valueOf(version.getBranchSequenceNumber()) + "  in Workspace : " + version.getCreatorWorkspaceName() + " )";
        this.openEditor(input, version.toString(), title);
    }

    private void openEditor(RemoteFileEditorInput input, String name, String title) {
        try {
            IEditorDescriptor descriptor = DialogEditor.findEditorDescriptor(name, false);
            IEditorPart editor = DialogEditor.createEditor(descriptor);
            editor.init(DialogEditor.getEditorSite(descriptor), (IEditorInput)input);
            DialogEditor dialog = new DialogEditor(this.getShell(), editor, title, null);
            dialog.open();
        }
        catch (PartInitException e) {
            this.showErrorMessage("Can't create editor part: " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void viewMergeVersion(IVfsMergeVersion version, IVfsIntegrateCollision collision) {
        try {
            IVfsFile file = version.getRepresentingFile(collision.getWorkspace());
            if (file == null) {
                this.showErrorMessage("Unable to obtain Merge version file");
                return;
            }
            RemoteFileEditorInput input = new RemoteFileEditorInput(file);
            String title = version.getDisplayName() + "    ( Version " + String.valueOf(version.getBranchSequenceNumber()) + "  in Workspace : " + version.getCreatorWorkspaceName() + " )";
            this.openEditor(input, file.getDisplayName(), title);
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    private void viewVersionGraph(final IVfsIntegrateCollision collision) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                ArrayList<IVfsIntegrateCollision> list = new ArrayList<IVfsIntegrateCollision>();
                list.add(collision);
                StructuredSelection graphInput = new StructuredSelection(list);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IViewPart view = page.showView("com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView");
                    if (view instanceof VersionTreeView) {
                        ((VersionTreeView)view).selectReveal((ISelection)graphInput);
                    }
                }
                catch (PartInitException x) {
                    IntegrateCollisionSelectionAction.this.showErrorMessage("Open version graph failed: " + x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void discard(IVfsIntegrateCollision collision, String actionName) {
        IVfsWorkspace workspace = collision.getWorkspace();
        IVfsActivity activity = null;
        boolean acceptActive = actionName.equalsIgnoreCase(ACCEPT_ACTIVE);
        if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            try {
                activity = workspace.getDefaultActivity();
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                this.showErrorMessage(x.getMessage());
            }
        } else {
            SelectActivityDialog dialog = new SelectActivityDialog(this.getShell(), workspace, false, acceptActive ? "Discard Conflicting Version" : "Discard Active Version", "Choose an activity to discard " + (acceptActive ? collision.getCollidingVersionDescription() : collision.getActiveVersionDescription()), 0);
            if (dialog.open() == 0) {
                activity = dialog.getActivitySelection()[0];
            }
        }
        if (activity == null) {
            return;
        }
        try {
            if (acceptActive) {
                collision.discardCollidingVersion(activity);
            } else {
                collision.discardActiveVersion(activity);
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            this.showErrorMessage((acceptActive ? "Discard conflicting version" : "Discard active version") + " failed: " + x.getMessage());
        }
    }

    private void discard(IVfsIntegrateCollision collision, String actionName, String actionTitle) {
        String versionDescription = actionName.equalsIgnoreCase(ACCEPT_ACTIVE) ? collision.getCollidingVersionDescription() : collision.getActiveVersionDescription();
        String confirmMessage = "This operation will create an activity, discard " + versionDescription + " and immediately checkin the activity. Press OK to continue... ";
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)actionTitle, (String)confirmMessage)) {
            return;
        }
        this.m_currentCollision = collision;
        String actionID = actionName.equalsIgnoreCase(ACCEPT_ACTIVE) ? DISCARD_COLLIDING_VERSION : DISCARD_ACTIVE_VERSION;
        ActivityDescribeDialog dialog = new ActivityDescribeDialog(this.getShell(), actionID, this);
        dialog.setTitle(dialog.getTitle() + " for Discard");
        if (dialog.open() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)actionTitle, (String)("Discard of " + versionDescription + " completed.  Conflict resolved successfully"));
        }
    }

    public void okPressedAction(ObjectDescriptionDialog dialog) throws Exception {
        try {
            if (dialog.getActionID().equalsIgnoreCase(DISCARD_ACTIVE_VERSION)) {
                this.m_currentCollision.getWorkspace().immediateDiscardActiveVersion(this.m_currentCollision, dialog.getName(), dialog.getDescription());
            } else if (dialog.getActionID().equalsIgnoreCase(DISCARD_COLLIDING_VERSION)) {
                this.m_currentCollision.getWorkspace().immediateDiscardCollidingVersion(this.m_currentCollision, dialog.getName(), dialog.getDescription());
            } else if (dialog.getActionID().equalsIgnoreCase(ACCEPT_ACTIVE_RESOURCE)) {
                this.m_currentCollision.acceptActiveResourceInNameClash(dialog.getName(), dialog.getDescription());
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            throw e;
        }
    }

    private void acceptActiveResource(IVfsIntegrateCollision collision) throws VfsException {
        String confirmMessage = "This operation will create an activity, delete the conflicting resource and immediately checkin the activity. Press OK to continue... ";
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Accept Active Resource", (String)confirmMessage)) {
            return;
        }
        this.m_currentCollision = collision;
        String actionID = ACCEPT_ACTIVE_RESOURCE;
        ActivityDescribeDialog dialog = new ActivityDescribeDialog(this.getShell(), actionID, this);
        dialog.setTitle(dialog.getTitle() + " for Name-Clash resolution");
        if (dialog.open() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Accept Active Resource", (String)"Conflicting resource deleted. Conflict resolved successfully");
        }
    }

    private void acceptCollidingResource(IStructuredSelection selection) throws VfsException {
        String message = null;
        IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selection.getFirstElement();
        final IVfsActivityRecordedFolderItem activeResourceFolderItem = selectedCollision.getActiveVersionFolderItem();
        if (activeResourceFolderItem != null) {
            if (activeResourceFolderItem.getActivityState().equals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) {
                final IVfsActivity selectedActivity = IntegrateCollisionUtil.getMultipleSelectionActivityInOneWorkspace(selection, this.getShell());
                if (selectedActivity == null) {
                    return;
                }
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            activeResourceFolderItem.asFile().checkOutAndDelete(selectedActivity);
                            String message = "Active resource ( " + activeResourceFolderItem.getAbsoluteRemotePath() + " ) deleted. To resolve conflict, check-in the activity.";
                            IntegrateCollisionSelectionAction.this.showMessage(message, 1);
                            MessageDialog.openInformation((Shell)IntegrateCollisionSelectionAction.this.getShell(), (String)"Accept Conflicting Resource", (String)message);
                        }
                        catch (VfsException e) {
                            String errorMessage = "Unable to resolve conflict. An internal error occured while  deleting the active resource. See log for more details. ";
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                            MessageDialog.openError((Shell)IntegrateCollisionSelectionAction.this.getShell(), (String)"Accept Conflicting Resource", (String)errorMessage);
                            return;
                        }
                    }
                });
            } else if (activeResourceFolderItem.getActivityState().equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT)) {
                message = "Unable to resolve conflict : the active resource in workspace  " + selectedCollision.getWorkspacePath() + " is currently checked out for edit";
                this.showMessage(message, 3);
                MessageDialog.openError((Shell)this.getShell(), (String)"Accept Conflicting Resource", (String)message);
            } else {
                message = "Active resource ( " + activeResourceFolderItem.getAbsoluteRemotePath() + " ) is already checked-out for delete." + " To resolve conflict, check-in the activity containing this file.";
                this.showMessage(message, 2);
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Accept Conflicting Resource", (String)message);
            }
        } else {
            message = "Conflict resolution failed : Unable to retrieve file representing the active resource in workspace : " + selectedCollision.getWorkspacePath() + " . Check if this workspace is visible and you have permissions to access it.";
            this.showMessage(message, 3);
            MessageDialog.openError((Shell)this.getShell(), (String)"Accept Conflicting Resource", (String)message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

