/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.actions.EditAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditFileAction
extends VfsObjectSelectionAction {
    private static final String CONFLICT_DIALOG_TITLE = "Integration Conflict Found";
    private static final String BUTTON_LABEL_OPEN_VIEW = "Open Conflict View";
    private static final String BUTTON_LABEL_CONTINUE_CHECK_OUT = "Continue with Edit";
    private static final String BUTTON_LABEL_CANCEL_CHECK_OUT = "Cancel Edit";
    private static final int OPEN_VIEW_OPTION = 0;
    private static final int CANCEL_OPTION_A = 1;
    private static final int CANCEL_OPTION_B = -1;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFile;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        if (!this.comeSelectionsFromSameWorkspace(selection)) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof IVfsFile)) {
                return false;
            }
            if (this.isActionEnabled((IVfsFolderItem)((IVfsFile)item), VfsActionOnFolderItem.CHECKOUT_FOR_EDIT)) continue;
            return false;
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsActivity activity;
        IVfsWorkspace workspace = ((IVfsFile)selection.getFirstElement()).getWorkspace();
        IVfsFile[] files = (IVfsFile[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsFile == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFile = EditFileAction.class$("com.tssap.dtr.client.lib.vfs.IVfsFile")) : class$com$tssap$dtr$client$lib$vfs$IVfsFile);
        String[] filesWithConflict = this.getFilesWithIntegrationConflict((IVfsActivityRecordedFolderItem[])files);
        if (filesWithConflict.length > 0) {
            String conflictMessage = "The following files have open Integration Conflicts : \n ";
            int i = 0;
            while (i < filesWithConflict.length) {
                conflictMessage = conflictMessage + "\n " + filesWithConflict[i];
                ++i;
            }
            conflictMessage = conflictMessage + "\n\nIt is recommended to resolve the conflict(s) from the Integration Conflict View.";
            MessageDialog warnDialog = new MessageDialog(this.getShell(), CONFLICT_DIALOG_TITLE, null, conflictMessage, 4, new String[]{BUTTON_LABEL_OPEN_VIEW, BUTTON_LABEL_CANCEL_CHECK_OUT, BUTTON_LABEL_CONTINUE_CHECK_OUT}, 0);
            int userResponse = warnDialog.open();
            if (userResponse == 0) {
                this.showInConflictView(workspace);
                return;
            }
            if (userResponse == 1 || userResponse == -1) {
                return;
            }
        }
        if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            activity = null;
        } else {
            SelectActivityDialog selectActivity = new SelectActivityDialog(this.getShell(), workspace);
            if (selectActivity.open() == 0) {
                activity = selectActivity.getActivitySelection()[0];
            } else {
                return;
            }
        }
        this.openCommandOutputView();
        this.executeFinalVfsAction((IVfsAction)new EditAction((IVfsActivityRecordedFolderItem[])files, activity, 0, workerThreadMonitor));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

