/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.automerge.ICollisionListener;
import com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DiffMergeSingleSelectionAction
extends AbstractDiffMergeAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$DiffMergeSingleSelectionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$DiffMergeSingleSelectionAction = DiffMergeSingleSelectionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.DiffMergeSingleSelectionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$DiffMergeSingleSelectionAction));
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Conflict resolution";
    private static final String DEFAULT_DIALOG_MESSAGE_CHECKIN = "Do you want to resolve the conflict by accepting your (local) file ?";
    private static final String DEFAULT_DIALOG_MESSAGE_INTEGRATE = "Do you want to resolve the conflict by accepting the merged version ?";
    private static final String ERROR_DIALOG_MESSAGE = "Error occured during conflict resolution : ";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$DiffMergeSingleSelectionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        String actionName = this.getConfigProperty("ActionName", null);
        if (actionName.equalsIgnoreCase("MergeIntegrateCollision") && selected instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selected;
            if (!selectedCollision.getWorkspace().isModifiable()) {
                return false;
            }
            IVfsIntegrateCollision.VfsIntegrateCollisionInternalState collisionState = selectedCollision.getInternalState();
            return !collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN) && !collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) && selectedCollision.getCollisionType() != VfsCollisionType.NAME_CLASH && !collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED);
        }
        if (actionName.equalsIgnoreCase("ViewConflictDifference")) {
            return selected instanceof IVfsIntegrateCollision || selected instanceof IVfsActivityElement;
        }
        if (actionName.equalsIgnoreCase("MergeCheckinCollision")) {
            IVfsCheckinCollision col = this.getCheckinCollision(selection);
            return col != null;
        }
        if ((actionName.equalsIgnoreCase("Diff") || actionName.equalsIgnoreCase("Merge")) && actionName.equalsIgnoreCase("Diff")) {
            IVfsVersion version;
            if (selected instanceof IVfsVersion) {
                return this.hasPredecessorsAndIsFile((IVfsVersion)selected);
            }
            if (selected instanceof IVfsRevision) {
                return this.hasPredecessorsAndIsFile(((IVfsRevision)selected).getVersion());
            }
            if (selected instanceof IVfsFile) {
                return this.checkEnabled((IVfsFile)selected);
            }
            if (selected instanceof IFile) {
                IFile file = (IFile)selected;
                DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)file);
                if (teamProvider == null) {
                    return false;
                }
                IVfsFile vfsFile = teamProvider.getFolderItem((IResource)file).asFile();
                if (vfsFile == null) {
                    return false;
                }
                return this.checkEnabled(vfsFile);
            }
            if (selected instanceof IVfsActivityElement && (version = ((IVfsActivityElement)selected).getAsVersion()) != null) {
                return this.hasPredecessorsAndIsFile(version);
            }
        }
        return false;
    }

    private boolean hasPredecessorsAndIsFile(IVfsVersion version) {
        try {
            if (!version.isFile()) {
                return false;
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
        return version.getBranchSequenceNumber() != 1 || version.getPredecessorSet().length != 0;
    }

    protected void execute(final IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        final Object selected = selection.getFirstElement();
        this.setProgressMonitor(workerThreadMonitor);
        final String actionName = this.getConfigProperty("ActionName", null);
        if (actionName.equalsIgnoreCase("MergeCheckinCollision")) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiffMergeSingleSelectionAction.this.mergeCheckinCollision(DiffMergeSingleSelectionAction.this.getCheckinCollision(selection), null);
                }
            });
            return;
        }
        if (actionName.equalsIgnoreCase("MergeIntegrateCollision") && selected instanceof IVfsIntegrateCollision) {
            final boolean[] revertMergeversion = new boolean[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IVfsIntegrateCollision col = (IVfsIntegrateCollision)selected;
                    revertMergeversion[0] = col.getMergeVersion() == null;
                }
            });
            this.resolveIntegrateCollision((IVfsIntegrateCollision)selected, revertMergeversion[0], null);
        }
        if (actionName.equalsIgnoreCase("ViewConflictDifference")) {
            if (selected instanceof IVfsIntegrateCollision) {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.this.viewConflictDifference((IVfsIntegrateCollision)selected);
                    }
                });
            } else if (selected instanceof IVfsActivityElement) {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.this.viewConflictDifference((IVfsActivityElement)selected);
                    }
                });
            }
            return;
        }
        if (selected instanceof IVfsVersion) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (!((IVfsVersion)selected).isFile()) {
                            return;
                        }
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        return;
                    }
                    if (actionName.equalsIgnoreCase("Diff")) {
                        DiffMergeSingleSelectionAction.this.diffWithOrignalVersion((IVfsVersion)selected);
                    }
                }
            });
            return;
        }
        if (selected instanceof IVfsRevision) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (!((IVfsRevision)selected).getVersion().isFile()) {
                            return;
                        }
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        return;
                    }
                    if (actionName.equalsIgnoreCase("Diff")) {
                        DiffMergeSingleSelectionAction.this.diffWithOrignalVersion(((IVfsRevision)selected).getVersion());
                    }
                }
            });
            return;
        }
        if (selected instanceof IVfsFile || selected instanceof IFile) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiffMergeSingleSelectionAction.this.diffMergeFile(selection);
                }
            });
            return;
        }
        if (selected instanceof IVfsActivityElement) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IVfsVersion version = ((IVfsActivityElement)selected).getAsVersion();
                    if (version == null) {
                        DiffMergeSingleSelectionAction.this.showErrorMessage("Could not obtain version object.");
                    } else if (actionName.equalsIgnoreCase("Diff")) {
                        DiffMergeSingleSelectionAction.this.diffWithOrignalVersion(version);
                    }
                }
            });
            return;
        }
    }

    private IVfsVersionRelation getCopyMergeRelation(IVfsVersionRelation[] relations) {
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getRelationType() == VfsVersionRelationType.COPY_MERGE) {
                return relations[i];
            }
            ++i;
        }
        return null;
    }

    private void diffWithOrignalVersion(IVfsVersion version) {
        block16: {
            try {
                File localFile;
                boolean workspaceFileFound = false;
                IVfsVersion originalVersion = null;
                IVfsVersionRelation[] predecessorRelations = version.getPredecessorRelationSet();
                if (predecessorRelations.length > 0) {
                    IVfsVersionRelation copyMergeRelation = this.getCopyMergeRelation(predecessorRelations);
                    if (copyMergeRelation != null) {
                        originalVersion = version.getVersionHistory().getVersion(copyMergeRelation.getSourceVersionId());
                    } else {
                        int i = 0;
                        while (i < predecessorRelations.length) {
                            if (predecessorRelations[i].getRelationType() == VfsVersionRelationType.BRANCH || predecessorRelations[i].getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                                originalVersion = version.getVersionHistory().getVersion(predecessorRelations[i].getSourceVersionId());
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (originalVersion == null) {
                    originalVersion = version;
                }
                if (originalVersion == null) break block16;
                String workspacePath = version.getCreatorWorkspaceName();
                IVfsContext context = version.getVersionedFileSystemManager().getCurrentContext();
                try {
                    if (version.isOpen()) {
                        IVfsFile vfsFile = version.getRepresentingFile(workspacePath, context);
                        if (vfsFile != null && vfsFile.getLocalFile().exists()) {
                            workspaceFileFound = true;
                            localFile = new File(vfsFile.getLocalFile().getAbsolutePath());
                        } else {
                            localFile = ExternalAction.createTmpFile(version, "Version_" + version.getBranchSequenceNumber() + "_");
                        }
                    } else {
                        localFile = ExternalAction.createTmpFile(version, "Version_" + version.getBranchSequenceNumber() + "_");
                    }
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    localFile = ExternalAction.createTmpFile(version, "Version_" + version.getBranchSequenceNumber() + "_");
                }
                boolean useExternalTool = this.myPreferenceManager.isUseExternalDiff();
                if (useExternalTool) {
                    final IVfsProgressMonitor monitor = this.getProgressMonitor();
                    final IVfsVersion origVersion = originalVersion;
                    final File locFile = localFile;
                    Thread actionThread = new Thread(){

                        public void run() {
                            monitor.onStart();
                            File leftFile = ExternalAction.createTmpFile(origVersion, "Version_" + origVersion.getBranchSequenceNumber() + "_");
                            DiffMergeSingleSelectionAction.this.runExternalDiff(leftFile, locFile, true);
                            monitor.onFinish(null);
                        }
                    };
                    actionThread.start();
                    return;
                }
                String leftVersionTitle = workspaceFileFound ? localFile.getAbsolutePath() : version.getLocationInGraph(version.getCreatorWorkspaceName());
                String rightVersionTitle = originalVersion.getLocationInGraph(originalVersion.getCreatorWorkspaceName());
                DiffEditorInput input = new DiffEditorInput(localFile, new IVfsVersion[]{originalVersion}, null, false);
                input.setTitle("/" + version.getWorkspaceRelativePath());
                input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
                input.getCompareConfiguration().setLeftEditable(this.isVersionOpenByCurrentUser(version));
                input.getCompareConfiguration().setRightLabel(rightVersionTitle);
                input.getCompareConfiguration().setRightEditable(this.isVersionOpenByCurrentUser(originalVersion));
                if (input.getCompareConfiguration().isLeftEditable()) {
                    input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                }
                this.runInternalDiff(input);
            }
            catch (Exception e) {
                this.showErrorMessage("Problem occurred during diff command: " + e.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    public void resolveIntegrateCollision(final IVfsIntegrateCollision collision, final boolean discardAfterCancel, final ICollisionListener listener) {
        boolean resolved = false;
        final IVfsVersion[] commonAncestor = new IVfsVersion[1];
        final IVfsVersion[] activeVersion = new IVfsVersion[1];
        final IVfsVersion[] collidingVersion = new IVfsVersion[1];
        final IVfsMergeVersion[] mergeVersion = new IVfsMergeVersion[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                commonAncestor[0] = collision.getCommonAncestor();
                activeVersion[0] = collision.getActiveVersion();
                collidingVersion[0] = collision.getCollidingVersion();
                mergeVersion[0] = collision.getMergeVersion();
            }
        });
        if (mergeVersion[0] == null) {
            try {
                mergeVersion[0] = IntegrateCollisionUtil.getMergedVersion(collision, this.getShell());
            }
            catch (VfsException e) {
                this.showErrorMessage("Creating merge version failed: " + e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                return;
            }
        }
        if (mergeVersion[0] == null) {
            return;
        }
        final File mergeFile = new File(mergeVersion[0].getLocalFile().getAbsolutePath());
        boolean useExternalTool = this.myPreferenceManager.isUseExternalMerge();
        if (useExternalTool) {
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    monitor.onStart();
                    boolean resolved = false;
                    File ancestorFile = ExternalAction.createTmpFile(commonAncestor[0], "_ancestor_Version_" + commonAncestor[0].getBranchSequenceNumber() + "_");
                    File activeFile = ExternalAction.createTmpFile(activeVersion[0], "_active_Version_" + activeVersion[0].getBranchSequenceNumber() + "_");
                    File collidingFile = ExternalAction.createTmpFile(collidingVersion[0], "_conflicting_Version_" + collidingVersion[0].getBranchSequenceNumber() + "_");
                    int result = DiffMergeSingleSelectionAction.this.runExternalMerge(collision, ancestorFile, activeFile, collidingFile, mergeFile, true);
                    if (result >= 0) {
                        resolved = DiffMergeSingleSelectionAction.this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
                    }
                    if (discardAfterCancel && !resolved) {
                        BusyIndicator.showWhile(null, (Runnable)new Runnable(this){
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                try {
                                    IntegrateCollisionUtil.undoMerge(11.access$600(this.this$1));
                                }
                                catch (VfsException e) {
                                    11.access$700(this.this$1).showErrorMessage("Reverting merge version failed: " + e.getMessage());
                                    LogUtil.logCaughtException((Location)DiffMergeSingleSelectionAction.access$200(), (Throwable)e);
                                }
                            }
                        });
                    }
                    monitor.onFinish(null);
                    if (resolved && listener != null) {
                        listener.collisionResolved((IVfsCollision)collision);
                    }
                }

                static /* synthetic */ IVfsIntegrateCollision access$600(11 x0) {
                    return x0.collision;
                }

                static /* synthetic */ DiffMergeSingleSelectionAction access$700(11 x0) {
                    return x0.DiffMergeSingleSelectionAction.this;
                }
            };
            actionThread.start();
            return;
        }
        DiffEditorInput input = new DiffEditorInput(mergeFile, new IVfsVersion[]{collidingVersion[0]}, commonAncestor[0], true);
        input.getCompareConfiguration().setLeftLabel("Merge Version : " + mergeVersion[0].getLocationInGraph(mergeVersion[0].getCreatorWorkspaceName()));
        input.getCompareConfiguration().setLeftEditable(true);
        input.getCompareConfiguration().setRightLabel("Conflicting Version : " + collision.getCollidingVersionDescription());
        input.getCompareConfiguration().setRightEditable(false);
        input.getCompareConfiguration().setAncestorLabel("Common Ancestor : " + commonAncestor[0].getLocationInGraph(commonAncestor[0].getCreatorWorkspaceName()));
        input.setTitle("/" + mergeVersion[0].getWorkspaceRelativePath() + " - " + "  ( Integrate conflict between: 'Conflicting " + collision.getCollidingVersionDescription() + "' & 'Active " + collision.getActiveVersionDescription() + "' )");
        if (this.runInternalMerge(input) == 1) {
            if (discardAfterCancel && !input.isContentChanged()) {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            IntegrateCollisionUtil.undoMerge(collision);
                        }
                        catch (VfsException e) {
                            DiffMergeSingleSelectionAction.this.showErrorMessage("Reverting merge version failed: " + e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                });
            }
            resolved = false;
        } else {
            resolved = this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
        }
        if (listener != null && input.isContentChanged()) {
            listener.mergeFileChanged((IVfsCollision)collision);
        }
        if (resolved && listener != null) {
            listener.collisionResolved((IVfsCollision)collision);
        }
    }

    private boolean checkEnabled(IVfsFile file) {
        if (file.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT || file.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_MOVE) {
            String name = this.getConfigProperty("ActionName", "Diff");
            if (name.equalsIgnoreCase("Merge")) {
                return file.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER;
            }
            return true;
        }
        return false;
    }

    private void diffMergeFile(IStructuredSelection selection) {
        File localFile = null;
        IVfsVersion[] versions = new IVfsVersion[]{};
        Object selectedItem = selection.getFirstElement();
        boolean useExternalTools = this.myPreferenceManager.isUseExternalDiff();
        boolean doDiff = false;
        boolean doMerge = false;
        String name = this.getConfigProperty("ActionName", "Diff");
        if (name.equalsIgnoreCase("Diff")) {
            doDiff = true;
        } else if (name.equalsIgnoreCase("Merge")) {
            doMerge = true;
        }
        IVfsFile vfsFile = null;
        if (selectedItem instanceof IVfsFile) {
            vfsFile = (IVfsFile)selectedItem;
        } else if (selectedItem instanceof IFile) {
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)((IFile)selectedItem));
            vfsFile = teamProvider.getFolderItem((IResource)((IFile)selectedItem)).asFile();
        } else {
            return;
        }
        IVfsVersion ancestor = null;
        IVfsVersionRelation[] predRelation = vfsFile.getSyncedVersion().getPredecessorRelationSet();
        int i = 0;
        while (i < predRelation.length) {
            if (predRelation[i].getRelationType() == VfsVersionRelationType.BRANCH || predRelation[i].getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                ancestor = vfsFile.getSyncedVersion().getVersionHistory().getVersion(predRelation[i].getSourceVersionId());
            }
            ++i;
        }
        if (useExternalTools) {
            File ancestorFile = null;
            File activeFile = null;
            File collidingFile = null;
            File mergedFile = null;
            try {
                ancestorFile = ancestor != null ? ExternalAction.createTmpFile(ancestor, "ancestor_") : ExternalAction.createTmpFile(vfsFile.getSyncedVersion(), "ancestor_");
                activeFile = doDiff ? ExternalAction.createTmpFile(vfsFile.refreshAndGetVersion(), "Version_" + vfsFile.refreshAndGetVersion().getBranchSequenceNumber() + "_") : ExternalAction.createTmpFile(vfsFile.refreshAndGetVersion(), "Version_" + vfsFile.refreshAndGetVersion().getBranchSequenceNumber() + "_");
                collidingFile = doDiff ? ExternalAction.createTmpFile(vfsFile, "file2_") : ExternalAction.createTmpFile(vfsFile, "conflicting_");
                mergedFile = new File(vfsFile.getLocalFile().getAbsolutePath());
            }
            catch (VfsException e) {
                this.showErrorMessage("Retreiving version for " + vfsFile + " failed: " + e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            final File actFile = activeFile;
            final IVfsFile vfsFil = vfsFile;
            final File ancFile = ancestorFile;
            final File mergFile = mergedFile;
            final File colFile = collidingFile;
            final boolean diff = doDiff;
            final boolean merge = doMerge;
            Thread actionThread = new Thread(){

                public void run() {
                    monitor.onStart();
                    if (diff) {
                        DiffMergeSingleSelectionAction.this.runExternalDiff(actFile, new File(vfsFil.getLocalFile().getAbsolutePath()), true);
                    } else if (merge) {
                        DiffMergeSingleSelectionAction.this.runExternalMerge(null, ancFile, actFile, mergFile, colFile, true);
                    }
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        localFile = new File(vfsFile.getLocalFile().getAbsolutePath());
        if (this.isVersionTreeVisible()) {
            versions = this.getVersions(vfsFile);
        } else {
            try {
                versions = doMerge ? new IVfsVersion[]{vfsFile.getCheckinCollision().getValidSourceVersion()} : new IVfsVersion[]{vfsFile.refreshAndGetVersion()};
            }
            catch (VfsException x) {
                this.showErrorMessage("Retreiving version failed: " + x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        if (localFile == null || !localFile.exists() || localFile.isDirectory() || versions.length == 0) {
            this.showErrorMessage("Unable to perform comparison - local file does not exist or remote file version history is empty.");
            return;
        }
        DiffEditorInput input = new DiffEditorInput(localFile, versions, null, this.isEditable());
        IVfsVersionHistory versionHistory = vfsFile.refreshAndGetVersionHistory();
        if (versionHistory == null) {
            this.showErrorMessage("Unable to perform comparison - could not retrieve version history");
            return;
        }
        IVfsWorkspace workspace = vfsFile.getWorkspace();
        IVfsVersion versionOnClient = versionHistory.getVersionInClientWorkspace(workspace);
        if (versionOnClient == null) {
            this.showErrorMessage("Unable to perform comparison - could not retrieve version on client workspace");
            return;
        }
        input.getCompareConfiguration().setLeftLabel("Workspace (Local) " + versionOnClient.getLocationInGraph(workspace.getAbsoluteRemotePath()));
        input.getCompareConfiguration().setLeftEditable(true);
        input.getCompareConfiguration().setRightLabel("Repository (Remote) " + versions[0].getLocationInGraph(versions[0].getCreatorWorkspaceName()));
        input.getCompareConfiguration().setRightEditable(false);
        input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        try {
            input.setTitle("/" + vfsFile.getWorkspaceRelativePath() + " - " + "  ( Changes between: 'local file' & 'active version in Workspace: " + vfsFile.getActiveVersion().getCreatorWorkspaceName() + "' )");
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        this.runInternalDiff(input);
    }

    public void mergeCheckinCollision(final IVfsCheckinCollision collision, final ICollisionListener listener) {
        IVfsFile collidingVfsFile;
        boolean resolved = false;
        final IVfsVersion commonAncestor = collision.getCommonAncestor();
        final IVfsVersion activeVersion = collision.getValidSourceVersion();
        final IVfsFile mergeVfsFile = collidingVfsFile = collision.getFolderItemForCollidingVersion().asFile();
        boolean useExternalTool = BluebirdPlugin.getDefault().getPreferenceManager().isUseExternalMerge();
        if (useExternalTool) {
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    boolean resolved = false;
                    monitor.onStart();
                    File ancestorFile = ExternalAction.createTmpFile(commonAncestor, "ancestor_Version_" + commonAncestor.getBranchSequenceNumber() + "_");
                    File activeFile = ExternalAction.createTmpFile(activeVersion, "active_Version_" + activeVersion.getBranchSequenceNumber() + "_");
                    int collidingBranchSequenceNumber = collidingVfsFile.getSyncedVersion().getBranchSequenceNumber() + 1;
                    File collidingFile = ExternalAction.createTmpFile(collidingVfsFile, "conflicting_Version" + collidingBranchSequenceNumber + "_");
                    File mergeFile = new File(mergeVfsFile.getLocalFile().getAbsolutePath());
                    if (DiffMergeSingleSelectionAction.this.runExternalMerge(collision, ancestorFile, activeFile, collidingFile, mergeFile, true) >= 0) {
                        resolved = DiffMergeSingleSelectionAction.this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
                    }
                    monitor.onFinish(null);
                    if (resolved && listener != null) {
                        listener.collisionResolved((IVfsCollision)collision);
                    }
                }
            };
            actionThread.start();
            return;
        }
        DiffEditorInput input = new DiffEditorInput(new File(mergeVfsFile.getLocalFile().getAbsolutePath()), new IVfsVersion[]{activeVersion}, commonAncestor, true);
        IVfsVersionHistory versionHistory = mergeVfsFile.refreshAndGetVersionHistory();
        if (versionHistory == null) {
            this.showErrorMessage("Unable to perform merge - could not retrieve version history");
            return;
        }
        IVfsWorkspace workspace = mergeVfsFile.getWorkspace();
        IVfsVersion versionOnClient = versionHistory.getVersionInClientWorkspace(workspace);
        input.getCompareConfiguration().setLeftLabel("Your (local) " + versionOnClient.getLocationInGraph(versionOnClient.getCreatorWorkspaceName()));
        input.getCompareConfiguration().setLeftEditable(true);
        input.getCompareConfiguration().setRightLabel("Active (Remote) " + activeVersion.getLocationInGraph(activeVersion.getCreatorWorkspaceName()));
        input.getCompareConfiguration().setRightEditable(false);
        input.getCompareConfiguration().setAncestorLabel("Common Ancestor : " + commonAncestor.getLocationInGraph(commonAncestor.getCreatorWorkspaceName()));
        input.setTitle("/" + mergeVfsFile.getWorkspaceRelativePath() + " - " + "  ( Checking conflict between: 'Version " + activeVersion.getBranchSequenceNumber() + " in Workspace: " + activeVersion.getCreatorWorkspaceName() + "' )");
        if (this.runInternalMerge(input) == 0) {
            resolved = this.queryUserAndAcceptCollidingVersion((IVfsCollision)collision);
        }
        try {
            IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(mergeVfsFile.getLocalPath()));
            if (res != null) {
                res.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        if (resolved && listener != null) {
            listener.collisionResolved((IVfsCollision)collision);
        }
    }

    private boolean queryUserAndAcceptCollidingVersion(final IVfsCollision collision) {
        boolean accepted = false;
        String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
        String dialogMessage = null;
        dialogMessage = collision instanceof IVfsCheckinCollision ? this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE_CHECKIN) : this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE_INTEGRATE);
        final MessageDialog message = new MessageDialog(this.getShell(), dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        message.setBlockOnOpen(true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                message.open();
            }
        });
        int userResponse = message.getReturnCode();
        if (userResponse == 0) {
            if (collision instanceof IVfsCheckinCollision) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            ((IVfsCheckinCollision)collision).acceptCollidingVersion();
                        }
                        catch (VfsException e) {
                            DiffMergeSingleSelectionAction.this.showErrorMessage(DiffMergeSingleSelectionAction.ERROR_DIALOG_MESSAGE + e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                });
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.this.showMessage("Your (local) version accepted. Conflict resolved successully.", 1);
                    }
                });
            } else {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            ((IVfsIntegrateCollision)collision).markAsResolved();
                        }
                        catch (VfsException e) {
                            DiffMergeSingleSelectionAction.this.showErrorMessage(DiffMergeSingleSelectionAction.ERROR_DIALOG_MESSAGE + e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                });
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        DiffMergeSingleSelectionAction.this.showMessage("Conflict has been marked as resolved. To resolve it fully, check-in the activity containing the merge version.", 1);
                    }
                });
            }
            accepted = true;
        }
        return accepted;
    }

    private void viewConflictDifference(IVfsIntegrateCollision collision) {
        boolean useExternalTool = this.myPreferenceManager.isUseExternalDiff();
        final IVfsVersion activeVersion = collision.getActiveVersion();
        IVfsVersion collidingVersion = collision.getCollidingVersion();
        final File collidingFile = ExternalAction.createTmpFile(collidingVersion, "Conflicting_Version_" + collidingVersion.getBranchSequenceNumber() + "_");
        if (useExternalTool) {
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    File activeFile = ExternalAction.createTmpFile(activeVersion, "Active_Version_" + activeVersion.getBranchSequenceNumber() + "_");
                    monitor.onStart();
                    DiffMergeSingleSelectionAction.this.runExternalDiff(collidingFile, activeFile, true);
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        String leftVersionTitle = "( Conflicting ) version " + String.valueOf(collidingVersion.getBranchSequenceNumber()) + "  in Workspace : " + collidingVersion.getCreatorWorkspaceName();
        String rightVersionTitle = "( Active ) version " + String.valueOf(activeVersion.getBranchSequenceNumber()) + " in Workspace : " + activeVersion.getCreatorWorkspaceName();
        DiffEditorInput input = new DiffEditorInput(collidingFile, new IVfsVersion[]{activeVersion}, null, false);
        input.setTitle("/" + activeVersion.getWorkspaceRelativePath() + " - " + "  ( Changes between: 'Version " + collidingVersion.getBranchSequenceNumber() + " in Workspace: " + collidingVersion.getCreatorWorkspaceName() + "' & 'Version " + activeVersion.getBranchSequenceNumber() + " in Workspace: " + activeVersion.getCreatorWorkspaceName() + "' )");
        input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
        input.getCompareConfiguration().setLeftEditable(false);
        input.getCompareConfiguration().setRightLabel(rightVersionTitle);
        input.getCompareConfiguration().setRightEditable(false);
        if (input.getCompareConfiguration().isLeftEditable()) {
            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        }
        this.runInternalDiff(input);
    }

    private void viewConflictDifference(IVfsActivityElement activityElement) {
        IVfsVersion sourceVersion;
        final IVfsVersion targetVersion = activityElement.getAsVersion();
        IVfsActivity[] activities = activityElement.getActivities();
        if (activities == null || activities.length != 1 || activities[0] == null) {
            return;
        }
        IVfsWorkspace workspace = activityElement.getWorkspace();
        try {
            sourceVersion = targetVersion.getDiscardSourceVersion(workspace, activities[0]);
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            return;
        }
        if (sourceVersion == null) {
            this.showErrorMessage("Unable to determine the discard source version.");
            return;
        }
        final File collidingFile = ExternalAction.createTmpFile(sourceVersion, "Discard_Source_Version_" + sourceVersion.getBranchSequenceNumber() + "_");
        if (this.myPreferenceManager.isUseExternalDiff()) {
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    File targetFile = ExternalAction.createTmpFile(targetVersion, "Discard_Target_Version_" + targetVersion.getBranchSequenceNumber() + "_");
                    monitor.onStart();
                    DiffMergeSingleSelectionAction.this.runExternalDiff(collidingFile, targetFile, true);
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        String leftVersionTitle = "Discard source (Discarded) version - BSN: " + sourceVersion.getBranchSequenceNumber() + " in Workspace " + sourceVersion.getCreatorWorkspaceName();
        String rightVersionTitle = "Discard target (Winning) version - BSN " + targetVersion.getBranchSequenceNumber() + " in Workspace " + targetVersion.getCreatorWorkspaceName();
        DiffEditorInput input = new DiffEditorInput(collidingFile, new IVfsVersion[]{targetVersion}, null, false);
        input.setTitle("/" + targetVersion.getWorkspaceRelativePath() + " - Differences between Discard Source and Target Version");
        input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
        input.getCompareConfiguration().setLeftEditable(false);
        input.getCompareConfiguration().setRightLabel(rightVersionTitle);
        input.getCompareConfiguration().setRightEditable(false);
        if (input.getCompareConfiguration().isLeftEditable()) {
            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        }
        this.runInternalDiff(input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

