/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DiffMergeMultipleSelectionAction
extends AbstractDiffMergeAction {
    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        String actionName = this.getConfigProperty("ActionName", null);
        return selection.size() == 2 && actionName.equalsIgnoreCase("DiffVersions");
    }

    private void diffMultipleVersions(IVfsVersion[] versions) {
        IVfsVersion rightVersion;
        IVfsVersion leftVersion;
        File localFile = null;
        if (versions[0].isOpen() && versions[1].isOpen() || !versions[0].isOpen() && !versions[1].isOpen()) {
            localFile = this.getOpenVersionFile(versions[0]);
            leftVersion = versions[0];
            rightVersion = versions[1];
        } else if (versions[0].isOpen()) {
            localFile = this.getOpenVersionFile(versions[0]);
            leftVersion = versions[0];
            rightVersion = versions[1];
        } else if (versions[1].isOpen()) {
            localFile = this.getOpenVersionFile(versions[1]);
            leftVersion = versions[1];
            rightVersion = versions[0];
        } else {
            localFile = ExternalAction.createTmpFile(versions[0], "Version_" + String.valueOf(versions[0].getBranchSequenceNumber()) + "_");
            leftVersion = versions[0];
            rightVersion = versions[1];
        }
        boolean useExternalTool = BluebirdPlugin.getDefault().getPreferenceManager().isUseExternalDiff();
        if (useExternalTool) {
            final File leftFile = ExternalAction.createTmpFile(rightVersion, "Version_" + rightVersion.getBranchSequenceNumber() + "_");
            final File loc = localFile;
            final IVfsProgressMonitor monitor = this.getProgressMonitor();
            Thread actionThread = new Thread(){

                public void run() {
                    monitor.onStart();
                    DiffMergeMultipleSelectionAction.this.runExternalDiff(leftFile, loc, true);
                    monitor.onFinish(null);
                }
            };
            actionThread.start();
            return;
        }
        String leftVersionTitle = "version " + leftVersion.getBranchSequenceNumber() + " in Workspace : " + leftVersion.getCreatorWorkspaceName();
        String rightVersionTitle = "version " + rightVersion.getBranchSequenceNumber() + " in Workspace : " + rightVersion.getCreatorWorkspaceName();
        DiffEditorInput input = new DiffEditorInput(localFile, new IVfsVersion[]{rightVersion}, null, false);
        input.getCompareConfiguration().setLeftLabel(leftVersionTitle);
        input.getCompareConfiguration().setLeftEditable(this.isVersionOpenByCurrentUser(leftVersion));
        input.getCompareConfiguration().setRightLabel(rightVersionTitle);
        input.getCompareConfiguration().setRightEditable(false);
        if (this.isVersionOpenByCurrentUser(leftVersion)) {
            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
        }
        input.setTitle("/" + leftVersion.getWorkspaceRelativePath() + " - " + "( Changes between: 'Version " + rightVersion.getBranchSequenceNumber() + " in Workspace: " + rightVersion.getCreatorWorkspaceName() + "' & 'Version " + leftVersion.getBranchSequenceNumber() + " in Workspace: " + leftVersion.getCreatorWorkspaceName() + "' )");
        this.runInternalDiff(input);
    }

    File getOpenVersionFile(IVfsVersion openVersion) {
        File localFile = null;
        try {
            IVfsWorkspace workspace = openVersion.getCreatorWorkspace();
            if (workspace != null && openVersion.getRepresentingFile(workspace) != null) {
                localFile = new File(openVersion.getRepresentingFile(workspace).getLocalFile().getAbsolutePath());
            }
            if (localFile == null) {
                localFile = ExternalAction.createTmpFile(openVersion, "Version_" + String.valueOf(openVersion.getBranchSequenceNumber()) + "_");
            }
        }
        catch (VfsException e) {
            localFile = ExternalAction.createTmpFile(openVersion, "Version_" + String.valueOf(openVersion.getBranchSequenceNumber()) + "_");
        }
        return localFile;
    }

    protected void execute(final IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        this.setProgressMonitor(workerThreadMonitor);
        final String actionName = this.getConfigProperty("ActionName", null);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (actionName != null && actionName.equalsIgnoreCase("DiffVersions")) {
                    IVfsVersion[] versions = new IVfsVersion[2];
                    if (selection.getFirstElement() instanceof IVfsVersion) {
                        int i = 0;
                        Iterator it = selection.iterator();
                        while (it.hasNext()) {
                            versions[i++] = (IVfsVersion)it.next();
                        }
                    } else {
                        IVfsRevision[] revisions = new IVfsRevision[2];
                        int i = 0;
                        Iterator it = selection.iterator();
                        while (it.hasNext()) {
                            revisions[i] = (IVfsRevision)it.next();
                            versions[i] = revisions[i].getVersion();
                            ++i;
                        }
                    }
                    DiffMergeMultipleSelectionAction.this.diffMultipleVersions(versions);
                }
            }
        });
    }
}

