/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.ActivityDescribeDialog;
import com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DescribeActivityAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$DescribeActivityAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$DescribeActivityAction = DescribeActivityAction.class$("com.tssap.dtr.client.eclipse.ui.actions.DescribeActivityAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$DescribeActivityAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$DescribeActivityAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem = selection.getFirstElement();
        if (selectedItem instanceof IVfsActivity || selectedItem instanceof ClosedActivityWrapper || selectedItem instanceof IVfsIntegrateCollision || selectedItem instanceof IVfsRevision || selectedItem instanceof IVfsActivityElement) {
            return true;
        }
        if (selectedItem instanceof IVfsVersion) {
            IVfsVersion version = (IVfsVersion)selectedItem;
            if (version.isOpen()) {
                if (version.getCreatorWorkspace() != null) {
                    try {
                        IVfsFile file = version.getRepresentingFile(version.getCreatorWorkspace());
                        if (file != null && !file.getActivityState().equals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) {
                            return true;
                        }
                    }
                    catch (VfsException e) {}
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(final IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                boolean editable = false;
                boolean showActivityElements = false;
                IVfsActivity activity = null;
                Object selectedItem = selection.getFirstElement();
                if (selectedItem instanceof IVfsActivity) {
                    activity = (IVfsActivity)selectedItem;
                    try {
                        if (activity.isOpen()) {
                            editable = true;
                        }
                    }
                    catch (VfsException x) {
                        DescribeActivityAction.this.showErrorMessage(x.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    }
                } else if (selectedItem instanceof ClosedActivityWrapper) {
                    activity = ((ClosedActivityWrapper)selectedItem).activity;
                    showActivityElements = true;
                } else if (selectedItem instanceof IVfsVersion) {
                    activity = ((IVfsVersion)selectedItem).getCreatingActivity();
                    showActivityElements = true;
                } else if (selectedItem instanceof IVfsIntegrateCollision) {
                    activity = ((IVfsIntegrateCollision)selectedItem).getIntegratedActivity();
                    showActivityElements = true;
                } else if (selectedItem instanceof IVfsRevision) {
                    activity = ((IVfsRevision)selectedItem).getCreatingActivity();
                    showActivityElements = true;
                } else if (selectedItem instanceof IVfsActivityElement) {
                    IVfsVersion version = ((IVfsActivityElement)selectedItem).getAsVersion();
                    if (version != null) {
                        activity = version.getCreatingActivity();
                    }
                    showActivityElements = true;
                }
                if (activity == null) {
                    DescribeActivityAction.this.showErrorMessage("Problem occurred: could not obtain activity.");
                    return;
                }
                if (editable && !showActivityElements) {
                    new ActivityDescribeDialog(DescribeActivityAction.this.getShell(), activity, true).open();
                } else {
                    new DescribeActivityDialog(DescribeActivityAction.this.getShell(), activity, editable, false, showActivityElements).open();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

