/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.vtree.VersionTreeView;
import com.tssap.dtr.client.eclipse.ui.vtree.revisionHistory.RevisionHistoryDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CompareWithActiveVersionAction
extends AbstractDiffMergeAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$CompareWithActiveVersionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$CompareWithActiveVersionAction = CompareWithActiveVersionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.CompareWithActiveVersionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$CompareWithActiveVersionAction));
    private static final String COMPARE_TITLE = " ( Compare with Active Version in Workspace )";
    private static final String ACTIVE_TITLE = "Active (Remote) Version : ";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$CompareWithActiveVersionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        if (item instanceof IVfsFile) {
            IVfsFile file = (IVfsFile)item;
            if (file.getLocationState() != VfsFolderItemLocationState.NOT_MOUNTED && (file.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER || file.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT && file.getLocalFile().canWrite() && file.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST)) {
                return true;
            }
        } else if (item instanceof IVfsVersion) {
            IVfsVersion version = (IVfsVersion)item;
            try {
                return version.isFile();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        } else if (item instanceof IVfsRevision) {
            IVfsVersion version = ((IVfsRevision)item).getVersion();
            try {
                return version.isFile();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        } else if (item instanceof IVfsActivityElement) {
            return ((IVfsActivityElement)item).getAsVersion() != null;
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        block26: {
            Object selected = selection.getFirstElement();
            DtrPreferenceManager prefManager = BluebirdPlugin.getDefault().getPreferenceManager();
            if (selected instanceof IVfsFile) {
                IVfsFile file = (IVfsFile)selected;
                if (file.getLocalFile().exists()) {
                    try {
                        IVfsVersion activeVersion = file.getActiveVersion();
                        if (activeVersion == null) {
                            this.showErrorMessage("Unable to compare  : could not retrieve active version.  Check if active version is deleted.");
                            return;
                        }
                        String title = file.getWorkspaceRelativePath() + COMPARE_TITLE;
                        if (prefManager.isUseExternalDiff()) {
                            File leftFile = ExternalAction.createTmpFile(activeVersion, "_Version_" + activeVersion.getBranchSequenceNumber() + "_");
                            this.runExternalDiff(leftFile, new File(file.getLocalFile().getAbsolutePath()), false);
                            break block26;
                        }
                        DiffEditorInput input = new DiffEditorInput(new File(file.getLocalFile().getAbsolutePath()), new IVfsVersion[]{activeVersion}, null, false);
                        input.setTitle(title);
                        input.getCompareConfiguration().setLeftLabel(file.getLocalFile().getAbsolutePath());
                        input.getCompareConfiguration().setRightLabel(ACTIVE_TITLE + activeVersion.getLocationInGraph(activeVersion.getCreatorWorkspaceName()));
                        input.getCompareConfiguration().setRightEditable(false);
                        input.getCompareConfiguration().setLeftEditable(file.getLocalFile().canWrite());
                        if (file.getLocalFile().canWrite()) {
                            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                        }
                        this.runInternalDiff(input);
                    }
                    catch (VfsException e) {
                        this.showErrorMessage("Unable to retrieve active version :" + e.getLocalizedMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                }
            } else if (selected instanceof IVfsVersion || selected instanceof IVfsRevision || selected instanceof IVfsActivityElement) {
                IVfsVersion version = null;
                IVfsWorkspace activeVersionWorkspace = null;
                IVfsFile versionFile = null;
                IVfsVersion activeVersion = null;
                version = selected instanceof IVfsRevision ? ((IVfsRevision)selected).getVersion() : (selected instanceof IVfsActivityElement ? ((IVfsActivityElement)selected).getAsVersion() : (IVfsVersion)selected);
                try {
                    Shell activeShell = this.m_targetPart.getSite().getShell().getDisplay().getActiveShell();
                    if (activeShell.getData() instanceof RevisionHistoryDialog) {
                        RevisionHistoryDialog dialog = (RevisionHistoryDialog)((Object)activeShell.getData());
                        activeVersionWorkspace = dialog.getWorkspace();
                    } else if (this.m_targetPart instanceof VersionTreeView) {
                        activeVersionWorkspace = ((VersionTreeView)this.m_targetPart).getActiveWorkspace();
                    } else if (this.m_targetPart instanceof RepositoryView) {
                        Object[] parentObjects = this.getParentObjectForTreeSelection(selected, 1);
                        if (parentObjects.length == 1 && parentObjects[0] instanceof IVfsIntegrateCollision) {
                            IVfsIntegrateCollision parentCollision = (IVfsIntegrateCollision)parentObjects[0];
                            activeVersionWorkspace = version.getVersionId().equalsIgnoreCase(parentCollision.getActiveVersion().getVersionId()) ? parentCollision.getWorkspace() : parentCollision.getIntegratedActivity().getWorkspace();
                        } else {
                            Object[] parentWorkspaces = this.getParentObjectForTreeSelection(selected, 2);
                            if (parentWorkspaces.length == 1 && parentWorkspaces[0] instanceof IVfsWorkspace) {
                                activeVersionWorkspace = (IVfsWorkspace)parentWorkspaces[0];
                            }
                        }
                    }
                    if (activeVersionWorkspace == null) {
                        this.showErrorMessage("Unable to compare with active version of workspace : could not retrieve workspace object");
                        return;
                    }
                    versionFile = version.getCorrespondingFile(activeVersionWorkspace);
                    activeVersion = versionFile.getActiveVersion();
                    if (activeVersion == null) {
                        this.showErrorMessage("Unable to compare  : could not retrieve active version.  Check if active version is deleted.");
                        return;
                    }
                }
                catch (VfsException e) {
                    this.showErrorMessage("Unable to retrieve active version : " + e.getLocalizedMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    return;
                }
                if (prefManager.isUseExternalDiff()) {
                    File rightFile = null;
                    rightFile = version.isOpen() && versionFile.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT ? new File(versionFile.getLocalFile().getAbsolutePath()) : ExternalAction.createTmpFile(activeVersion, "_Version_" + activeVersion.getBranchSequenceNumber() + "_");
                    File leftFile = ExternalAction.createTmpFile(version, "_Version_" + version.getBranchSequenceNumber() + "_");
                    this.runExternalDiff(leftFile, rightFile, false);
                } else {
                    boolean leftEditable = false;
                    File localFile = null;
                    if (version.isOpen() && versionFile.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
                        localFile = new File(versionFile.getLocalFile().getAbsolutePath());
                        leftEditable = true;
                    } else {
                        localFile = ExternalAction.createTmpFile(version, "_Version_" + version.getBranchSequenceNumber() + "_");
                    }
                    String title = version.getWorkspaceRelativePath() + COMPARE_TITLE;
                    DiffEditorInput input = new DiffEditorInput(localFile, new IVfsVersion[]{activeVersion}, null, false);
                    input.setTitle(title);
                    input.getCompareConfiguration().setLeftEditable(leftEditable);
                    input.getCompareConfiguration().setLeftLabel(leftEditable ? version.getLocationInGraph(version.getCreatorWorkspaceName()) + "    ( " + localFile.getAbsolutePath() + " ) " : version.getLocationInGraph(version.getCreatorWorkspaceName()));
                    input.getCompareConfiguration().setRightEditable(false);
                    input.getCompareConfiguration().setRightLabel(ACTIVE_TITLE + activeVersion.getLocationInGraph(activeVersion.getCreatorWorkspaceName()));
                    if (leftEditable) {
                        input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                    }
                    this.runInternalDiff(input);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

