/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.CheckinActivityAction;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.actions.CheckinAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CheckinActivityAction
extends VfsObjectSelectionAction {
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Check-in Error";
    private static final String DEFAULT_DIALOG_MESSAGE = "Check-in of activity failed due to conflicts. You have to resolve the conflicts before checking-in first.\nTo resolve a conflict, you have to\n\t1) Merge your local file with the remote file, OR\n\t2) Accept your local file, OR\n\t3) Accept the remote file.\n\nIn case of name clash, you have to revert the file and rename or delete the local file.";
    private CheckinAction m_checkinAction = null;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem = selection.getFirstElement();
        return selectedItem instanceof IVfsActivity && this.isActionEnabled((IVfsActivity)selectedItem, VfsActionOnActivity.CHECKIN);
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        if (!this.saveAllEditors()) {
            return;
        }
        IVfsActivity activity = (IVfsActivity)selection.getFirstElement();
        DescribeActivityDialog dialogDesc = new DescribeActivityDialog(this.getShell(), activity, true, true, false);
        if (dialogDesc.open() == 0) {
            this.openCommandOutputView();
            class CheckinMonitor
            implements IVfsProgressMonitor {
                IVfsProgressMonitor m_monitor;
                private final /* synthetic */ CheckinActivityAction this$0;

                CheckinMonitor(CheckinActivityAction this$0, IVfsProgressMonitor monitor) {
                    this.this$0 = this$0;
                    this.m_monitor = monitor;
                }

                public void onFinish(Throwable throwable) {
                    IVfsCheckinCollision[] checkinCollisions;
                    if (this.m_monitor != null) {
                        this.m_monitor.onFinish(throwable);
                    }
                    if ((checkinCollisions = CheckinActivityAction.access$000(this.this$0).getCollisions()) != null && checkinCollisions.length > 0) {
                        String dialogTitle = this.this$0.getConfigProperty("dialogTitle", "Check-in Error");
                        String dialogMessage = this.this$0.getConfigProperty("dialogMessage", "Check-in of activity failed due to conflicts. You have to resolve the conflicts before checking-in first.\nTo resolve a conflict, you have to\n\t1) Merge your local file with the remote file, OR\n\t2) Accept your local file, OR\n\t3) Accept the remote file.\n\nIn case of name clash, you have to revert the file and rename or delete the local file.");
                        Display.getDefault().syncExec(new Runnable(this, dialogTitle, dialogMessage){
                            private final /* synthetic */ String val$dialogTitle;
                            private final /* synthetic */ String val$dialogMessage;
                            private final /* synthetic */ CheckinMonitor this$1;
                            {
                                this.this$1 = this$1;
                                this.val$dialogTitle = val$dialogTitle;
                                this.val$dialogMessage = val$dialogMessage;
                            }

                            public void run() {
                                MessageDialog.openError((Shell)CheckinMonitor.access$100(this.this$1).getShell(), (String)this.val$dialogTitle, (String)this.val$dialogMessage);
                            }
                        });
                    }
                }

                public void onFinish(Throwable throwable, boolean alreadyLoggedInActionLog) {
                    IVfsCheckinCollision[] checkinCollisions;
                    if (this.m_monitor != null) {
                        this.m_monitor.onFinish(throwable, alreadyLoggedInActionLog);
                    }
                    if ((checkinCollisions = CheckinActivityAction.access$000(this.this$0).getCollisions()) != null && checkinCollisions.length > 0) {
                        String dialogTitle = this.this$0.getConfigProperty("dialogTitle", "Check-in Error");
                        String dialogMessage = this.this$0.getConfigProperty("dialogMessage", "Check-in of activity failed due to conflicts. You have to resolve the conflicts before checking-in first.\nTo resolve a conflict, you have to\n\t1) Merge your local file with the remote file, OR\n\t2) Accept your local file, OR\n\t3) Accept the remote file.\n\nIn case of name clash, you have to revert the file and rename or delete the local file.");
                        Display.getDefault().syncExec(new Runnable(this, dialogTitle, dialogMessage){
                            private final /* synthetic */ String val$dialogTitle;
                            private final /* synthetic */ String val$dialogMessage;
                            private final /* synthetic */ CheckinMonitor this$1;
                            {
                                this.this$1 = this$1;
                                this.val$dialogTitle = val$dialogTitle;
                                this.val$dialogMessage = val$dialogMessage;
                            }

                            public void run() {
                                MessageDialog.openError((Shell)CheckinMonitor.access$100(this.this$1).getShell(), (String)this.val$dialogTitle, (String)this.val$dialogMessage);
                            }
                        });
                    }
                }

                public void onProgress(int percentCompleted) {
                    if (this.m_monitor != null) {
                        this.m_monitor.onProgress(percentCompleted);
                    }
                }

                public void onStart() {
                    if (this.m_monitor != null) {
                        this.m_monitor.onStart();
                    }
                }

                static /* synthetic */ CheckinActivityAction access$100(CheckinMonitor x0) {
                    return x0.this$0;
                }
            }
            this.m_checkinAction = new CheckinAction(activity, (IVfsProgressMonitor)new CheckinMonitor(this, workerThreadMonitor));
            this.executeFinalVfsAction((IVfsAction)this.m_checkinAction);
        }
    }

    private boolean saveAllEditors() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows == null) {
            return false;
        }
        boolean prompt = !BluebirdPlugin.getDefault().getPreferenceStore().getBoolean("autoSave_beforeCheckin");
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                if (!pages[j].saveAllEditors(prompt)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ CheckinAction access$000(CheckinActivityAction x0) {
        return x0.m_checkinAction;
    }
}

