/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.automerge.AutomergeEngine;
import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeNonUIDialog;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.SyncAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class AutomergeAction
extends VfsObjectSelectionAction {
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$AutomergeAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$AutomergeAction = AutomergeAction.class$("com.tssap.dtr.client.eclipse.ui.actions.AutomergeAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$AutomergeAction));
    private static final String ACTION_NAME_ATTRIBUTE = "ActionName";
    private static final String UI_VERSION = "ShowUI";
    private static final String NON_UI_VERSION = "WithoutUI";
    private final DtrPreferenceManager fManager = BluebirdPlugin.getDefault().getPreferenceManager();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$AutomergeAction;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision selectedCollision = (IVfsIntegrateCollision)selection.getFirstElement();
            if (!selectedCollision.getWorkspace().isModifiable()) {
                return false;
            }
            if (!IntegrateCollisionUtil.belongsToOneWorkspace(selection)) {
                return false;
            }
        } else if (selection.getFirstElement() instanceof IVfsActivityRecordedFolderItem && !this.isCheckinCollisionSelectionValid(selection)) {
            return false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (element instanceof IVfsIntegrateCollision || element instanceof IVfsActivityRecordedFolderItem) {
                if (element instanceof IVfsIntegrateCollision) {
                    IVfsIntegrateCollision currentCollision = (IVfsIntegrateCollision)element;
                    IVfsIntegrateCollision.VfsIntegrateCollisionInternalState collisionState = currentCollision.getInternalState();
                    if (collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) || collisionState.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED) || currentCollision.getCollisionType() == VfsCollisionType.NAME_CLASH) {
                        return false;
                    }
                    if (currentCollision.getActiveVersion().isDeleted()) {
                        return false;
                    }
                }
                if (!(element instanceof IVfsActivityRecordedFolderItem)) continue;
                IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)element;
                try {
                    if (item.getCheckinCollision() != null) continue;
                    return false;
                }
                catch (VfsException e) {
                    LOCATION.errorT("Catched: " + e.getMessage());
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isCheckinCollisionSelectionValid(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        IVfsWorkspace workspace = null;
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IVfsActivityRecordedFolderItem)) {
                return false;
            }
            IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)element;
            if (workspace == null) {
                workspace = item.getWorkspace();
            } else if (!workspace.equals(item.getWorkspace())) {
                return false;
            }
            try {
                if (item.getCheckinCollision() != null) continue;
                return false;
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    private void processIntegrateCollisions(final IStructuredSelection selection, final AutomergeEngine engine) {
        final boolean[] activityNeeded = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                activityNeeded[0] = IntegrateCollisionUtil.isActivityNeeded(selection);
            }
        });
        IVfsActivity selectedActivity = null;
        if (activityNeeded[0] && (selectedActivity = IntegrateCollisionUtil.getMultipleSelectionActivityInOneWorkspace(selection, this.getShell())) == null) {
            return;
        }
        final IVfsActivity act = selectedActivity;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    IVfsIntegrateCollision collision = (IVfsIntegrateCollision)iter.next();
                    AutomergeAction.this.addCollisionToEngine(collision, engine, act);
                }
            }
        });
    }

    private void addCollisionToEngine(final IVfsIntegrateCollision collision, final AutomergeEngine engine, IVfsActivity activity) {
        IVfsVersion activeVersion = collision.getActiveVersion();
        try {
            IVfsFile file = activeVersion.getCorrespondingFile(collision.getWorkspace());
            if (this.isActionEnabled((IVfsFolderItem)file, VfsActionOnFolderItem.SYNC_TO_LATEST)) {
                VfsActionManager.getInstance().doSynchronously((IVfsAction)new SyncAction((IVfsFolderItem)file));
            }
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return;
        }
        boolean mergeVersionCreated = false;
        IVfsMergeVersion mergeVersion = collision.getMergeVersion();
        if (mergeVersion == null) {
            try {
                mergeVersion = collision.createMergeVersion(activity, collision.getWorkspace());
                mergeVersionCreated = true;
            }
            catch (VfsException e) {
                LOCATION.errorT("Catched: " + e.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                this.showMessage("Couldn't create merge version for resource: " + activeVersion.getDisplayName(), 3);
                return;
            }
        }
        final boolean created = mergeVersionCreated;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                engine.addCollision(new Collision(collision, created));
            }
        });
    }

    private void processCheckinCollisions(IStructuredSelection selection, final AutomergeEngine engine) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            final IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)iter.next();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        engine.addCollision(new Collision(item.getCheckinCollision()));
                    }
                    catch (VfsException e) {
                        LOCATION.errorT("Caught: " + e.getMessage());
                        AutomergeAction.this.showErrorMessage("Couldn't get checkin collision for resource: " + item.getName());
                        return;
                    }
                }
            });
        }
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        String actionName = this.getConfigProperty(ACTION_NAME_ATTRIBUTE, null);
        final AutomergeEngine engine = new AutomergeEngine();
        if (selection.getFirstElement() instanceof IVfsIntegrateCollision) {
            if (IntegrateCollisionUtil.belongsToOneWorkspace(selection)) {
                this.processIntegrateCollisions(selection, engine);
            }
        } else if (selection.getFirstElement() instanceof IVfsActivityRecordedFolderItem) {
            this.processCheckinCollisions(selection, engine);
        }
        if (engine.getCollisions().length != 0) {
            if (actionName.equals(UI_VERSION)) {
                AutomergeDialog dialog = new AutomergeDialog(this.getShell(), "Auto-Merge", null);
                dialog.setInput(engine);
                dialog.open();
            } else if (actionName.equals(NON_UI_VERSION)) {
                this.runNonUIVersion(engine);
            }
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    engine.finish();
                }
            });
        }
    }

    private void runNonUIVersion(AutomergeEngine engine) {
        Collision[] collisions = engine.getCollisions();
        ArrayList<Collision> unresolvable = new ArrayList<Collision>();
        int i = 0;
        while (i < collisions.length) {
            if (collisions[i].getIntersectingDifferences() > 0) {
                unresolvable.add(collisions[i]);
            }
            ++i;
        }
        StringBuffer collisionsMessage = new StringBuffer();
        Iterator iter = unresolvable.iterator();
        while (iter.hasNext()) {
            Collision collision = (Collision)iter.next();
            collisionsMessage.append(" .../" + collision.getOriginalCollision().getValidSourceVersion().getWorkspaceRelativePath());
            collisionsMessage.append("\n");
        }
        StringBuffer wholeMessage = new StringBuffer("This action will perform Auto-Merge on selected conflict(s) and mark them as resolved.\n");
        if (collisionsMessage.length() != 0) {
            wholeMessage.append("\nConflict(s) on following file(s) has intersecting changes and has to be resolved manually:\n" + collisionsMessage);
        }
        wholeMessage.append("\n\n Do you want to continue?");
        AutomergeNonUIDialog dialog = new AutomergeNonUIDialog(this.getShell(), "Auto-Merge", null, wholeMessage.toString(), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            try {
                engine.runAutomerge(this.fManager.isAutomergeMarkAsResolved(), this.fManager.isAutomergeForce());
            }
            catch (AutomergeException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

