/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.DNDUtility;
import com.tssap.dtr.client.eclipse.ui.util.DetailMessageDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.SyncAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class AddToWorkspaceAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$AddToWorkspaceAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$AddToWorkspaceAction = AddToWorkspaceAction.class$("com.tssap.dtr.client.eclipse.ui.actions.AddToWorkspaceAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$AddToWorkspaceAction));
    private RepositoryView myRepositoryView = null;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$AddToWorkspaceAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.myRepositoryView = targetPart instanceof RepositoryView ? (RepositoryView)targetPart : null;
    }

    private RepositoryView getRepositoryView() {
        return this.myRepositoryView;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selectedItem;
        return this.m_targetPart instanceof RepositoryView && ((RepositoryView)this.m_targetPart).getViewID().equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView") && (selectedItem = selection.getFirstElement()) instanceof IVfsFolder && ((IVfsFolder)selectedItem).getLocalPath() != null;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFolder selectedFolder = (IVfsFolder)selection.getFirstElement();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getLocation().equals((Object)new Path(selectedFolder.getLocalPath()))) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Create Project", (String)("Destination location already contains project named: " + projects[i].getName() + "\nMove or delete this project and try again."));
                return;
            }
            ++i;
        }
        try {
            IVfsFolderItem[] items = selectedFolder.getFolderItems();
            boolean hasProjectFile = false;
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].asFile() != null && items[i2].asFile().getName().equals(".project")) {
                    hasProjectFile = true;
                }
                ++i2;
            }
            if (hasProjectFile) {
                this.createExisingProject(selectedFolder, workerThreadMonitor);
            } else {
                this.createNewProject(selectedFolder, workerThreadMonitor);
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    protected void createNewProject(IVfsFolder selectedFolder, IVfsProgressMonitor workerThreadMonitor) {
        IProject project = this.getNewProject(selectedFolder.getName());
        if (project != null) {
            if (project.exists()) {
                try {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                    IProjectDescription desc = project.getDescription();
                    desc.setLocation((IPath)new Path(selectedFolder.getLocalPath()));
                    project.move(desc, true, false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    MessageDialog.openError((Shell)this.getShell(), (String)"Create Project", (String)("Unable to create project: " + e.getMessage()));
                    return;
                }
            }
            this.syncAndCreateProject(selectedFolder, project, workerThreadMonitor);
        }
    }

    protected void createExisingProject(IVfsFolder selectedFolder, IVfsProgressMonitor workerThreadMonitor) {
        String projectName = this.getProjectName(selectedFolder.getName());
        if (projectName == null) {
            return;
        }
        if (projectName.trim().equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Create Project", (String)"Name of Eclipse Project must not be empty!");
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Create Project", (String)"Unable to add project to workspace - another project with the same name already exists.");
        } else {
            this.syncAndCreateProject(selectedFolder, project, workerThreadMonitor);
        }
    }

    private void syncAndCreateProject(final IVfsFolder selectedFolder, final IProject project, final IVfsProgressMonitor workerThreadMonitor) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    RepositoryView view;
                    if (selectedFolder != null) {
                        monitor.beginTask("Synchronizing project with repository ...", 4);
                        monitor.worked(1);
                        AddToWorkspaceAction.this.openCommandOutputView();
                        VfsActionManager.getInstance().doSynchronously((IVfsAction)new SyncAction((IVfsFolderItem)selectedFolder, workerThreadMonitor));
                        monitor.worked(1);
                    }
                    monitor.setTaskName("Creating project in proper location ...");
                    NullProgressMonitor progressMonitor = new NullProgressMonitor();
                    if (!project.exists()) {
                        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                        projectDescription.setLocation((IPath)new Path(selectedFolder.getLocalPath()));
                        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
                    }
                    project.open((IProgressMonitor)progressMonitor);
                    monitor.worked(1);
                    monitor.setTaskName("Sharing project with repository...");
                    if (RepositoryProvider.getProvider((IProject)project) == null) {
                        view = AddToWorkspaceAction.this.getRepositoryView();
                        if (view == null) {
                            throw new RuntimeException("AddToWorkspaceAction was not called from the RepositoryView.");
                        }
                        if (!(view.getRepositoryTreeViewer().getTreeViewer().getInput() instanceof IVersionedFileSystemManager)) {
                            throw new RuntimeException("Respository view has current input object different from the IVersionedFileSystemManager.");
                        }
                    } else {
                        throw new RuntimeException("Created project is already associated with some RepositoryProvider..");
                    }
                    String clientDefName = ((IVersionedFileSystemManager)view.getRepositoryTreeViewer().getTreeViewer().getInput()).getCurrentContext().getClientName();
                    BluebirdPlugin.getDefault().associateProjectWithDTR(project, clientDefName);
                    selectedFolder.refreshFolderItems();
                    monitor.worked(1);
                }
                catch (CoreException unableToCreateProject) {
                    AddToWorkspaceAction.this.showErrorMessage("Creating project failed: " + unableToCreateProject.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)unableToCreateProject);
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        catch (InterruptedException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    private String getProjectName(String projectName) {
        InputDialog inpDlg = new InputDialog(this.getShell(), "Create Project", "Create a new Eclipse Project with following name:", projectName, null);
        if (inpDlg.open() == 0 && inpDlg.getValue() != null) {
            return inpDlg.getValue();
        }
        return null;
    }

    protected IProject getNewProject(String suggestedName) {
        NewProjectListener projectListener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)projectListener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)projectListener);
        IProject project = projectListener.getNewProject();
        if (project == null) {
            return null;
        }
        try {
            IResource[] members = project.members();
            if (members.length == 0 || members.length == 1 && members[0].getName().equals(".project")) {
                return project;
            }
            String message = MessageFormat.format("Project named: ''{0}'' isn''t empty. Project content will be merged with repository content.\n\nDo you want to continue?", project.getName());
            ArrayList<IResource> localFiles = new ArrayList<IResource>();
            int i = 0;
            while (i < members.length) {
                if (!members[i].getName().equals(".project")) {
                    localFiles.add(members[i]);
                }
                ++i;
            }
            String detailMessage = MessageFormat.format("Following project files may collide with repository files:{0}", DNDUtility.getAsText(localFiles));
            DetailMessageDialog dialog = new DetailMessageDialog(this.getShell(), "Create Project", null, message, detailMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
            dialog.setDetailButton(2);
            int code = dialog.open();
            if (code == 1 || code == -1) {
                if (project.exists()) {
                    project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                return null;
            }
            return project;
        }
        catch (CoreException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

