/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.MultipleSelectionMessageDialog;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class AddFolderAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$AddFolderAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$AddFolderAction = AddFolderAction.class$("com.tssap.dtr.client.eclipse.ui.actions.AddFolderAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$AddFolderAction));
    private static final String DEPTH_ATTRIBUTE = "depth";
    private static final String DEPTH_0 = "0";
    private static final String DEPTH_1 = "1";
    private static final String DEPTH_INF = "INF";
    private static final String DEFAULT_MSG_ADD_SUBTREE = "Choose local-only resources to add:";
    private static final int LIMIT_TO_DISPLAY = 100;
    private String m_depth;
    private AddSubtreeDialog m_addSubtreeDialog;
    private boolean m_pureAddSubtree;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$AddFolderAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem;

    protected boolean allowedMultipleSelection() {
        return true;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        VfsActionOnFolderItem action;
        if (!this.comeSelectionsFromSameWorkspace(selection)) {
            return false;
        }
        Object[] items = this.getSelectedProjectResources();
        if (items.length == 0) {
            items = Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem = AddFolderAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem);
        }
        int i = 0;
        while (i < items.length) {
            if (!(items[i] instanceof IVfsFolder) && !(items[i] instanceof IResource)) {
                return false;
            }
            if (!this.isSelectedInView("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView") && (items[i] instanceof IVfsFolder ? this.isIgnoredForAdding((IVfsFolderItem)((IVfsFolder)items[i])) : items[i] instanceof IResource && this.isIgnoredForAdding(items[i]))) {
                return false;
            }
            ++i;
        }
        this.m_depth = this.getConfigProperty(DEPTH_ATTRIBUTE, null);
        if (this.m_depth == null) {
            return false;
        }
        if (this.m_depth.equals(DEPTH_0)) {
            action = VfsActionOnFolderItem.ADD_0;
        } else if (this.m_depth.equals(DEPTH_1)) {
            action = VfsActionOnFolderItem.ADD_1;
        } else if (this.m_depth.equals(DEPTH_INF)) {
            action = VfsActionOnFolderItem.ADD_INF;
        } else {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof IVfsFolder && this.isActionEnabled((IVfsFolderItem)((IVfsFolder)item), action)) continue;
            return false;
        }
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected void execute(IStructuredSelection selection, IAction action, final IVfsProgressMonitor workerThreadMonitor) {
        IVfsActivityRecordedFolderItem[] items = (IVfsActivityRecordedFolderItem[])Util.getArrayFromIterator(selection.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem = AddFolderAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem);
        boolean addResourceWithDepth0 = false;
        final boolean[] toReturn = new boolean[]{false};
        final IVfsActivityRecordedFolderItem[] finalItems = items;
        if (!this.m_depth.equals(DEPTH_0)) {
            final Object[] localFilesAndFolders = new Object[2];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IVersionedFileSystemManager vfsManager;
                    TreeSet<String> resourcesToAdd = new TreeSet<String>();
                    int i = 0;
                    while (i < finalItems.length) {
                        try {
                            String[] paths = ((IVfsFolder)finalItems[i]).getLocalPathsOfLocalOnlyItemsBelow(false);
                            if (paths != null && paths.length > 0) {
                                resourcesToAdd.addAll(Arrays.asList(paths));
                            }
                        }
                        catch (VfsException x) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                        }
                        ++i;
                    }
                    int count = resourcesToAdd.size();
                    if (count < 1) {
                        String displayName = AddFolderAction.this.getConfigProperty("label", "Add");
                        MessageDialog.openInformation(null, (String)displayName, (String)"All resources below have already been added to the repository.");
                        toReturn[0] = true;
                        return;
                    }
                    if (AddFolderAction.this.isSelectedInView("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView")) {
                        AddFolderAction.this.handleDTRSpecificAdding(finalItems, workerThreadMonitor);
                        toReturn[0] = true;
                        return;
                    }
                    if (count > 100) {
                        MessageDialog warnDialog = new MessageDialog(AddFolderAction.this.getShell(), "Detected " + count + " local-only Resources", null, "There are too many local-only resouces to be added. Displaying all of them in a dialog box will take a long time.\n\n\nPress OK to add all resources directly into an activity (will not consider list of ignored resources)\n\nPress CONTINUE to see all resources in a dialog box before adding", 4, new String[]{IDialogConstants.OK_LABEL, "Continue", IDialogConstants.CANCEL_LABEL}, 2);
                        warnDialog.open();
                        if (warnDialog.getReturnCode() == 0) {
                            AddFolderAction.this.m_pureAddSubtree = true;
                            return;
                        }
                        if (warnDialog.getReturnCode() == 2) {
                            toReturn[0] = true;
                            return;
                        }
                    }
                    if ((vfsManager = finalItems[0].getVersionedFileSystemManager()) == null) {
                        Logbook.getErrorChapter().println("Internal error: <null> VersionedFileSystemManager");
                        toReturn[0] = true;
                        return;
                    }
                    ArrayList<IVfsFile> fileList = new ArrayList<IVfsFile>();
                    ArrayList<IVfsFolderItem> folderList = new ArrayList<IVfsFolderItem>();
                    int countIgnoredResources = 0;
                    Iterator iter = resourcesToAdd.iterator();
                    while (iter.hasNext()) {
                        try {
                            IVfsFolderItem folderItem = vfsManager.getFolderItem((String)iter.next());
                            if (folderItem == null) continue;
                            if (AddFolderAction.this.isIgnoredForAdding(folderItem)) {
                                ++countIgnoredResources;
                                continue;
                            }
                            IVfsFile file = folderItem.asFile();
                            if (file != null) {
                                if (!AddFolderAction.this.isActionEnabled((IVfsFolderItem)file, VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
                                    ++countIgnoredResources;
                                    continue;
                                }
                                fileList.add(file);
                                continue;
                            }
                            if (!AddFolderAction.this.isActionEnabled(folderItem, VfsActionOnFolderItem.ADD_0)) {
                                ++countIgnoredResources;
                                continue;
                            }
                            folderList.add(folderItem);
                        }
                        catch (VfsException x) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                        }
                    }
                    localFilesAndFolders[0] = fileList.toArray(new IVfsFile[fileList.size()]);
                    localFilesAndFolders[1] = folderList.toArray(new IVfsActivityRecordedFolderItem[folderList.size()]);
                    String ignoredResources = "";
                    if (countIgnoredResources > 0) {
                        ignoredResources = countIgnoredResources > 1 ? "\n(" + countIgnoredResources + " resources ignored)" : "\n(" + countIgnoredResources + " resource ignored)";
                    }
                    AddFolderAction.this.m_addSubtreeDialog = new AddSubtreeDialog(AddFolderAction.DEFAULT_MSG_ADD_SUBTREE + ignoredResources, (IVfsActivityRecordedFolderItem[])((IVfsFile[])localFilesAndFolders[0]), (IVfsActivityRecordedFolderItem[])localFilesAndFolders[1]);
                    if (AddFolderAction.this.m_addSubtreeDialog.open() != 0) {
                        toReturn[0] = true;
                        return;
                    }
                }
            });
            if (toReturn[0]) {
                return;
            }
            if (!this.m_pureAddSubtree) {
                IStructuredSelection selected = this.m_addSubtreeDialog.getReturnedSelection();
                items = (IVfsActivityRecordedFolderItem[])Util.getArrayFromIterator(selected.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem = AddFolderAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem);
                addResourceWithDepth0 = true;
            }
        }
        IVfsWorkspace workspace = items[0].getWorkspace();
        IVfsActivity activity = null;
        if (!WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            SelectActivityDialog selectActivity = new SelectActivityDialog(this.getShell(), workspace);
            if (selectActivity.open() == 0) {
                activity = selectActivity.getActivitySelection()[0];
            } else {
                return;
            }
        }
        this.openCommandOutputView();
        int depth = this.m_pureAddSubtree ? Integer.MAX_VALUE : (addResourceWithDepth0 ? 0 : (this.m_depth.equals(DEPTH_0) ? 0 : (this.m_depth.equals(DEPTH_1) ? 1 : Integer.MAX_VALUE)));
        this.executeFinalVfsAction((IVfsAction)new AddAction(items, activity, depth, workerThreadMonitor));
    }

    private void handleDTRSpecificAdding(IVfsActivityRecordedFolderItem[] folders, IVfsProgressMonitor workerThreadMonitor) {
        IVfsActivity activity;
        IVfsWorkspace workspace = folders[0].getWorkspace();
        if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
            activity = null;
        } else {
            SelectActivityDialog selectActivity = new SelectActivityDialog(this.getShell(), workspace);
            if (selectActivity.open() == 0) {
                activity = selectActivity.getActivitySelection()[0];
            } else {
                return;
            }
        }
        this.openCommandOutputView();
        int depth = this.m_depth.equals(DEPTH_0) ? 0 : (this.m_depth.equals(DEPTH_1) ? 1 : Integer.MAX_VALUE);
        this.executeFinalVfsAction((IVfsAction)new AddAction(folders, activity, depth, workerThreadMonitor));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddSubtreeDialog
    extends MultipleSelectionMessageDialog {
        private IVfsFolderItem[] p_folders;
        private Boolean p_showFolders;

        public AddSubtreeDialog(String message, IVfsActivityRecordedFolderItem[] files, IVfsActivityRecordedFolderItem[] folders) {
            super(AddFolderAction.this.getShell(), "Add local-only Resources", message, 0, (IVfsFolderItem[])(files.length > 0 ? files : folders), (IVfsFolderItem[])(files.length > 0 ? files : folders));
            this.p_folders = folders;
            if (folders.length > 0) {
                this.p_showFolders = new Boolean(files.length <= 0);
            }
        }

        protected Control createDialogArea(Composite arg0) {
            Composite parent = (Composite)super.createDialogArea(arg0);
            Layout layout = parent.getLayout();
            if (layout instanceof GridLayout) {
                ((GridLayout)layout).marginWidth = 0;
                ((GridLayout)layout).marginHeight = 0;
            }
            if (this.p_showFolders != null) {
                Button cxShowFolder = new Button(parent, 32);
                cxShowFolder.setText("Show local-only folders");
                cxShowFolder.setSelection(this.p_showFolders.booleanValue());
                cxShowFolder.addSelectionListener((SelectionListener)new SelectionAdapter(this, cxShowFolder){
                    private final /* synthetic */ Button val$cxShowFolder;
                    private final /* synthetic */ AddSubtreeDialog this$1;
                    {
                        this.this$1 = this$1;
                        this.val$cxShowFolder = val$cxShowFolder;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (this.val$cxShowFolder.getSelection()) {
                            AddSubtreeDialog.access$501(this.this$1, AddSubtreeDialog.access$400(this.this$1));
                        } else {
                            AddSubtreeDialog.access$601(this.this$1, AddSubtreeDialog.access$400(this.this$1));
                        }
                    }
                });
            }
            return parent;
        }

        protected boolean showLocalOnlyFolders() {
            if (this.p_showFolders != null) {
                return this.p_showFolders;
            }
            return false;
        }

        static /* synthetic */ IVfsFolderItem[] access$400(AddSubtreeDialog x0) {
            return x0.p_folders;
        }

        static /* synthetic */ void access$501(AddSubtreeDialog x0, Object[] x1) {
            super.addElements(x1);
        }

        static /* synthetic */ void access$601(AddSubtreeDialog x0, Object[] x1) {
            super.removeElements(x1);
        }
    }
}

