/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.util.RepositoryBrowseFavorite;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class AddFavoriteAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$AddFavoriteAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$AddFavoriteAction = AddFavoriteAction.class$("com.tssap.dtr.client.eclipse.ui.actions.AddFavoriteAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$AddFavoriteAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$AddFavoriteAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IVfsFolderItem;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFolderItem folderItem = (IVfsFolderItem)selection.getFirstElement();
        try {
            String name = this.getFavoriteName(folderItem.getBrowsePath());
            if (name == null) {
                return;
            }
            if (name.trim().equals("")) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Name of Favorite", (String)"Name of favorite must not be empty!");
                return;
            }
            RepositoryBrowseFavorite.addFavorite(folderItem, name);
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            this.showErrorMessage("Getting browse path failed: " + x.getMessage());
        }
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    private String getFavoriteName(String path) {
        InputDialog inpDlg = new InputDialog(this.getShell(), "Add Favorite", "Add a new favorite with following name:", path, null);
        if (inpDlg.open() == 0 && inpDlg.getValue() != null) {
            return inpDlg.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

