/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.actions.WorkerThreadProgressMonitor;
import com.tssap.dtr.client.eclipse.ui.conflict.ConflictUtility;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVCompareDialog;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDiffMergeAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$AbstractDiffMergeAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$AbstractDiffMergeAction = AbstractDiffMergeAction.class$("com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$AbstractDiffMergeAction));
    protected static final String ACTION_NAME_ATTRIBUTE = "ActionName";
    protected static final String LOCALLY_EDITABLE_ATTRIBUTE = "locallyEditable";
    protected static final String SHOW_VERSION_TREE_ATTRIBUTE = "showVersionTree";
    protected static final String DIFF = "Diff";
    protected static final String MERGE = "Merge";
    protected static final String RESOLVE = "Resolve";
    protected static final String MERGE_CHECKIN_COLLISION = "MergeCheckinCollision";
    protected static final String MERGE_INTEGRATE_COLLISION = "MergeIntegrateCollision";
    protected static final String VIEW_CONFLICT_DIFFERENCE = "ViewConflictDifference";
    protected static final String DIFF_VERSIONS = "DiffVersions";
    protected DtrPreferenceManager myPreferenceManager = BluebirdPlugin.getDefault().getPreferenceManager();
    private IVfsProgressMonitor fMonitor;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$AbstractDiffMergeAction;

    protected boolean runWithinWorkerThread() {
        return true;
    }

    protected int runInternalMerge(DiffEditorInput input) {
        if (this.getCompareResultOK(input)) {
            input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
            DAVCompareDialog dialog = new DAVCompareDialog(this.getShell(), input);
            return dialog.open();
        }
        return 1;
    }

    protected int runExternalMerge(Object collision, File baseVersion, File activeVersion, File collidingVersion, File mergedVersion, boolean wait) {
        ExternalAction ma = new ExternalAction(this.getShell());
        return ma.executeMerge(collision, baseVersion, activeVersion, collidingVersion, mergedVersion, wait);
    }

    protected int runInternalDiff(DiffEditorInput input) {
        if (this.getCompareResultOK(input)) {
            DAVCompareDialog dialog = new DAVCompareDialog(this.getShell(), input);
            return dialog.open();
        }
        return 1;
    }

    protected int runExternalDiff(File leftVersion, File rightVersion, boolean wait) {
        ExternalAction da = new ExternalAction(this.getShell());
        return da.executeDiff(leftVersion, rightVersion, wait);
    }

    protected boolean isEditable() {
        String editableAttribute = this.getConfigProperty(LOCALLY_EDITABLE_ATTRIBUTE, Boolean.FALSE.toString());
        return editableAttribute.equals(Boolean.TRUE.toString());
    }

    protected boolean isVersionTreeVisible() {
        String editableAttribute = this.getConfigProperty(SHOW_VERSION_TREE_ATTRIBUTE, Boolean.TRUE.toString());
        return editableAttribute.equals(Boolean.TRUE.toString());
    }

    protected IVfsVersion[] getVersions(IVfsFile vfsFile) {
        try {
            return vfsFile.refreshAndGetVersion().getVersionHistory().getVersionSet();
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            this.showErrorMessage("Getting version failed: " + x.getMessage());
            return null;
        }
    }

    protected Shell getShell() {
        final Shell[] out = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                out[0] = AbstractDiffMergeAction.super.getShell();
            }
        });
        return out[0];
    }

    protected IVfsCheckinCollision getCheckinCollision(IStructuredSelection sel) {
        try {
            if (sel.getFirstElement() instanceof IVfsActivityRecordedFolderItem) {
                IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)sel.getFirstElement();
                return item.getCheckinCollision();
            }
            if (sel.getFirstElement() instanceof IFile) {
                DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)((IFile)sel.getFirstElement()));
                IVfsFile vfsFile = teamProvider.getFolderItem((IResource)((IFile)sel.getFirstElement())).asFile();
                return vfsFile.getCheckinCollision();
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            this.showErrorMessage("Conflict action error: " + e.getMessage());
            return null;
        }
        return null;
    }

    protected IVfsProgressMonitor getProgressMonitor() {
        if (this.fMonitor == null) {
            IWorkbenchPart part = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            this.fMonitor = new WorkerThreadProgressMonitor(part);
        }
        return this.fMonitor;
    }

    protected void setProgressMonitor(IVfsProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    protected boolean getCompareResultOK(DiffEditorInput input) {
        try {
            if (ConflictUtility.guessType(new FileInputStream(input.getLocalFile())) != "txt") {
                MessageDialog.openError((Shell)this.getShell(), (String)"Compare", (String)"Diff/Merge operation for binary files is not supported.");
                return false;
            }
        }
        catch (FileNotFoundException e) {
            this.showErrorMessage("Compare editor local file does not exist: " + e.getMessage());
            return false;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message != null) {
                this.showErrorMessage("Compare failed. ");
                return false;
            }
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Compare", (String)"There are no differences in the selected resources.");
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        catch (InvocationTargetException ex) {
            this.showErrorMessage("Compare failed: " + ex.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
        }
        return false;
    }

    protected boolean isVersionOpenByCurrentUser(IVfsVersion version) {
        if (version.isOpen()) {
            try {
                IVfsWorkspace workspace = version.getCreatorWorkspace();
                if (workspace == null) {
                    return false;
                }
                IVfsFile file = version.getRepresentingFile(workspace);
                if (file != null) {
                    return file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT;
                }
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

