/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.tssap.dtr.client.lib.util.Logbook;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class TableViewerLabelSorter
extends ViewerSorter {
    private int m_columnIndex;
    private boolean m_ascending;

    public TableViewerLabelSorter(int sortByCoulmnIndex, boolean ascending) {
        this.m_columnIndex = sortByCoulmnIndex;
        this.m_ascending = ascending;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String label1 = this.getColumnText(viewer, e1);
        String label2 = this.getColumnText(viewer, e2);
        this.checkColumnText(label1, label2);
        return this.m_ascending ? label1.compareToIgnoreCase(label2) : -label1.compareToIgnoreCase(label2);
    }

    protected String getColumnText(Viewer viewer, Object obj) {
        IBaseLabelProvider labelProvider;
        if (viewer instanceof StructuredViewer && (labelProvider = ((StructuredViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
            return ((ITableLabelProvider)labelProvider).getColumnText(obj, this.m_columnIndex);
        }
        return "";
    }

    protected void checkColumnText(String str1, String str2) {
        if (str1 == null || str2 == null) {
            Logbook.getWarnChapter().println("Argument's toString in TableViewerLabelSorter.compare is <null>.");
            Logbook.getWarnChapter().flush();
            throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
        }
    }

    protected void setCoulmnIndexToSort(int columnIndex) {
        this.m_columnIndex = columnIndex;
    }

    protected int getCoulmnIndexToSort() {
        return this.m_columnIndex;
    }

    protected void setSortingDirection(boolean ascending) {
        this.m_ascending = ascending;
    }

    protected boolean getSortingDirection() {
        return this.m_ascending;
    }
}

