/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.tssap.dtr.client.eclipse.ui.ActivitySelectionViewer;
import com.tssap.dtr.client.eclipse.ui.ActivityViewerInput;
import com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectActivityDialog
extends Dialog {
    private static final String DEFAULT_TITLE = "Select Activity";
    private static final String BUTTON_LABEL_NEW = "New...";
    private static final int BUTTON_ID_NEW = 1025;
    private String m_title;
    private String m_message;
    private Image m_image;
    private boolean m_multiple;
    private IVfsWorkspace m_workspace = null;
    private IVfsActivity[] m_activities = null;
    private boolean m_suppressNewButton = false;
    private IVfsActivity[] m_activitySelection;
    private ActivitySelectionViewer fViewer;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivity;

    public SelectActivityDialog(Shell parentShell, IVfsWorkspace workspace) {
        this(parentShell, workspace, false, null, null, 0);
    }

    public SelectActivityDialog(Shell parentShell, IVfsWorkspace workspace, boolean allowedMultipleSelection, String title, String message, int messageType) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_workspace = workspace;
        this.setMemberAttributes(allowedMultipleSelection, title, message, messageType);
    }

    public SelectActivityDialog(Shell parentShell, IVfsActivity[] activities, IVfsWorkspace workspace, boolean allowedMultipleSelection, String title, String message, int messageType, boolean suppressNewButton) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_activities = new IVfsActivity[activities.length];
        System.arraycopy(activities, 0, this.m_activities, 0, activities.length);
        this.m_workspace = workspace;
        this.setMemberAttributes(allowedMultipleSelection, title, message, messageType);
        this.m_suppressNewButton = suppressNewButton;
    }

    private void setMemberAttributes(boolean allowedMultipleSelection, String title, String message, int messageType) {
        this.m_multiple = allowedMultipleSelection;
        this.m_title = title == null || title.trim().length() < 1 ? DEFAULT_TITLE : title.trim();
        this.m_message = message;
        if (this.m_message != null) {
            this.m_message = this.m_message.trim();
        }
        switch (messageType) {
            case 4: {
                this.m_image = Dialog.getImage((String)"dialog_warning_image");
                break;
            }
            case 1: {
                this.m_image = Dialog.getImage((String)"dialog_error_image");
                break;
            }
            case 2: {
                this.m_image = Dialog.getImage((String)"dialog_info_image");
                break;
            }
            case 3: {
                this.m_image = Dialog.getImage((String)"dialog_question_image");
                break;
            }
            default: {
                this.m_image = null;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseArea = (Composite)super.createDialogArea(parent);
        this.fViewer = new ActivitySelectionViewer(baseArea, this.m_multiple, this.m_image, this.m_message);
        ActivityViewerInput input = new ActivityViewerInput(this.m_workspace, this.m_activities);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectActivityDialog.this.handleSelectionChange(event);
            }
        });
        this.fViewer.setInput(input);
        return this.fViewer.getControl();
    }

    private void setActivitySelection(IVfsActivity[] activities) {
        this.m_activitySelection = activities;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button bnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        Button bnNew = null;
        if (!this.m_suppressNewButton) {
            bnNew = this.createButton(parent, 1025, BUTTON_LABEL_NEW, false);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.fViewer.getSelection().isEmpty()) {
            bnOK.setEnabled(false);
            if (bnNew != null) {
                bnNew.setFocus();
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            DescribeActivityDialog dialogNew = new DescribeActivityDialog(this.getShell(), this.m_workspace);
            if (dialogNew.open() == 0) {
                IVfsActivity newActivity = dialogNew.getReturnedActivity();
                if (this.m_activities != null) {
                    HashSet<IVfsActivity> activities = new HashSet<IVfsActivity>();
                    int i = 0;
                    while (i < this.m_activities.length) {
                        activities.add(this.m_activities[i]);
                        ++i;
                    }
                    activities.add(newActivity);
                    this.m_activities = (IVfsActivity[])Util.getArrayFromIterator(activities.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = SelectActivityDialog.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity);
                    this.fViewer.setInput(new ActivityViewerInput(this.m_workspace, this.m_activities));
                } else {
                    this.fViewer.refresh();
                }
                if (newActivity != null) {
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newActivity), true);
                    this.getButton(0).setEnabled(true);
                    this.getButton(0).setFocus();
                }
            } else {
                this.fViewer.getControl().setFocus();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void handleSelectionChange(SelectionChangedEvent event) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.fViewer.isSelectionValid());
        }
        if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            this.setActivitySelection((IVfsActivity[])Util.getArrayFromIterator(sel.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = SelectActivityDialog.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity));
        }
    }

    public IVfsActivity[] getActivitySelection() {
        return this.m_activitySelection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

