/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchFolderItemInViewerDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$SearchFolderItemInViewerDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$SearchFolderItemInViewerDialog = SearchFolderItemInViewerDialog.class$("com.tssap.dtr.client.eclipse.ui.SearchFolderItemInViewerDialog")) : class$com$tssap$dtr$client$eclipse$ui$SearchFolderItemInViewerDialog));
    private StructuredViewer m_viewer;
    private IVfsContext m_vfsContext;
    private Label m_image;
    private Label m_message;
    private Text m_txLocalPath;
    private Text m_txBrowsePath;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$SearchFolderItemInViewerDialog;

    public SearchFolderItemInViewerDialog(Shell parentShell, StructuredViewer viewer, IVfsContext context) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_viewer = viewer;
        this.m_vfsContext = context;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Navigate to Resource by Path");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        Composite editArea = new Composite(dialog, 0);
        editArea.setLayout((Layout)new GridLayout(2, false));
        editArea.setLayoutData((Object)new GridData(1808));
        this.m_image = new Label(editArea, 0);
        this.m_image.setLayoutData((Object)new GridData(66));
        this.m_image.setImage(LayoutHelper.EMPTY_IMAGE.getImage());
        this.m_message = new Label(editArea, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.getMinimumMessageWidth() * 4 / 3;
        this.m_message.setLayoutData((Object)gridData);
        Button bnLocalPath = new Button(editArea, 16);
        bnLocalPath.setText("Absolute local path (e.g. C:\\folder1\\folder2\\...)");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        bnLocalPath.setLayoutData((Object)gridData);
        new Label(editArea, 0);
        this.m_txLocalPath = new Text(editArea, 526340);
        this.m_txLocalPath.setLayoutData((Object)new GridData(768));
        this.m_txLocalPath.setEditable(false);
        Button bnBrowsePath = new Button(editArea, 16);
        bnBrowsePath.setText("Browse path (e.g. /workspacefolder/workspace/folder/...)");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        bnBrowsePath.setLayoutData((Object)gridData);
        new Label(editArea, 0);
        this.m_txBrowsePath = new Text(editArea, 526340);
        this.m_txBrowsePath.setLayoutData((Object)new GridData(768));
        this.m_txBrowsePath.setEditable(false);
        bnLocalPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchFolderItemInViewerDialog.this.m_txLocalPath.setEditable(true);
                SearchFolderItemInViewerDialog.this.m_txBrowsePath.setEditable(false);
                SearchFolderItemInViewerDialog.this.m_txLocalPath.setFocus();
            }
        });
        bnBrowsePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchFolderItemInViewerDialog.this.m_txLocalPath.setEditable(false);
                SearchFolderItemInViewerDialog.this.m_txBrowsePath.setEditable(true);
                SearchFolderItemInViewerDialog.this.m_txBrowsePath.setFocus();
            }
        });
        this.m_txLocalPath.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SearchFolderItemInViewerDialog.this.clearMessageBar();
            }
        });
        this.m_txLocalPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFolderItemInViewerDialog.this.clearMessageBar();
                SearchFolderItemInViewerDialog.super.getButton(0).setEnabled(SearchFolderItemInViewerDialog.this.m_txLocalPath.getText().trim().length() > 0);
            }
        });
        this.m_txBrowsePath.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SearchFolderItemInViewerDialog.this.clearMessageBar();
            }
        });
        this.m_txBrowsePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFolderItemInViewerDialog.this.clearMessageBar();
                SearchFolderItemInViewerDialog.super.getButton(0).setEnabled(SearchFolderItemInViewerDialog.this.m_txBrowsePath.getText().trim().length() > 0);
            }
        });
        return dialog;
    }

    private int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void okPressed() {
        try {
            IVersionedFileSystemManager manager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(this.m_vfsContext);
            if (manager != null) {
                IVfsFolderItem folderItem;
                if (this.m_txLocalPath.getEditable()) {
                    String localPath = this.m_txLocalPath.getText().trim();
                    if (localPath.length() < 1 || localPath.indexOf("\\") == -1 || localPath.indexOf(":\\") == -1 || localPath.indexOf("/") != -1) {
                        this.setErrorMessage("Incorrect format for local path!");
                        this.handleErrorOccured();
                        return;
                    }
                    folderItem = manager.getFolderItem(localPath);
                } else {
                    String browsePath = this.m_txBrowsePath.getText().trim();
                    if (browsePath.length() < 1 || !browsePath.startsWith("/") || browsePath.indexOf("\\") != -1) {
                        this.setErrorMessage("Incorrect format for browse path!");
                        this.handleErrorOccured();
                        return;
                    }
                    folderItem = manager.getFolderItemByBrowsePath(browsePath);
                }
                if (folderItem != null) {
                    BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            SearchFolderItemInViewerDialog.this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)folderItem), true);
                        }
                    });
                    if (this.m_viewer.testFindItem((Object)folderItem) != null) {
                        super.okPressed();
                    } else {
                        this.setErrorMessage("Could not find the resource in current viewer!");
                        this.handleErrorOccured();
                    }
                } else {
                    this.setErrorMessage("No resource for given path!");
                    this.handleErrorOccured();
                }
            } else {
                this.setErrorMessage("Getting folder item failed: VersionedFileSystemManager is <null>!");
                this.handleErrorOccured();
            }
        }
        catch (VfsException x) {
            this.setErrorMessage("Getting folder item failed: " + x.getMessage());
            this.handleErrorOccured();
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    private void setErrorMessage(String message) {
        this.m_image.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        this.m_message.setText(message);
        this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(3));
    }

    private void clearMessageBar() {
        if (!this.m_message.getText().equals("")) {
            this.m_image.setText("");
            this.m_message.setText("");
        }
    }

    private void handleErrorOccured() {
        this.getButton(0).setEnabled(false);
        if (this.m_txLocalPath.getEditable()) {
            this.m_txLocalPath.selectAll();
            this.m_txLocalPath.setFocus();
        } else {
            this.m_txBrowsePath.selectAll();
            this.m_txBrowsePath.setFocus();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

