/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.DisplayPropertyPageData;
import com.tssap.dtr.client.eclipse.IDisplayPropertyData;
import com.tssap.dtr.client.eclipse.IDisplayPropertyHolder;
import com.tssap.dtr.client.eclipse.ui.PropertyContentProvider;
import com.tssap.dtr.client.eclipse.ui.PropertyLabelProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsImmutablePropertySupport;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PropertyViewer
extends Viewer
implements IMenuListener {
    private CTabFolder fTabFolder;
    private IAction fCopyAllToClipboardAction;
    private IAction fCopyNameToClipboardAction;
    private IAction fCopyValueToClipboardAction;
    private final String LIVE_PROPERTY_NAME = "supported-live-property-set";
    private IVfsImmutablePropertySupport fInput;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$PropertyViewer == null ? (class$com$tssap$dtr$client$eclipse$ui$PropertyViewer = PropertyViewer.class$("com.tssap.dtr.client.eclipse.ui.PropertyViewer")) : class$com$tssap$dtr$client$eclipse$ui$PropertyViewer));
    private Control fControl;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$PropertyViewer;

    public PropertyViewer() {
        this.createViewerActions();
    }

    public Control getControl() {
        return this.fControl;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        if (input instanceof IVfsImmutablePropertySupport) {
            this.fInput = (IVfsImmutablePropertySupport)input;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void createControl(Composite parent) {
        if (this.fInput == null) {
            this.createLabel(parent, "No resource is selected to display properties.", 1);
            return;
        }
        IDisplayPropertyHolder holder = this.getPropertyPageData();
        if (holder == null) {
            this.createLabel(parent, "Unable to get remote resource to extract properties for an IResource.\nResource probably is not in repository.", 1);
            return;
        }
        IDisplayPropertyData[] displayData = holder.getDisplayProperties();
        this.fTabFolder = new CTabFolder(parent, 2176);
        CTabItem liveItem = new CTabItem(this.fTabFolder, 0);
        liveItem.setText("Basic Properties");
        CTabItem deadItem = new CTabItem(this.fTabFolder, 0);
        deadItem.setText("Custom Properties");
        Display display = Display.getDefault();
        this.fTabFolder.setSelectionBackground(new Color[]{display.getSystemColor(1)}, new int[0]);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        liveItem.setControl((Control)this.createStandardTable((Composite)this.fTabFolder, displayData, null));
        deadItem.setControl((Control)this.createStandardTable((Composite)this.fTabFolder, this.getDeadProperties(), null));
        this.fTabFolder.setSelection(liveItem);
        this.fControl = deadItem.getControl();
    }

    private Table createStandardTable(Composite parent, IDisplayPropertyData[] data, Color backgorund) {
        Table table = new Table(parent, 68098);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (backgorund != null) {
            table.setBackground(backgorund);
        }
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText("Name");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        column.setResizable(true);
        column = new TableColumn(table, 0);
        column.setText("Value");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        column.setResizable(true);
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(768));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        tableViewer.setInput((Object)data);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu((Control)table);
        table.setMenu(menu);
        manager.addMenuListener((IMenuListener)this);
        return table;
    }

    private Label createLabel(Composite parent, String text, int hspan) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = hspan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private IDisplayPropertyHolder getPropertyPageData() {
        return new DisplayPropertyPageData(this.fInput);
    }

    private IDisplayPropertyData[] getDeadProperties() {
        try {
            ArrayList<DisplayPropertyWrapper> out = new ArrayList<DisplayPropertyWrapper>();
            IVfsProperty live = this.fInput.getProperty("supported-live-property-set");
            if (live != null) {
                IVfsProperty[] liveChildrens = live.getChildren();
                ArrayList<String> liveNames = new ArrayList<String>();
                int i = 0;
                while (i < liveChildrens.length) {
                    liveNames.add(this.createCanonicalName(liveChildrens[i]));
                    ++i;
                }
                IVfsProperty[] allProperties = this.fInput.getAllProperties();
                int i2 = 0;
                while (i2 < allProperties.length) {
                    if (!liveNames.contains(this.createCanonicalName(allProperties[i2]))) {
                        out.add(new DisplayPropertyWrapper(allProperties[i2]));
                    }
                    ++i2;
                }
            }
            return out.toArray(new IDisplayPropertyData[out.size()]);
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    private String createCanonicalName(IVfsProperty property) {
        return property.getNamespace() + " : " + property.getName();
    }

    private void createViewerActions() {
        this.fCopyAllToClipboardAction = new TableAction(){

            public String getText() {
                return "Copy Name(s) and Value(s)";
            }

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (sharedImages != null) {
                    return sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER");
                }
                return null;
            }

            protected void fillClipboard() {
                IDisplayPropertyData[] items = this.getTableSelection();
                int i = 0;
                while (i < items.length) {
                    this.addText(items[i].getName());
                    this.addText("\t");
                    this.addText(items[i].getValue().toString());
                    this.addText(this.EOL);
                    ++i;
                }
            }
        };
        this.fCopyNameToClipboardAction = new TableAction(){

            public String getText() {
                return "Copy Name(s)";
            }

            protected void fillClipboard() {
                IDisplayPropertyData[] items = this.getTableSelection();
                int i = 0;
                while (i < items.length) {
                    this.addText(items[i].getName());
                    this.addText(this.EOL);
                    ++i;
                }
            }
        };
        this.fCopyValueToClipboardAction = new TableAction(){

            public String getText() {
                return "Copy Value(s)";
            }

            protected void fillClipboard() {
                IDisplayPropertyData[] items = this.getTableSelection();
                int i = 0;
                while (i < items.length) {
                    this.addText(items[i].getValue().toString());
                    this.addText(this.EOL);
                    ++i;
                }
            }
        };
    }

    public void menuAboutToShow(IMenuManager manager) {
        Control control;
        manager.add(this.fCopyNameToClipboardAction);
        manager.add(this.fCopyValueToClipboardAction);
        manager.add(this.fCopyAllToClipboardAction);
        if (this.fTabFolder != null && (control = this.fTabFolder.getSelection().getControl()) instanceof Table) {
            this.fCopyNameToClipboardAction.setEnabled(((Table)control).getSelectionCount() > 0);
            this.fCopyValueToClipboardAction.setEnabled(((Table)control).getSelectionCount() > 0);
            this.fCopyAllToClipboardAction.setEnabled(((Table)control).getSelectionCount() > 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    abstract class TableAction
    extends Action {
        private StringBuffer fText = new StringBuffer();
        public final String EOL = System.getProperty("line.separator");

        TableAction() {
        }

        protected void addText(String text) {
            this.fText.append(text);
        }

        private void performCopy() {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            Object[] data = new Object[]{this.fText.toString()};
            Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
            clipboard.setContents(data, transferTypes);
        }

        protected IDisplayPropertyData[] getTableSelection() {
            Control control = PropertyViewer.this.fTabFolder.getSelection().getControl();
            if (control instanceof Table) {
                Table table = (Table)control;
                TableItem[] items = table.getSelection();
                IDisplayPropertyData[] outdata = new IDisplayPropertyData[items.length];
                int i = 0;
                while (i < items.length) {
                    outdata[i] = (IDisplayPropertyData)items[i].getData();
                    ++i;
                }
                return outdata;
            }
            return null;
        }

        protected abstract void fillClipboard();

        public void run() {
            this.fText = new StringBuffer();
            this.fillClipboard();
            this.performCopy();
        }

        public boolean isEnabled() {
            return this.getTableSelection() != null && this.getTableSelection().length != 0;
        }
    }

    class DisplayPropertyWrapper
    implements IDisplayPropertyData {
        private IVfsProperty fProperty;

        DisplayPropertyWrapper(IVfsProperty property) {
            this.fProperty = property;
        }

        public String getName() {
            return PropertyViewer.this.createCanonicalName(this.fProperty);
        }

        public Object getValue() {
            return this.fProperty.getValue();
        }

        public Composite createVisualName(Composite parent) {
            return null;
        }

        public Composite createVisualValue(Composite parent) {
            return null;
        }
    }
}

