/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ObjectDescriptionDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$ObjectDescriptionDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$ObjectDescriptionDialog = ObjectDescriptionDialog.class$("com.tssap.dtr.client.eclipse.ui.ObjectDescriptionDialog")) : class$com$tssap$dtr$client$eclipse$ui$ObjectDescriptionDialog));
    private final String m_actionID;
    private static final String DEFAULT_TITLE = "Object Description";
    private String m_title = "Object Description";
    private String EMPTY_TEXT = "";
    private Label m_messageBarImage;
    private Label m_messageBarTextField;
    private boolean m_editable = true;
    private static final int DEFAULT_MAX_NAME_LENGTH = 255;
    private static final String DEFAULT_NAME_LABEL = "Name:";
    static final String UNDEFINED_NAME = "[ not yet defined ]";
    private int m_nameMaxLength = 255;
    private String m_name = "[ not yet defined ]";
    private String m_nameLabel = "Name:";
    private Text m_nameTextField;
    private boolean m_forceNameInput = false;
    private static final String DEFAULT_DESCRIPTION_LABEL = "Description:";
    private String m_description = null;
    private String m_descriptionLabel = "Description:";
    private Text m_descriptionTextField;
    private IInputCheck m_inputChecker = null;
    private IButtonPressedAction m_buttonPressedAction = null;
    private static boolean DEFAULT_BUTTON = true;
    private static boolean NO_DEFAULT_BUTTON = false;
    private static boolean ENABLED = true;
    private static boolean NOT_ENABLED = false;
    public static final boolean FORCE_NAME_INPUT = true;
    public static final boolean DONT_FORCE_NAME_INPUT = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$ObjectDescriptionDialog;

    public ObjectDescriptionDialog(Shell parentShell, String actionID) {
        super(parentShell);
        this.m_actionID = actionID;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public ObjectDescriptionDialog(Shell parentShell, String actionID, String title, String nameLabel, String descriptionLabel) {
        this(parentShell, actionID);
        this.setTitle(title);
        this.setNameLabel(nameLabel);
        this.setDescriptionLabel(descriptionLabel);
    }

    public String getActionID() {
        return this.m_actionID;
    }

    public IButtonPressedAction getButtonPressedAction() {
        return this.m_buttonPressedAction;
    }

    public void setButtonPressedAction(IButtonPressedAction buttonPressedAction) {
        this.m_buttonPressedAction = buttonPressedAction;
    }

    public boolean isForceNameInput() {
        return this.m_forceNameInput;
    }

    public void setForceNameInput(boolean forceNameInput) {
        this.m_forceNameInput = forceNameInput;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public int getNameMaxLength() {
        return this.m_nameMaxLength;
    }

    public void setNameMaxLength(int nameMaxLength) {
        this.m_nameMaxLength = nameMaxLength;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name == null || name.length() == 0 ? UNDEFINED_NAME : (name.length() > 255 ? name.substring(0, 255) : name);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getNameLabel() {
        return this.m_nameLabel;
    }

    public void setNameLabel(String nameLabel) {
        this.m_nameLabel = nameLabel;
    }

    public String getDescriptionLabel() {
        return this.m_descriptionLabel;
    }

    public void setDescriptionLabel(String descriptionLabel) {
        this.m_descriptionLabel = descriptionLabel;
    }

    public IInputCheck getInputChecker() {
        return this.m_inputChecker;
    }

    public void setInputChecker(IInputCheck inputChecker) {
        this.m_inputChecker = inputChecker;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createDialogArea(Composite parent) {
        int defaultWidth;
        Composite dialog = (Composite)super.createDialogArea(parent);
        Composite dialogArea = new Composite(dialog, 0);
        dialogArea.setLayout((Layout)new GridLayout(3, false));
        dialogArea.setLayoutData((Object)new GridData(1808));
        this.m_messageBarImage = new Label(dialogArea, 0);
        this.m_messageBarImage.setLayoutData((Object)new GridData(66));
        this.m_messageBarImage.setImage(LayoutHelper.EMPTY_IMAGE.getImage());
        this.m_messageBarTextField = new Label(dialogArea, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.m_messageBarTextField.setLayoutData((Object)gridData);
        Label label = new Label(dialogArea, 0);
        label.setText(this.getNameLabel());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.m_nameTextField = new Text(dialogArea, 2052);
        this.m_nameTextField.setTextLimit(this.getNameMaxLength());
        this.m_nameTextField.setText(this.m_name);
        gridData = new GridData(768);
        gridData.widthHint = defaultWidth = this.convertHorizontalDLUsToPixels(300);
        this.m_nameTextField.setLayoutData((Object)gridData);
        label = new Label(dialogArea, 0);
        label.setText(this.getDescriptionLabel());
        gridData = new GridData(2);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.m_descriptionTextField = new Text(dialogArea, 2624);
        gridData = new GridData(1808);
        gridData.heightHint = defaultWidth / 4;
        this.m_descriptionTextField.setLayoutData((Object)gridData);
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            this.m_descriptionTextField.setText(this.getDescription());
        }
        if (this.isEditable()) {
            this.m_nameTextField.selectAll();
            this.m_nameTextField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    ObjectDescriptionDialog.this.clearMessageBar();
                }
            });
            if (this.isForceNameInput() || this.getInputChecker() != null) {
                this.m_nameTextField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (e.getSource() instanceof Text) {
                            ObjectDescriptionDialog.this.checkName((Text)e.getSource());
                        }
                    }
                });
            }
        } else {
            this.m_nameTextField.setEditable(false);
            this.m_descriptionTextField.setEditable(false);
        }
        return dialog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, DEFAULT_BUTTON);
        okButton.setEnabled(this.isForceNameInput() && (this.getName() == null || this.getName().length() == 0 || this.getName().equals(UNDEFINED_NAME)) ? NOT_ENABLED : ENABLED);
        if (this.isEditable()) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, NO_DEFAULT_BUTTON);
        }
    }

    protected void okPressed() {
        if (this.isEditable()) {
            this.setName(this.m_nameTextField.getText().trim());
            this.setDescription(this.m_descriptionTextField.getText().trim());
        }
        if (this.getButtonPressedAction() != null) {
            final ObjectDescriptionDialog thisDialog = this;
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        ObjectDescriptionDialog.this.getButtonPressedAction().okPressedAction(thisDialog);
                    }
                    catch (Exception e) {
                        ObjectDescriptionDialog.this.setErrorMessage(e.getMessage());
                        ObjectDescriptionDialog.super.getButton(0).setEnabled(false);
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                        return;
                    }
                }
            });
        }
        if (this.isErrorMessageInitial()) {
            super.okPressed();
        }
    }

    private void checkName(Text text) {
        this.clearMessageBar();
        String name = text.getText().trim();
        if (this.getInputChecker() != null) {
            try {
                this.getInputChecker().checkName(name);
            }
            catch (Exception e) {
                this.setErrorMessage(e.getMessage());
                this.getButton(0).setEnabled(false);
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return;
            }
        }
        if (this.isForceNameInput()) {
            if (name.length() > 0) {
                this.m_messageBarImage.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                this.m_messageBarTextField.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.m_messageBarTextField.setBackground(this.getShell().getDisplay().getSystemColor(29));
                this.m_messageBarTextField.setText(name.length() + " (max. " + this.getNameMaxLength() + ") character entered.");
                this.getButton(0).setEnabled(true);
            } else {
                this.setErrorMessage("Name cannot be empty!");
                this.getButton(0).setEnabled(false);
            }
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    void setErrorMessage(String message) {
        if (this.m_messageBarTextField == null) {
            return;
        }
        this.m_messageBarImage.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        this.m_messageBarTextField.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.m_messageBarTextField.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.m_messageBarTextField.setText(message);
    }

    boolean isErrorMessageInitial() {
        return this.m_messageBarTextField.getText().trim().length() == 0;
    }

    void clearMessageBar() {
        if (this.m_messageBarTextField != null && !this.EMPTY_TEXT.equals(this.m_messageBarTextField.getText())) {
            this.m_messageBarImage.setText(this.EMPTY_TEXT);
            this.m_messageBarTextField.setText(this.EMPTY_TEXT);
            this.m_messageBarTextField.setBackground(this.getShell().getDisplay().getSystemColor(22));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IButtonPressedAction {
        public void okPressedAction(ObjectDescriptionDialog var1) throws Exception;
    }

    public static interface IInputCheck {
        public void checkName(String var1) throws Exception;
    }
}

