/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.LoggerView;
import com.tssap.dtr.client.eclipse.ui.actions.ShowInRepositoryBrowserAction;
import com.tssap.dtr.client.eclipse.ui.actions.ShowVersionGraphAction;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.ImageSingletone;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

public class LoggerView
extends ViewPart {
    private static final String ERROR_ATTRIBUTE = "showErrorsText";
    private static final String INFO_ATTRIBUTE = "showInfoText";
    private static final String WARN_ATTRIBUTE = "shorWarnText";
    private static final String PLAIN_ATTRIBUTE = "showPlainText";
    private static final String CLEANUP_ATTRIBUTE = "cleanupTooltip";
    private static final String ERROR_LABEL_DEFAULT = "Error";
    private static final String INFO_LABEL_DEFAULT = "Info";
    private static final String WARN_LABEL_DEFAULT = "Warning";
    private static final String PLAIN_LABEL_DEFAULT = "Plain";
    private static final String CLEANUP_TOOLTIP_DEFAULT = "Clean Output";
    private static final String CLEANUP_ACTION_NAME = "Clear";
    private static final String FILTER_DIALOG_TITLE = "Filter Output by Message Type";
    private Color INFO_COLOR;
    private Color DEBUG_COLOR;
    private Color WARN_COLOR;
    private Color ERROR_COLOR;
    private ImageSingletone STDOUT_IMAGE;
    private ImageSingletone STDERR_IMAGE;
    private ImageSingletone ERROR_IMAGE;
    private ImageSingletone INFO_IMAGE;
    private ImageSingletone WARN_IMAGE;
    private ImageSingletone DEBUG_IMAGE;
    private ImageDescriptorSingletone CLEAR_IMAGE;
    private ImageDescriptorSingletone FILTER_IMAGE;
    private boolean myErrorVisible = true;
    private boolean myInfoVisible = true;
    private boolean myWarnVisible = true;
    private boolean myDebugVisible = true;
    private IConfigurationElement myConfig = null;
    private Table myTable;
    private boolean isActive = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$LoggerView == null ? (class$com$tssap$dtr$client$eclipse$ui$LoggerView = LoggerView.class$("com.tssap.dtr.client.eclipse.ui.LoggerView")) : class$com$tssap$dtr$client$eclipse$ui$LoggerView));
    private static LoggerView __singletonInstance;
    private static PrintStream __infoStream;
    static final int MAX_ROWS = 500;
    static final int HYSTERESIS = 100;
    private final List _tableLineQueue = Collections.synchronizedList(new LinkedList());
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$LoggerView;

    public LoggerView() {
        Runnable flusher = new Runnable(){

            public void run() {
                while (!Thread.interrupted()) {
                    this.doFlush();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            void doFlush() {
                int linesToFlush = LoggerView.this._tableLineQueue.size();
                if (linesToFlush == 0) {
                    return;
                }
                IViewSite viewSite = LoggerView.this.getViewSite();
                if (viewSite == null) {
                    return;
                }
                Shell shell = viewSite.getShell();
                if (shell == null) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display == null) {
                    return;
                }
                TableLine[] tableLines = new TableLine[linesToFlush];
                int i = 0;
                while (i < linesToFlush) {
                    TableLine tableLine;
                    tableLines[i] = tableLine = (TableLine)LoggerView.this._tableLineQueue.remove(0);
                    ++i;
                }
                display.asyncExec(new Runnable(this, tableLines){
                    private final /* synthetic */ TableLine[] val$tableLines;
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$tableLines = val$tableLines;
                    }

                    public void run() {
                        if (LoggerView.access$200(9.access$1100(this.this$1)).isDisposed()) {
                            return;
                        }
                        LoggerView.access$200(9.access$1100(this.this$1)).setRedraw(false);
                        LoggerView.access$200(9.access$1100(this.this$1)).deselectAll();
                        TableItem item = null;
                        int i = 0;
                        while (i < this.val$tableLines.length) {
                            TableLine tableLine = this.val$tableLines[i];
                            item = new TableItem(LoggerView.access$200(9.access$1100(this.this$1)), 0);
                            item.setText(" " + tableLine.message);
                            item.setForeground(tableLine.color);
                            item.setImage(tableLine.icon);
                            ++i;
                        }
                        int rows = LoggerView.access$200(9.access$1100(this.this$1)).getItemCount();
                        if (rows > 600) {
                            LoggerView.access$200(9.access$1100(this.this$1)).remove(0, 100);
                        }
                        if (item != null) {
                            LoggerView.access$200(9.access$1100(this.this$1)).showItem(item);
                        }
                        LoggerView.access$200(9.access$1100(this.this$1)).setRedraw(true);
                    }
                });
            }

            static /* synthetic */ LoggerView access$1100(9 x0) {
                return x0.LoggerView.this;
            }
        };
        Thread flusherThread = new Thread(flusher);
        flusherThread.setName("DtrCommandOutputFlusher");
        flusherThread.setDaemon(true);
        flusherThread.setPriority(10);
        flusherThread.start();
    }

    public static PrintStream getInfoStream() {
        return __infoStream;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.myTable = new Table(parent, 2);
        MenuManager contextMenuManager = new MenuManager();
        Menu menu = contextMenuManager.createContextMenu((Control)this.myTable);
        this.myTable.setMenu(menu);
        Action copyAction = new Action("Copy"){

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (sharedImages != null) {
                    return sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER");
                }
                return null;
            }

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                TableItem[] tableItems = LoggerView.this.myTable.getSelection();
                StringBuffer buffer = new StringBuffer();
                String EOL = System.getProperty("line.separator");
                int i = 0;
                while (i < tableItems.length) {
                    TableItem tableItem = tableItems[i];
                    buffer.append(tableItem.getText());
                    buffer.append(EOL);
                    ++i;
                }
                Object[] data = new Object[]{buffer.toString()};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                clipboard.setContents(data, transferTypes);
            }
        };
        contextMenuManager.add((IAction)copyAction);
        class ShowInBrowser
        extends ShowInX {
            public static final String TEXT = "Show in Repository Browser";
            private final /* synthetic */ LoggerView this$0;

            ShowInBrowser(LoggerView this$0) {
                class ShowInX
                extends Action {
                    private final ShowInX.PatternAndIndex sync;
                    private final ShowInX.PatternAndIndex update;
                    private final ShowInX.PatternAndIndex create;
                    private final ShowInX.PatternAndIndex remove;
                    private final ShowInX.PatternAndIndex upload;
                    private final ShowInX.PatternAndIndex download;
                    private final ShowInX.PatternAndIndex edit;
                    private final ShowInX.PatternAndIndex revert;
                    private final ShowInX.PatternAndIndex delete;
                    private final ShowInX.PatternAndIndex[] _patternAndIndexes;
                    IVfsFolderItem _folderItem;
                    private final /* synthetic */ LoggerView this$0;

                    ShowInX(LoggerView this$0) {
                        this.this$0 = this$0;
                        this.sync = new ShowInX.PatternAndIndex(this, "SYNC", 15);
                        this.update = new ShowInX.PatternAndIndex(this, "UPDATE", 15);
                        this.create = new ShowInX.PatternAndIndex(this, "CREATE", 15);
                        this.remove = new ShowInX.PatternAndIndex(this, "REMOVE", 15);
                        this.upload = new ShowInX.PatternAndIndex(this, "UPLOAD", 15);
                        this.download = new ShowInX.PatternAndIndex(this, "DOWNLOAD", 15);
                        this.edit = new ShowInX.PatternAndIndex(this, "EDIT", 15);
                        this.revert = new ShowInX.PatternAndIndex(this, "REVERT", 15);
                        this.delete = new ShowInX.PatternAndIndex(this, "DELETE", 15);
                        this._patternAndIndexes = new ShowInX.PatternAndIndex[]{this.sync, this.update, this.create, this.remove, this.upload, this.download, this.edit, this.revert, this.delete};
                    }

                    private String getAbsoluteLocalPath(ShowInX.PatternAndIndex patternAndIndex) {
                        TableItem[] items = LoggerView.access$200(this.this$0).getSelection();
                        if (items == null || items.length != 1) {
                            return null;
                        }
                        String message = items[0].getText();
                        if (message.indexOf(patternAndIndex.pattern) != patternAndIndex.index) {
                            return null;
                        }
                        int lastClosingParanthesis = message.lastIndexOf(41);
                        int lastOpeningParanthesis = message.lastIndexOf(40);
                        return message.substring(lastOpeningParanthesis + 1, lastClosingParanthesis);
                    }

                    public boolean isEnabled() {
                        int i = 0;
                        while (i < this._patternAndIndexes.length) {
                            ShowInX.PatternAndIndex patternAndIndex = this._patternAndIndexes[i];
                            String path = this.getAbsoluteLocalPath(patternAndIndex);
                            if (path != null) {
                                IVfsContext context = Configuration.getConfiguration().getActiveClient().getContext();
                                try {
                                    IVersionedFileSystemManager manager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(context);
                                    this._folderItem = manager.getFolderItem(path);
                                    if (this._folderItem != null) {
                                        return true;
                                    }
                                }
                                catch (VfsException e) {
                                    LogUtil.logCaughtException((Location)LoggerView.access$300(), (Throwable)e);
                                }
                            }
                            ++i;
                        }
                        return false;
                    }
                }
                super(this$0);
                this.this$0 = this$0;
            }

            public String getText() {
                return "Show in Repository Browser";
            }

            public void run() {
                if (this._folderItem == null) {
                    return;
                }
                class MyShowInRepositoryBrowserAction
                extends ShowInRepositoryBrowserAction {
                    private final /* synthetic */ ShowInBrowser this$1;

                    MyShowInRepositoryBrowserAction(ShowInBrowser this$1) {
                        this.this$1 = this$1;
                    }

                    public void doIt(IVfsFolderItem folderItem) {
                        this.execute((IStructuredSelection)new StructuredSelection((Object)folderItem), null, null);
                    }
                }
                new MyShowInRepositoryBrowserAction(this).doIt(this._folderItem);
            }
        }
        contextMenuManager.add((IAction)new ShowInBrowser(this));
        class ShowVersionGraph
        extends ShowInX {
            public static final String TEXT = "Show in Version Graph";
            private final /* synthetic */ LoggerView this$0;

            ShowVersionGraph(LoggerView this$0) {
                super(this$0);
                this.this$0 = this$0;
            }

            public String getText() {
                return "Show in Version Graph";
            }

            public void run() {
                if (this._folderItem == null) {
                    return;
                }
                class MyShowVersionGraphAction
                extends ShowVersionGraphAction {
                    private final /* synthetic */ ShowVersionGraph this$1;

                    MyShowVersionGraphAction(ShowVersionGraph this$1) {
                        this.this$1 = this$1;
                    }

                    public void doIt(IVfsFolderItem folderItem) {
                        this.execute((IStructuredSelection)new StructuredSelection((Object)folderItem), null, null);
                    }
                }
                new MyShowVersionGraphAction(this).doIt(this._folderItem);
            }
        }
        contextMenuManager.add((IAction)new ShowVersionGraph(this));
        contextMenuManager.addMenuListener(new IMenuListener((IAction)copyAction){
            private final /* synthetic */ IAction val$copyAction;
            {
                this.val$copyAction = val$copyAction;
            }

            public void menuAboutToShow(IMenuManager iMenuManager) {
                this.val$copyAction.setEnabled(LoggerView.this.myTable.getSelection() != null && LoggerView.this.myTable.getSelection().length > 0);
                IContributionItem[] contributionItems = iMenuManager.getItems();
                int i = 0;
                while (i < contributionItems.length) {
                    IAction action = ((ActionContributionItem)contributionItems[i]).getAction();
                    if (action.getText().equals("Show in Repository Browser")) {
                        action.setEnabled(action.isEnabled());
                    } else if (action.getText().equals("Show in Version Graph")) {
                        action.setEnabled(action.isEnabled());
                    }
                    ++i;
                }
            }
        });
        GridData data = new GridData(1808);
        this.myTable.setLayoutData((Object)data);
        this.isActive = true;
        Logbook.setErrorChapter((PrintStream)new CustomPrintStream(new DummyOutputStream()){

            public void printTheLine(String message) {
                LoggerView.this.error(message);
            }
        });
        Logbook.setInfoChapter((PrintStream)__infoStream);
        __singletonInstance = this;
        this.INFO_COLOR = Display.getDefault().getSystemColor(24);
        this.DEBUG_COLOR = Display.getDefault().getSystemColor(16);
        this.WARN_COLOR = Display.getDefault().getSystemColor(9);
        this.ERROR_COLOR = Display.getDefault().getSystemColor(3);
        this.STDOUT_IMAGE = new ImageSingletone("loggerIcons/stdout.gif");
        this.STDERR_IMAGE = new ImageSingletone("loggerIcons/stderr.gif");
        this.ERROR_IMAGE = new ImageSingletone("loggerIcons/error.gif");
        this.INFO_IMAGE = new ImageSingletone("loggerIcons/info.gif");
        this.WARN_IMAGE = new ImageSingletone("loggerIcons/warning.gif");
        this.DEBUG_IMAGE = new ImageSingletone("loggerIcons/plain.gif");
        this.CLEAR_IMAGE = new ImageDescriptorSingletone("loggerIcons/clear.gif");
        this.FILTER_IMAGE = new ImageDescriptorSingletone("config/filter.gif");
        Logbook.setPlainChapter((PrintStream)new CustomPrintStream(new DummyOutputStream()){

            public void printTheLine(String message) {
                LoggerView.this.debug(message);
            }
        });
        Logbook.setWarnChapter((PrintStream)new CustomPrintStream(new DummyOutputStream()){

            public void printTheLine(String message) {
                LoggerView.this.warn(message);
            }
        });
        Action clearAction = new Action(){

            public void run() {
                LoggerView.this.myTable.removeAll();
            }
        };
        clearAction.setImageDescriptor(LoggerView.__singletonInstance.CLEAR_IMAGE.getImageDescriptor());
        clearAction.setToolTipText(this.getProperty(CLEANUP_ATTRIBUTE, CLEANUP_TOOLTIP_DEFAULT));
        clearAction.setText(CLEANUP_ACTION_NAME);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)clearAction);
        contextMenuManager.add((IAction)clearAction);
        Action filterAction = new Action(){

            public void run() {
                ListSelectionDialog dialog = new ListSelectionDialog(LoggerView.this.getSite().getShell(), (Object)this, (IStructuredContentProvider)new FiltersContentProvider(), (ILabelProvider)new FiltersLabelProvider(), null);
                dialog.setTitle(LoggerView.FILTER_DIALOG_TITLE);
                ArrayList<FilterDescription> initSelection = new ArrayList<FilterDescription>();
                if (LoggerView.this.myErrorVisible) {
                    initSelection.add(FilterDescription.ERROR);
                }
                if (LoggerView.this.myInfoVisible) {
                    initSelection.add(FilterDescription.INFO);
                }
                if (LoggerView.this.myWarnVisible) {
                    initSelection.add(FilterDescription.WARNING);
                }
                if (LoggerView.this.myDebugVisible) {
                    initSelection.add(FilterDescription.PLAIN);
                }
                dialog.setInitialElementSelections(initSelection);
                if (0 == dialog.open()) {
                    Object[] result = dialog.getResult();
                    LoggerView.this.myErrorVisible = false;
                    LoggerView.this.myInfoVisible = false;
                    LoggerView.this.myWarnVisible = false;
                    LoggerView.this.myDebugVisible = false;
                    int i = 0;
                    while (result != null && i < result.length) {
                        FilterDescription selected = (FilterDescription)result[i];
                        String id = selected.getID();
                        if (id == LoggerView.ERROR_ATTRIBUTE) {
                            LoggerView.this.myErrorVisible = true;
                        } else if (id == LoggerView.INFO_ATTRIBUTE) {
                            LoggerView.this.myInfoVisible = true;
                        } else if (id == LoggerView.WARN_ATTRIBUTE) {
                            LoggerView.this.myWarnVisible = true;
                        } else if (id == LoggerView.PLAIN_ATTRIBUTE) {
                            LoggerView.this.myDebugVisible = true;
                        }
                        ++i;
                    }
                }
            }
        };
        filterAction.setImageDescriptor(this.FILTER_IMAGE.getImageDescriptor());
        filterAction.setToolTipText(FILTER_DIALOG_TITLE);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)filterAction);
    }

    public void dispose() {
        super.dispose();
        this.isActive = false;
    }

    public void setFocus() {
        this.myTable.setFocus();
    }

    public void stdout(String message) {
        if (this.myErrorVisible) {
            this.append(message, LoggerView.__singletonInstance.DEBUG_COLOR, LoggerView.__singletonInstance.STDOUT_IMAGE.getImage());
        }
    }

    public void stderr(String message) {
        if (this.myErrorVisible) {
            this.append(message, LoggerView.__singletonInstance.DEBUG_COLOR, LoggerView.__singletonInstance.STDERR_IMAGE.getImage());
        }
    }

    public void error(String message) {
        if (this.myErrorVisible) {
            this.append(message, LoggerView.__singletonInstance.ERROR_COLOR, LoggerView.__singletonInstance.ERROR_IMAGE.getImage());
        }
    }

    public void info(String message) {
        if (this.myInfoVisible) {
            this.append(message, LoggerView.__singletonInstance.INFO_COLOR, LoggerView.__singletonInstance.INFO_IMAGE.getImage());
        }
    }

    public void warn(String message) {
        if (this.myWarnVisible) {
            this.append(message, LoggerView.__singletonInstance.WARN_COLOR, LoggerView.__singletonInstance.WARN_IMAGE.getImage());
        }
    }

    public void debug(String message) {
        if (this.myDebugVisible) {
            this.append(message, LoggerView.__singletonInstance.DEBUG_COLOR, LoggerView.__singletonInstance.DEBUG_IMAGE.getImage());
        }
    }

    public void setInitializationData(IConfigurationElement cfg, String propertyName, Object data) {
        super.setInitializationData(cfg, propertyName, data);
        this.myConfig = cfg;
    }

    private String getProperty(String propertyName, String defaultValue) {
        String attribute;
        if (this.myConfig != null && (attribute = this.myConfig.getAttribute(propertyName)) != null && !"".equals(attribute)) {
            return attribute;
        }
        return defaultValue;
    }

    private void append(String message, Color color, Image image) {
        if (!this.isActive) {
            return;
        }
        TableLine tableLine = new TableLine(image, message, color);
        this._tableLineQueue.add(tableLine);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Location access$300() {
        return LOCATION;
    }

    static {
        __infoStream = new CustomPrintStream(new DummyOutputStream()){

            public void printTheLine(String message) {
                if (__singletonInstance != null) {
                    __singletonInstance.info(message);
                }
            }
        };
    }

    private class FiltersLabelProvider
    implements ILabelProvider {
        private FiltersLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof FilterDescription) {
                FilterDescription fDescr = (FilterDescription)element;
                String id = fDescr.getID();
                if (LoggerView.ERROR_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.ERROR_IMAGE.getImage();
                }
                if (LoggerView.INFO_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.INFO_IMAGE.getImage();
                }
                if (LoggerView.WARN_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.WARN_IMAGE.getImage();
                }
                if (LoggerView.PLAIN_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.STDOUT_IMAGE.getImage();
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FilterDescription) {
                FilterDescription fDescr = (FilterDescription)element;
                String id = fDescr.getID();
                if (LoggerView.ERROR_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.getProperty(LoggerView.ERROR_ATTRIBUTE, LoggerView.ERROR_LABEL_DEFAULT);
                }
                if (LoggerView.INFO_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.getProperty(LoggerView.INFO_ATTRIBUTE, LoggerView.INFO_LABEL_DEFAULT);
                }
                if (LoggerView.WARN_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.getProperty(LoggerView.WARN_ATTRIBUTE, LoggerView.WARN_LABEL_DEFAULT);
                }
                if (LoggerView.PLAIN_ATTRIBUTE.equals(id)) {
                    return LoggerView.this.getProperty(LoggerView.PLAIN_ATTRIBUTE, LoggerView.PLAIN_LABEL_DEFAULT);
                }
                return LoggerView.this.getProperty(id, id);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class FiltersContentProvider
    implements IStructuredContentProvider {
        private FiltersContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new FilterDescription[]{FilterDescription.ERROR, FilterDescription.WARNING, FilterDescription.INFO, FilterDescription.PLAIN};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FilterDescription {
        private String myID;
        public static FilterDescription ERROR = new FilterDescription("showErrorsText");
        public static FilterDescription WARNING = new FilterDescription("shorWarnText");
        public static FilterDescription INFO = new FilterDescription("showInfoText");
        public static FilterDescription PLAIN = new FilterDescription("showPlainText");

        public FilterDescription(String id) {
            this.myID = id;
        }

        public String getID() {
            return this.myID;
        }
    }

    private static final class TableLine {
        final Image icon;
        final String message;
        final Color color;

        TableLine(Image icon, String message, Color color) {
            this.icon = icon;
            this.message = message;
            this.color = color;
        }
    }

    private static class DummyOutputStream
    extends OutputStream {
        private DummyOutputStream() {
        }

        public void write(int i) {
            i = 0;
        }
    }

    static abstract class CustomPrintStream
    extends PrintStream {
        private StringBuffer _buffer = new StringBuffer();

        CustomPrintStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void println() {
            this.flushBuffer("");
        }

        public void println(char x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(double x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(float x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(int x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(long x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(boolean x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(char[] x) {
            this.flushBuffer(new String(x));
        }

        public void println(Object x) {
            this.flushBuffer(String.valueOf(x));
        }

        public void println(String x) {
            this.flushBuffer(x);
        }

        public void print(char c) {
            this._buffer.append(c);
        }

        public void print(double d) {
            this._buffer.append(d);
        }

        public void print(float f) {
            this._buffer.append(f);
        }

        public void print(int i) {
            this._buffer.append(i);
        }

        public void print(long l) {
            this._buffer.append(l);
        }

        public void print(boolean b) {
            this._buffer.append(b);
        }

        public void print(char[] s) {
            this._buffer.append(s);
        }

        public void print(String s) {
            this._buffer.append(s);
        }

        public void print(Object obj) {
            this._buffer.append(obj);
        }

        public void write(int i) {
            char currentChar = (char)i;
            if (currentChar == '\n' || currentChar == '\r') {
                this.flushBuffer("");
            } else {
                this._buffer.append(currentChar);
            }
        }

        private void flushBuffer(String additionalToAppend) {
            if (this._buffer.length() > 0) {
                this._buffer.append(additionalToAppend);
                this.printTheLine(this._buffer.toString());
                this._buffer.setLength(0);
            } else {
                this.printTheLine(additionalToAppend);
            }
        }

        abstract void printTheLine(String var1);
    }
}

