/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.dtr.client.eclipse.util.ILegend;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LegendDialog
extends ResizableTitleDialog {
    private static final String DIALOG_TITLE_PART = "Legend - ";
    private static final String LEGEND_DIALOG_LOCATION = "_LegendDialogLocation";
    private static final String LEGEND_DIALOG_SIZE = "_LegendHistoryDialogSize";
    private static final String NEW_LINE = "\n";
    private static final int RIGHT_MARGIN = 20;
    private static final int LINE_HEIGHT = 20;
    private static final int VERTICAL_GAP = 20;
    private static final int HORIZONTAL_GAP = 100;
    protected Canvas m_legendArea;
    protected IFigure m_panel;
    protected ScrollPane m_scrollPane;
    protected IFigure m_legendPanel;
    private LightweightSystem m_lws;
    ILegend[] m_legends;
    int m_maxImageWidth;
    private boolean m_useDraw2D;
    private IRepositoryViewLegendManager m_legendManager;

    public LegendDialog(Shell parent, String viewName, Image titleImage, ILegend[] legendElements) {
        super(parent, DIALOG_TITLE_PART + viewName, titleImage);
        if (!this.validateInput(legendElements)) {
            throw new IllegalArgumentException("Could not initialize LegendDialog because argument \"legendElements\" is <null>.");
        }
        this.m_legends = legendElements;
        this.m_maxImageWidth = 0;
        this.m_useDraw2D = true;
    }

    public LegendDialog(Shell parent, IRepositoryViewLegendManager legendManager, Image titleImage) {
        super(parent, legendManager == null ? "" : DIALOG_TITLE_PART + legendManager.getViewName(), titleImage);
        if (legendManager == null) {
            throw new IllegalArgumentException("Could not initialize LegendDialog because argument \"legendManager\" is <null>.");
        }
        this.m_legendManager = legendManager;
        this.m_legends = legendManager.getViewLegend();
    }

    protected org.eclipse.swt.graphics.Point getInitialSize() {
        org.eclipse.swt.graphics.Point sizePoint;
        String sizeString;
        String string = sizeString = this.m_useDraw2D ? this.getPreferenceStore().getString("com.tssap.dtr.client.eclipse_LegendHistoryDialogSize") : this.getPreferenceStore().getString(this.m_legendManager.getViewId() + LEGEND_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return super.getInitialSize();
    }

    protected org.eclipse.swt.graphics.Point getInitialLocation(org.eclipse.swt.graphics.Point initialSize) {
        org.eclipse.swt.graphics.Point locationPoint;
        String locationString = this.getPreferenceStore().getString(this.m_useDraw2D ? "com.tssap.dtr.client.eclipse_LegendDialogLocation" : this.m_legendManager.getViewId() + LEGEND_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    private void persistShellGeometry() {
        org.eclipse.swt.graphics.Point shellLocation = this.getShell().getLocation();
        org.eclipse.swt.graphics.Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        this.getPreferenceStore().setValue(this.m_useDraw2D ? "com.tssap.dtr.client.eclipse_LegendDialogLocation" : this.m_legendManager.getViewId() + LEGEND_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(this.m_useDraw2D ? "com.tssap.dtr.client.eclipse_LegendHistoryDialogSize" : this.m_legendManager.getViewId() + LEGEND_DIALOG_SIZE, sizeString);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite out = (Composite)super.createDialogArea(parent);
        if (this.m_useDraw2D) {
            this.m_legendArea = new Canvas(out, 0);
            this.m_legendArea.setLayoutData((Object)new GridData(1842));
            this.initDraw2D();
            this.m_legendArea.setVisible(true);
            this.m_legendArea.setBackground(ColorConstants.white);
            this.m_scrollPane.setBorder((Border)new LineBorder());
            this.m_legendPanel.setVisible(true);
            this.setMaxImageWidth();
            this.addElements();
            this.m_legendArea.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (LegendDialog.this.m_legendArea != null && LegendDialog.this.m_scrollPane != null) {
                        LegendDialog.this.m_scrollPane.setBounds(new Rectangle(0, 0, LegendDialog.this.m_legendArea.getSize().x, LegendDialog.this.m_legendArea.getSize().y));
                        int pageIncrement = LegendDialog.this.m_scrollPane.getBounds().height;
                        LegendDialog.this.m_scrollPane.getVerticalScrollBar().setPageIncrement(pageIncrement);
                        if (LegendDialog.this.m_legendArea.getSize().x > LegendDialog.this.m_maxImageWidth + 200) {
                            LegendDialog.this.removeElements();
                            LegendDialog.this.addElements();
                        }
                    }
                }
            });
            this.m_legendArea.setSize(this.getInitialSize());
        } else {
            boolean isFirstLegendHeader = true;
            Color colorWhite = this.getShell().getDisplay().getSystemColor(1);
            ScrolledComposite scrollArea = new ScrolledComposite(out, 2816);
            scrollArea.setBackground(colorWhite);
            scrollArea.setLayout((Layout)new GridLayout());
            scrollArea.setLayoutData((Object)new GridData(1808));
            Composite legendArea = new Composite((Composite)scrollArea, 0);
            scrollArea.setContent((Control)legendArea);
            legendArea.setBackground(colorWhite);
            legendArea.setLayout((Layout)new GridLayout(2, false));
            legendArea.setLayoutData((Object)new GridData(1808));
            int i = 0;
            while (i < this.m_legends.length) {
                GridData gridData;
                org.eclipse.swt.widgets.Label label;
                Image figureImage = this.m_legends[i].getFigureImage();
                if (figureImage == null) {
                    if (!isFirstLegendHeader) {
                        label = new org.eclipse.swt.widgets.Label(legendArea, 0);
                        label.setText("");
                        gridData = new GridData(768);
                        gridData.horizontalSpan = 2;
                        label.setBackground(colorWhite);
                    }
                    label = new org.eclipse.swt.widgets.Label(legendArea, 64);
                    label.setText(this.m_legends[i].getDescription());
                    gridData = new GridData(768);
                    gridData.horizontalSpan = 2;
                    label.setLayoutData((Object)gridData);
                    label.setFont(JFaceResources.getBannerFont());
                    label.setBackground(colorWhite);
                    if (isFirstLegendHeader) {
                        isFirstLegendHeader = false;
                    }
                } else {
                    label = new org.eclipse.swt.widgets.Label(legendArea, 0);
                    label.setImage(figureImage);
                    label.setBackground(colorWhite);
                    gridData = new GridData(2);
                    gridData.horizontalIndent = 5;
                    label.setLayoutData((Object)gridData);
                    label = new org.eclipse.swt.widgets.Label(legendArea, 64);
                    label.setText(this.m_legends[i].getDescription());
                    label.setBackground(colorWhite);
                    gridData = new GridData();
                    gridData.horizontalIndent = 10;
                    label.setLayoutData((Object)gridData);
                }
                ++i;
            }
            legendArea.pack();
            legendArea.layout();
            scrollArea.setSize(this.getInitialSize());
        }
        return out;
    }

    private void setMaxImageWidth() {
        int i = 0;
        while (i < this.m_legends.length) {
            this.m_maxImageWidth = Math.max(this.m_maxImageWidth, this.m_legends[i].getFigureImage().getBounds().width);
            ++i;
        }
    }

    private void addElements() {
        int currentYPosition;
        int newYPosition = currentYPosition = -this.m_scrollPane.getVerticalScrollBar().getValue();
        int imageYPosition = 0;
        int textYPosition = 0;
        int i = 0;
        while (i < this.m_legends.length) {
            currentYPosition = newYPosition + 20;
            imageYPosition = this.addImage(this.m_legends[i].getFigureImage(), currentYPosition);
            textYPosition = this.addDescription(this.m_legends[i].getDescription(), currentYPosition);
            newYPosition = Math.max(textYPosition, imageYPosition);
            ++i;
        }
        this.m_legendPanel.setPreferredSize(new Dimension(this.m_legendArea.getSize().x - 100, newYPosition + 20));
    }

    private void removeElements() {
        this.m_legendPanel.getChildren().removeAll(this.m_legendPanel.getChildren());
    }

    private int addImage(Image image, int yPosition) {
        int imageHeight = image.getBounds().height;
        int imageWidth = image.getBounds().width;
        Label label = new Label("");
        label.setOpaque(false);
        label.setBackgroundColor(ColorConstants.buttonLightest);
        label.setIcon(image);
        label.setLocation(new Point(10, yPosition));
        label.setIconDimension(new Dimension(imageWidth, imageHeight));
        label.setSize(imageWidth + 50, imageHeight);
        label.setIconAlignment(4);
        this.m_legendPanel.add((IFigure)label);
        return yPosition + imageHeight;
    }

    private int addDescription(String description, int yPosition) {
        int xLocation = this.m_maxImageWidth + 100;
        int widthOfCanvas = 0;
        widthOfCanvas = this.m_legendArea.getSize() == null || this.m_legendArea.getSize().x == 0 ? this.getInitialSize().x : this.m_legendArea.getSize().x;
        Label textLabel = new Label(description);
        int numberOfLines = 1;
        numberOfLines = this.getMultilineDescription(textLabel, widthOfCanvas - xLocation - 20);
        textLabel.setLocation(new Point(xLocation, yPosition));
        textLabel.setSize(widthOfCanvas - xLocation - 20, numberOfLines * 20);
        textLabel.setTextAlignment(8);
        textLabel.setLabelAlignment(1);
        this.m_legendPanel.add((IFigure)textLabel);
        return textLabel.getSize().height + yPosition;
    }

    private int getMultilineDescription(Label descriptionText, int width) {
        int generalCharacterWidth = 5;
        String description = descriptionText.getText();
        StringBuffer multiLine = new StringBuffer();
        int numberOfCharactersInSingleLine = Math.abs(width / generalCharacterWidth);
        int currentIndex = 0;
        int numberOfLines = 1;
        while (description.length() - currentIndex > numberOfCharactersInSingleLine) {
            multiLine.append(description.substring(currentIndex, currentIndex + numberOfCharactersInSingleLine));
            multiLine.append(NEW_LINE);
            ++numberOfLines;
            currentIndex += numberOfCharactersInSingleLine;
        }
        multiLine.append(description.substring(currentIndex));
        descriptionText.setText(multiLine.toString());
        return numberOfLines;
    }

    private void initDraw2D() {
        this.m_lws = new LightweightSystem(this.m_legendArea);
        this.m_panel = new Figure();
        this.m_scrollPane = new ScrollPane();
        this.m_legendPanel = new Panel();
        this.m_scrollPane.setVerticalScrollBar(new ScrollBar());
        this.m_scrollPane.setVerticalScrollBarVisibility(1);
        this.m_scrollPane.setVisible(true);
        DelegatingLayout thisLayout = new DelegatingLayout();
        this.m_legendPanel.setLayoutManager((LayoutManager)thisLayout);
        this.m_scrollPane.setView(this.m_legendPanel);
        this.m_panel.add((IFigure)this.m_scrollPane);
        this.m_lws.setContents(this.m_panel);
        this.m_legendPanel.setPreferredSize(new Dimension(500, 500));
        this.m_panel.setLocation(new Point(0, 0));
        this.m_legendArea.setVisible(false);
    }

    private boolean validateInput(ILegend[] legends) {
        if (legends == null) {
            return false;
        }
        int i = 0;
        while (i < legends.length) {
            if (legends[i] == null || legends[i].getDescription() == null || legends[i].getFigureImage() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean close() {
        this.persistShellGeometry();
        return super.close();
    }
}

