/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.TableViewerLabelSorter;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsVersionLabelProvider;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DescribeActivityDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog = DescribeActivityDialog.class$("com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog")) : class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog));
    private static final String TITLE_NEW = "New Activity";
    private static final String TITLE_DESCRIBE = "Describe Activity";
    private static final String TITLE_VIEW = "Activity Details";
    private static final String TITLE_CHECKIN = "Check-in Activity";
    private static final String LABEL_NAME = "Display name:";
    private static final String LABEL_DESC = "Description:";
    private static final String LABEL_ELEMENTS = "Elements:";
    private static final String LABEL_LASTMODI = "Last modified:";
    private static final String MSG_SPECIFY = "Please specify the display name!";
    private static final String MSG_EMPTY = "Display name of activity must not be empty!";
    private static final String UNDEFINED_NAME = "[ not yet defined ]";
    private static final int TEXTLIMIT_DISPLAYNAME = 255;
    private IVfsWorkspace m_workspace;
    private IVfsActivity m_activity;
    private boolean m_editable = true;
    private boolean m_forCheckin;
    private boolean m_showElements = false;
    private Label m_lbImage;
    private Label m_lbMessage;
    private Text m_txName;
    private Text m_txDesc;
    private boolean[] m_columnSorting = new boolean[]{true, true, true};
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog;

    public DescribeActivityDialog(Shell parentShell, IVfsWorkspace workspace) {
        super(parentShell);
        if (workspace == null) {
            throw new IllegalArgumentException("Could not initialize DescribeActivityDialog because the argument workspace is null.");
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_workspace = workspace;
    }

    public DescribeActivityDialog(Shell parentShell, IVfsActivity activity, boolean editable, boolean forCheckin, boolean showElements) {
        super(parentShell);
        if (activity == null) {
            throw new IllegalArgumentException("Could not initialize DescribeActivityDialog because the argument activity is null.");
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_activity = activity;
        this.m_editable = editable;
        this.m_forCheckin = forCheckin;
        this.m_showElements = showElements;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_activity == null) {
            newShell.setText(TITLE_NEW);
        } else if (!this.m_editable) {
            newShell.setText(TITLE_VIEW);
        } else if (this.m_forCheckin) {
            newShell.setText(TITLE_CHECKIN);
        } else {
            newShell.setText(TITLE_DESCRIBE);
        }
    }

    protected Control createDialogArea(Composite parent) {
        int defaultWidth;
        Composite dialog = (Composite)super.createDialogArea(parent);
        Composite dialogArea = new Composite(dialog, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        dialogArea.setLayout((Layout)gridLayout);
        dialogArea.setLayoutData((Object)new GridData(1808));
        this.m_lbImage = new Label(dialogArea, 0);
        this.m_lbImage.setLayoutData((Object)new GridData(66));
        this.m_lbImage.setImage(LayoutHelper.EMPTY_IMAGE.getImage());
        this.m_lbMessage = new Label(dialogArea, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.m_lbMessage.setLayoutData((Object)gdata);
        Label label = new Label(dialogArea, 0);
        label.setText(LABEL_NAME);
        gdata = new GridData();
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        this.m_txName = new Text(dialogArea, 2052);
        this.m_txName.setTextLimit(255);
        if (this.m_activity == null) {
            this.m_txName.setText(UNDEFINED_NAME);
        } else {
            try {
                this.m_txName.setText(this.m_activity.getDisplayName());
            }
            catch (VfsException x) {
                this.setErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        gdata = new GridData(768);
        gdata.widthHint = defaultWidth = this.convertHorizontalDLUsToPixels(300);
        this.m_txName.setLayoutData((Object)gdata);
        label = new Label(dialogArea, 0);
        label.setText(LABEL_DESC);
        gdata = new GridData(2);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        this.m_txDesc = new Text(dialogArea, 2624);
        gdata = new GridData(1808);
        gdata.heightHint = defaultWidth / 5;
        this.m_txDesc.setLayoutData((Object)gdata);
        try {
            if (this.m_activity != null && this.m_activity.getDescription() != null) {
                this.m_txDesc.setText(this.m_activity.getDescription());
            }
        }
        catch (VfsException x) {
            this.setErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        if (this.m_showElements && this.m_activity != null) {
            try {
                if (!this.m_activity.isOpen()) {
                    label = new Label(dialogArea, 0);
                    label.setText(LABEL_ELEMENTS);
                    gdata = new GridData(2);
                    gdata.horizontalSpan = 2;
                    label.setLayoutData((Object)gdata);
                    TableViewer tabViewer = new TableViewer(dialogArea, 2818);
                    this.createCopyAction(tabViewer, 1);
                    tabViewer.setContentProvider((IContentProvider)new ActivityElementsContentProvider());
                    tabViewer.setLabelProvider((IBaseLabelProvider)new ActivityElementsLabelProvider());
                    tabViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
                    tabViewer.setInput((Object)this.m_activity);
                    gdata = new GridData(1808);
                    gdata.heightHint = defaultWidth / 4;
                    tabViewer.getTable().setLayoutData((Object)gdata);
                    tabViewer.getTable().setBackground(parent.getShell().getDisplay().getSystemColor(22));
                    label = new Label(dialogArea, 0);
                    label.setText(LABEL_LASTMODI);
                    gdata = new GridData();
                    gdata.horizontalSpan = 2;
                    label.setLayoutData((Object)gdata);
                    Text txLastmodi = new Text(dialogArea, 2060);
                    txLastmodi.setText(Util.getGMTString(this.m_activity.getCheckedInDate()) + " by " + this.m_activity.getAuthor());
                    txLastmodi.setLayoutData((Object)new GridData(768));
                    label = new Label(dialogArea, 0);
                    label.setText("Integrated in:");
                    gdata = new GridData(2);
                    gdata.horizontalSpan = 2;
                    label.setLayoutData((Object)gdata);
                    final TableViewer tableViewer2 = new TableViewer(dialogArea, 68354);
                    this.createCopyAction(tableViewer2, 3);
                    final Table table = tableViewer2.getTable();
                    TableLayout layout = new TableLayout();
                    table.setLayout((Layout)layout);
                    gdata = new GridData(1808);
                    gdata.heightHint = defaultWidth / 4;
                    table.setLayoutData((Object)gdata);
                    SelectionAdapter headerListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            BusyIndicator.showWhile((Display)DescribeActivityDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this, e){
                                private final /* synthetic */ SelectionEvent val$e;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$e = val$e;
                                }

                                public void run() {
                                    int columnIndex = 1.access$200(this.this$1).indexOf((TableColumn)this.val$e.widget);
                                    ViewerSorter sorter = 1.access$300(this.this$1).getSorter();
                                    if (sorter instanceof IntegrationWorkspacesViewerSorter) {
                                        ((IntegrationWorkspacesViewerSorter)sorter).setCoulmnIndexToSort(columnIndex);
                                        ((IntegrationWorkspacesViewerSorter)sorter).setSortingDirection(!DescribeActivityDialog.access$500(1.access$400(this.this$1))[columnIndex]);
                                        DescribeActivityDialog.access$500((DescribeActivityDialog)1.access$400(this.this$1))[columnIndex] = !DescribeActivityDialog.access$500(1.access$400(this.this$1))[columnIndex];
                                        1.access$300(this.this$1).refresh(false);
                                    }
                                }
                            });
                        }

                        static /* synthetic */ Table access$200(1 x0) {
                            return x0.table;
                        }

                        static /* synthetic */ TableViewer access$300(1 x0) {
                            return x0.tableViewer2;
                        }

                        static /* synthetic */ DescribeActivityDialog access$400(1 x0) {
                            return x0.DescribeActivityDialog.this;
                        }
                    };
                    TableColumn column = new TableColumn(table, 0);
                    column.setText("Workspace");
                    column.addSelectionListener((SelectionListener)headerListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(400));
                    column = new TableColumn(table, 0);
                    column.setText("ISN");
                    column.addSelectionListener((SelectionListener)headerListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
                    column = new TableColumn(table, 0);
                    column.setText("Integration Date");
                    column.addSelectionListener((SelectionListener)headerListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
                    table.setHeaderVisible(true);
                    tableViewer2.setContentProvider((IContentProvider)new IntegrationWorkspacesContentProvider());
                    tableViewer2.setLabelProvider((IBaseLabelProvider)new IntegrationWorkspacesLabelProvider());
                    tableViewer2.setSorter((ViewerSorter)new IntegrationWorkspacesViewerSorter(0, true));
                    tableViewer2.setInput((Object)this.m_activity);
                    table.setBackground(parent.getShell().getDisplay().getSystemColor(22));
                }
            }
            catch (VfsException x) {
                this.setErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        if (this.m_editable) {
            this.m_txName.selectAll();
            this.m_txName.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    DescribeActivityDialog.this.clearMessageBar();
                }
            });
            this.m_txName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.getSource() instanceof Text) {
                        DescribeActivityDialog.this.checkDisplayName((Text)e.getSource());
                    }
                }
            });
        } else {
            this.m_txName.setEditable(false);
            this.m_txDesc.setEditable(false);
        }
        return dialog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button bnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.m_editable) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            if (this.m_forCheckin) {
                this.checkDisplayName(this.m_txName);
            }
        } else {
            bnOK.setFocus();
        }
    }

    protected void okPressed() {
        if (this.m_editable) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    String newName = DescribeActivityDialog.this.m_txName.getText().trim();
                    String newDesc = DescribeActivityDialog.this.m_txDesc.getText().trim();
                    try {
                        if (DescribeActivityDialog.this.m_activity == null) {
                            DescribeActivityDialog.this.m_activity = DescribeActivityDialog.this.m_workspace.createActivity(null);
                            DescribeActivityDialog.this.m_activity.setDisplayName(newName);
                            if (newDesc != null && !newDesc.equals("")) {
                                DescribeActivityDialog.this.m_activity.setDescription(newDesc);
                            }
                        } else {
                            String oldDesc = DescribeActivityDialog.this.m_activity.getDescription();
                            if (!DescribeActivityDialog.this.m_activity.getDisplayName().equals(newName)) {
                                DescribeActivityDialog.this.m_activity.setDisplayName(newName);
                            }
                            if (oldDesc != null && !oldDesc.equals(newDesc) || oldDesc == null && !newDesc.equals("")) {
                                DescribeActivityDialog.this.m_activity.setDescription(newDesc);
                            }
                        }
                    }
                    catch (VfsException x) {
                        DescribeActivityDialog.this.setErrorMessage(x.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                        return;
                    }
                }
            });
        }
        super.okPressed();
    }

    public IVfsActivity getReturnedActivity() {
        return this.m_activity;
    }

    private void checkDisplayName(Text text) {
        this.clearMessageBar();
        boolean nameInvalid = false;
        String name = text.getText().trim();
        if (name.length() < 1) {
            this.setErrorMessage(MSG_EMPTY);
            nameInvalid = true;
        } else if (this.m_forCheckin && name.startsWith(UNDEFINED_NAME)) {
            this.setErrorMessage(MSG_SPECIFY);
            nameInvalid = true;
        } else {
            this.m_lbImage.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
            this.m_lbMessage.setForeground(this.getShell().getDisplay().getSystemColor(28));
            this.m_lbMessage.setBackground(this.getShell().getDisplay().getSystemColor(29));
            this.m_lbMessage.setText(name.length() + " (max. " + 255 + ") character(s) entered.");
        }
        this.getButton(0).setEnabled(!nameInvalid);
    }

    private void setErrorMessage(String message) {
        if (this.m_lbMessage == null) {
            return;
        }
        this.m_lbImage.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        this.m_lbMessage.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.m_lbMessage.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.m_lbMessage.setText(message);
    }

    private void clearMessageBar() {
        if (this.m_lbMessage != null && !"".equals(this.m_lbMessage.getText())) {
            this.m_lbImage.setText("");
            this.m_lbMessage.setText("");
            this.m_lbMessage.setBackground(this.getShell().getDisplay().getSystemColor(22));
        }
    }

    private void createCopyAction(final TableViewer tableViewer, final int columnCount) {
        MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(contextMenu);
        Action actCopy = new Action("Copy"){

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (sharedImages != null) {
                    return sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER");
                }
                return null;
            }

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                TableItem[] tableItems = tableViewer.getTable().getSelection();
                StringBuffer buffer = new StringBuffer();
                String EOL = System.getProperty("line.separator");
                int i = 0;
                while (i < tableItems.length) {
                    TableItem tableItem = tableItems[i];
                    int j = 0;
                    while (j < columnCount) {
                        buffer.append(tableItem.getText(j));
                        buffer.append("\t");
                        ++j;
                    }
                    buffer.append(EOL);
                    ++i;
                }
                Object[] data = new Object[]{buffer.toString()};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                clipboard.setContents(data, transferTypes);
            }
        };
        menuManager.add((IAction)actCopy);
        menuManager.addMenuListener(new IMenuListener((IAction)actCopy){
            private final /* synthetic */ IAction val$actCopy;
            {
                this.val$actCopy = val$actCopy;
            }

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = tableViewer.getSelection();
                this.val$actCopy.setEnabled(selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ boolean[] access$500(DescribeActivityDialog x0) {
        return x0.m_columnSorting;
    }

    private class IntegrationWorkspacesViewerSorter
    extends TableViewerLabelSorter {
        public IntegrationWorkspacesViewerSorter(int sortByCoulmnIndex, boolean ascending) {
            super(sortByCoulmnIndex, ascending);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.getCoulmnIndexToSort() == 1) {
                String isn1 = this.getColumnText(viewer, e1);
                String isn2 = this.getColumnText(viewer, e2);
                this.checkColumnText(isn1, isn2);
                if (isn1.equals("") && !isn2.equals("")) {
                    return this.getSortingDirection() ? 1 : -1;
                }
                if (!isn1.equals("") && isn2.equals("")) {
                    return this.getSortingDirection() ? -1 : 1;
                }
                int i1 = Integer.parseInt(isn1);
                int i2 = Integer.parseInt(isn2);
                return this.getSortingDirection() ? i1 - i2 : i2 - i1;
            }
            if (this.getCoulmnIndexToSort() == 2) {
                String date1 = this.getColumnText(viewer, e1);
                String date2 = this.getColumnText(viewer, e2);
                this.checkColumnText(date1, date2);
                if (date1.equals("") && !date2.equals("")) {
                    return this.getSortingDirection() ? 1 : -1;
                }
                if (!date1.equals("") && date2.equals("")) {
                    return this.getSortingDirection() ? -1 : 1;
                }
                DateFormat dateformat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
                dateformat.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    Date d1 = dateformat.parse(date1);
                    Date d2 = dateformat.parse(date2);
                    return this.getSortingDirection() ? d1.compareTo(d2) : -d1.compareTo(d2);
                }
                catch (ParseException x) {
                    DescribeActivityDialog.this.setErrorMessage("Sorting by integration date failed: " + x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                    return 0;
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class IntegrationWorkspacesLabelProvider
    implements ITableLabelProvider {
        private Map p_urlAndWs = new HashMap();
        private String p_creationWorkspaceUrl;

        private IntegrationWorkspacesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                try {
                    switch (columnIndex) {
                        case 0: {
                            return this.getWorkspace((String)element) == null ? (String)element : this.getWorkspace((String)element).getBrowsePath();
                        }
                        case 1: {
                            return this.getWorkspace((String)element) == null ? "" : "" + DescribeActivityDialog.this.m_activity.getIntegrationSequenceNumber(this.getWorkspace((String)element));
                        }
                        case 2: {
                            return this.getWorkspace((String)element) == null ? "" : Util.getGMTString(DescribeActivityDialog.this.m_activity.getIntegrationDate(this.getWorkspace((String)element)));
                        }
                    }
                }
                catch (VfsException x) {
                    DescribeActivityDialog.this.setErrorMessage(x.getMessage());
                    return "?";
                }
            }
            return "" + columnIndex;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof String) {
                String creationWsUrl = this.getCreationWorkspaceUrl();
                String wsIconName = this.getWorkspace((String)element) == null ? "WORKSPACE_DIS" : "WORKSPACE";
                boolean stretch = true;
                ObjectOffsets objectOffsets = new ObjectOffsets();
                objectOffsets.add(wsIconName, stretch ? 5 : 0);
                if (!element.equals(creationWsUrl)) {
                    objectOffsets.add("INTEGRATED", stretch ? 10 : 0);
                }
                return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, stretch);
            }
            return null;
        }

        private IVfsWorkspace getWorkspace(String url) {
            IVersionedFileSystemManager vfsManager;
            if (!this.p_urlAndWs.containsKey(url) && (vfsManager = DescribeActivityDialog.this.m_activity.getVersionedFileSystemManager()) != null) {
                this.p_urlAndWs.put(url, vfsManager.getWorkspaceByUrl(url));
            }
            return (IVfsWorkspace)this.p_urlAndWs.get(url);
        }

        private String getCreationWorkspaceUrl() {
            if (this.p_creationWorkspaceUrl == null && DescribeActivityDialog.this.m_activity != null) {
                try {
                    this.p_creationWorkspaceUrl = DescribeActivityDialog.this.m_activity.getCreationWorkspaceUrl();
                }
                catch (VfsException x) {
                    DescribeActivityDialog.this.setErrorMessage(x.getMessage());
                }
            }
            return this.p_creationWorkspaceUrl;
        }

        public void dispose() {
            this.p_urlAndWs.clear();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class IntegrationWorkspacesContentProvider
    implements IStructuredContentProvider {
        private IntegrationWorkspacesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IVfsActivity) {
                try {
                    return ((IVfsActivity)inputElement).getIntegrationWorkspacesUrls();
                }
                catch (VfsException x) {
                    DescribeActivityDialog.this.setErrorMessage(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ActivityElementsLabelProvider
    extends VfsVersionLabelProvider {
        private ActivityElementsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IVfsVersion) {
                return super.getText(element) + "   @ <BSN: " + ((IVfsVersion)element).getBranchSequenceNumber() + ">";
            }
            return super.getText(element);
        }
    }

    private class ActivityElementsContentProvider
    implements IStructuredContentProvider {
        private ActivityElementsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IVfsActivity) {
                    if (!((IVfsActivity)inputElement).isOpen()) {
                        return ((IVfsActivity)inputElement).getElementsFromClosedActivity();
                    }
                    return ((IVfsActivity)inputElement).getElementsFromOpenActivity();
                }
            }
            catch (VfsException x) {
                DescribeActivityDialog.this.setErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

