/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.util.ObjectImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.ObjectOffsets;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.Team;
import org.eclipse.ui.PlatformUI;

public class DAVDecorator
extends LabelProvider
implements ILabelDecorator,
IVfsFolderItemListener,
IVfsVersionListener,
IVfsActivityListener,
IConfigurationListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$DAVDecorator == null ? (class$com$tssap$dtr$client$eclipse$ui$DAVDecorator = DAVDecorator.class$("com.tssap.dtr.client.eclipse.ui.DAVDecorator")) : class$com$tssap$dtr$client$eclipse$ui$DAVDecorator));
    private static HashMap g_descriptorsByFileExtension = new HashMap();
    private List myManagers = new ArrayList(1);
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$DAVDecorator;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public DAVDecorator() {
        this.registerVFSListeners();
    }

    public void dispose() {
        this.unregisterVFSListeners();
        super.dispose();
    }

    public static final Image decorateFolderItem(Image baseImage, IVfsFolderItem folderItem) {
        return DAVDecorator.decorateFolderItem(baseImage, folderItem, false);
    }

    public static final Image decorateFolderItem(Image baseImage, IVfsFolderItem folderItem, boolean stretch) {
        if (folderItem == null) {
            return baseImage;
        }
        Object category = null;
        if (baseImage == null) {
            category = !(folderItem instanceof IVfsGenericFolder) && BluebirdPlugin.getDefault().getPreferenceManager().isUseApplicationFileIconsDecorator() ? DAVDecorator.getApplicationImageDescriptor(folderItem) : folderItem.getCategory();
        }
        Object locationState = DAVDecorator.getLocationState(folderItem);
        VfsFolderItemActivityState activityState = DAVDecorator.getActivityState(folderItem);
        Object foreignCheckout = DAVDecorator.getForeignCheckoutState(folderItem);
        Object projectFolder = null;
        return DAVDecorator.decorateFolderItem(baseImage, stretch, category, locationState, activityState, foreignCheckout, projectFolder);
    }

    public static final Image decorateFolderItem(Object baseImage, boolean stretch, Object category, Object locationState, Object activityState, Object foreignCheckout, Object projectFolder) {
        ObjectOffsets objectOffsets = new ObjectOffsets();
        Object baseObject = baseImage != null ? baseImage : ObjectImageDescriptor.getDescriptor(category);
        if (baseObject != null) {
            objectOffsets.add(baseObject, stretch ? 5 : 0);
        }
        if (locationState != null) {
            objectOffsets.add(locationState, stretch ? 10 : 0);
        }
        if (activityState != null) {
            objectOffsets.add(activityState, stretch ? 0 : 0);
        }
        if (foreignCheckout != null) {
            objectOffsets.add(foreignCheckout, stretch ? 0 : 0);
        }
        if (projectFolder != null) {
            objectOffsets.add(projectFolder, stretch ? 10 : 0);
        }
        return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(objectOffsets, stretch);
    }

    private static Object getForeignCheckoutState(IVfsFolderItem folderItem) {
        if (folderItem.asActivityRecordedFolderItem() != null) {
            try {
                if (folderItem.asActivityRecordedFolderItem().isExclusiveCheckedOutByOthers()) {
                    return "FOREIGN_CO_EX";
                }
                if (folderItem.asActivityRecordedFolderItem().isCheckedOutByOthers()) {
                    return "FOREIGN_CO";
                }
                if (folderItem.asActivityRecordedFolderItem().isExclusiveCheckedOut()) {
                    return "CHECKOUT_LOCK";
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return null;
    }

    public static Object getLocationStateFilteredByPreferences(Object locationState, Object activityState) {
        if (!BluebirdPlugin.getDefault().getPreferenceManager().isShowUpToDateIconDecorator() && locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST) {
            locationState = null;
        }
        if (!BluebirdPlugin.getDefault().getPreferenceManager().isShowLocalIconIfCheckedOutForCreateDecorator() && locationState == VfsFolderItemLocationState.LOCAL_ONLY && activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            locationState = null;
        }
        if (!BluebirdPlugin.getDefault().getPreferenceManager().isShowRemoteIconIfCheckedOutForDeleteDecorator() && activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            locationState = null;
        }
        return locationState;
    }

    private static Object getLocationState(IVfsFolderItem folderItem) {
        Object locationState = folderItem.getLocationState();
        if (folderItem.asActivityRecordedFolderItem() != null && folderItem.asActivityRecordedFolderItem().hasCheckinCollision()) {
            locationState = "COLLISION";
        }
        VfsFolderItemActivityState activityState = DAVDecorator.getActivityState(folderItem);
        IVfsContext.MountpointRelation relation = folderItem.getContext().getMountpointRelation(folderItem.getAbsoluteRemotePath());
        if (relation == IVfsContext.MountpointRelation.ABOVE_MOUNTPOINT) {
            locationState = "MOUNTPOINT_BELOW";
        } else if (folderItem instanceof IVfsGenericFolder && folderItem.getLocationState() == VfsFolderItemLocationState.MOUNTED && relation == IVfsContext.MountpointRelation.BELOW_MOUNTPOINT) {
            locationState = null;
        }
        locationState = DAVDecorator.getLocationStateFilteredByPreferences(locationState, activityState);
        return locationState;
    }

    private static VfsFolderItemActivityState getActivityState(IVfsFolderItem folderItem) {
        IVfsActivityRecordedFolderItem activityRecordedFolderItem;
        VfsFolderItemActivityState activityState;
        if (folderItem instanceof IVfsActivityRecordedFolderItem && (activityState = (activityRecordedFolderItem = (IVfsActivityRecordedFolderItem)folderItem).getActivityState()) != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            return activityState;
        }
        return null;
    }

    private static ObjectImageDescriptor getApplicationImageDescriptor(IVfsFolderItem folderItem) {
        String path = folderItem.getLocalFile() != null ? folderItem.getLocalPath() : folderItem.getName();
        int lastDot = path.lastIndexOf(46);
        String extension = lastDot >= 0 ? path.substring(lastDot) : "";
        ImageDescriptor imageDescriptor = (ImageDescriptor)g_descriptorsByFileExtension.get(extension);
        if (imageDescriptor == null) {
            final Program program = Program.findProgram((String)extension);
            imageDescriptor = program != null && program.getImageData() != null ? new ImageDescriptor(){

                public ImageData getImageData() {
                    return program.getImageData();
                }
            } : PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(path);
            if (imageDescriptor != null) {
                g_descriptorsByFileExtension.put(extension, imageDescriptor);
            } else {
                LOCATION.warningT("Unexpected location reached.");
            }
        }
        return ObjectImageDescriptor.getDescriptor(imageDescriptor, extension);
    }

    public Image decorateImage(Image image, Object element) {
        DAVTeamProvider davTeamProvider;
        IResource resource = this.getResource(element);
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject) {
            this.updateListeners((IProject)resource);
        }
        if ((davTeamProvider = BluebirdPlugin.getDAVTeamProvider(resource)) == null) {
            return null;
        }
        IVfsFolderItem folderItem = null;
        try {
            folderItem = davTeamProvider.getFolderItem(resource);
        }
        catch (Exception e) {
            return null;
        }
        return DAVDecorator.decorateFolderItem(image, folderItem);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    protected IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = DAVDecorator.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return null;
    }

    protected void notifyLabelChanged(final IResource resource) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                DAVDecorator.super.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DAVDecorator.this, (Object)resource));
            }
        });
    }

    public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        this.notifyChanges((IVfsFolderItem)folderItem);
    }

    public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
        try {
            IVfsFolderItem[] items = folder.getFolderItems();
            int i = 0;
            while (i < items.length) {
                this.notifyChanges(items[i]);
                ++i;
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
        this.notifyChanges(folderItem);
    }

    public void versionOnFolderItemChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
        this.notifyChanges((IVfsFolderItem)folderItem);
    }

    public void beforeCheckin(IVfsActivity activity) {
    }

    public void created(IVfsActivity activity) {
    }

    public void deleted(IVfsActivity activity, VfsActivityState oldState) {
    }

    public void itemsAddedOrRemoved(IVfsActivity activity) {
        try {
            if (activity.isOpen()) {
                IVfsActivityRecordedFolderItem[] items = activity.getElementsFromOpenActivity();
                int i = 0;
                while (i < items.length) {
                    this.notifyChanges((IVfsFolderItem)items[i]);
                    ++i;
                }
            }
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    public void stateChanged(IVfsActivity activity, VfsActivityState oldState) {
    }

    public void nameOrDescriptionChanged(IVfsActivity activity) {
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
    }

    public void onConfigurationChanged(IConfiguration configuration) {
        this.registerVFSListeners();
    }

    private void registerVFSListeners() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVersionedFileSystemManager manager;
                DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)projects[i].getFile(projects[i].getLocation()));
                IVersionedFileSystemManager iVersionedFileSystemManager = manager = provider != null ? provider.getVFSManager() : null;
                if (manager != null) {
                    manager.addActivityListener((IVfsActivityListener)this);
                    manager.addFolderItemListener((IVfsFolderItemListener)this);
                    manager.addVersionListener((IVfsVersionListener)this);
                    this.myManagers.add(manager);
                }
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            ++i;
        }
    }

    private void updateListeners(IProject project) {
        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (provider == null) {
            return;
        }
        try {
            IVersionedFileSystemManager manager = provider.getVFSManager();
            if (manager != null && !this.myManagers.contains(manager)) {
                manager.addActivityListener((IVfsActivityListener)this);
                manager.addFolderItemListener((IVfsFolderItemListener)this);
                manager.addVersionListener((IVfsVersionListener)this);
                this.myManagers.add(manager);
            }
        }
        catch (Exception e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void unregisterVFSListeners() {
        Iterator managers = this.myManagers.iterator();
        while (managers.hasNext()) {
            IVersionedFileSystemManager manager = (IVersionedFileSystemManager)managers.next();
            manager.removeActivityListener((IVfsActivityListener)this);
            manager.removeFolderItemListener((IVfsFolderItemListener)this);
            manager.removeVersionListener((IVfsVersionListener)this);
        }
    }

    private void notifyChanges(IVfsFolderItem folderItem) {
        if (folderItem.getLocalFile() == null) {
            return;
        }
        IResource resource = BluebirdPlugin.getResource(new File(folderItem.getLocalFile().getAbsolutePath()));
        if (resource == null) {
            return;
        }
        if (resource instanceof IFile) {
            if (!Team.isIgnoredHint((IResource)resource)) {
                this.notifyLabelChanged(resource);
            }
            return;
        }
        this.notifyLabelChanged(resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

