/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.ActivitySelectionContentProvider;
import com.tssap.dtr.client.eclipse.ui.ActivitySelectionLabelProvider;
import com.tssap.dtr.client.eclipse.ui.ActivityViewerInput;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.DynamicMenuManager;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ActivitySelectionViewer
extends Viewer {
    private static final String LABEL_DESCRIPTION = "Description of activity:";
    private static final String LABEL_WORKSPACE = "Available activities under workspace";
    private static final String LABEL_ACTIVITIES = "Available activities:";
    private static final String NOT_EXISTS_STR = "[ not available for the selected activity ]";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionViewer == null ? (class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionViewer = ActivitySelectionViewer.class$("com.tssap.dtr.client.eclipse.ui.ActivitySelectionViewer")) : class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionViewer));
    private Control fControl;
    private Composite fParent;
    private TreeViewer fActivityTreeViewer;
    private boolean fMultipleSelection;
    private Image fImage;
    private String fMessage;
    private ActivityViewerInput fInput;
    private Label fLbImage;
    private Label fLbMessage;
    private Label fInfoLabel;
    private Text fTxDesc;
    private ISelection fSelection;
    private boolean fValidSelection = false;
    private IAction fCreateActivityAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionViewer;

    public ActivitySelectionViewer(final Composite parent, boolean alloweMultipleSelection, Image image, String message) {
        this.fParent = parent;
        this.fMultipleSelection = alloweMultipleSelection;
        this.fImage = image;
        this.fMessage = message;
        this.fSelection = new StructuredSelection();
        this.fCreateActivityAction = new Action(){
            private ImageDescriptorSingletone fImage = new ImageDescriptorSingletone("actions/create_activity.gif");
            static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivity;

            public String getText() {
                return "Create Activity";
            }

            public boolean isEnabled() {
                return ActivitySelectionViewer.this.fInput != null && ((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fWorkspace != null;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.fImage.getImageDescriptor();
            }

            public void run() {
                DescribeActivityDialog dialogNew = new DescribeActivityDialog(parent.getShell(), ((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fWorkspace);
                if (dialogNew.open() == 0) {
                    IVfsActivity newActivity = dialogNew.getReturnedActivity();
                    if (((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fActivities != null) {
                        HashSet<IVfsActivity> activities = new HashSet<IVfsActivity>();
                        int i = 0;
                        while (i < ((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fActivities.length) {
                            activities.add(((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fActivities[i]);
                            ++i;
                        }
                        activities.add(newActivity);
                        ((ActivitySelectionViewer)ActivitySelectionViewer.this).fInput.fActivities = (IVfsActivity[])Util.getArrayFromIterator(activities.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivity = 1.class$("com.tssap.dtr.client.lib.vfs.IVfsActivity")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivity);
                        ActivitySelectionViewer.this.refresh();
                    } else {
                        ActivitySelectionViewer.this.refresh();
                    }
                    ActivitySelectionViewer.this.setSelection((ISelection)new StructuredSelection((Object)newActivity), true);
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.getControl();
    }

    private void createControl() {
        GridData gdata;
        Label label;
        Composite dialogArea = new Composite(this.fParent, 0);
        int colnum = 2;
        dialogArea.setLayout((Layout)new GridLayout(colnum, false));
        dialogArea.setLayoutData((Object)new GridData(1808));
        if (this.fMessage != null && this.fMessage.length() > 0) {
            int colspan = colnum;
            if (this.fImage != null) {
                label = new Label(dialogArea, 0);
                label.setImage(this.fImage);
                label.setLayoutData((Object)new GridData(2));
                --colspan;
            }
            label = new Label(dialogArea, 64);
            label.setText(this.fMessage);
            gdata = new GridData(1796);
            gdata.horizontalSpan = colspan;
            label.setLayoutData((Object)gdata);
            Label spacer = new Label(dialogArea, 0);
            gdata = new GridData();
            gdata.horizontalSpan = colnum;
            spacer.setLayoutData((Object)gdata);
        }
        this.fInfoLabel = new Label(dialogArea, 64);
        this.updateInfoLabelText();
        gdata = new GridData();
        gdata.horizontalSpan = colnum;
        this.fInfoLabel.setLayoutData((Object)gdata);
        int style = this.fMultipleSelection ? 2 : 4;
        this.fActivityTreeViewer = new TreeViewer(dialogArea, style | 0x800 | 0x100 | 0x200);
        ActivitySelectionContentProvider content = new ActivitySelectionContentProvider();
        this.fActivityTreeViewer.setContentProvider((IContentProvider)content);
        this.fActivityTreeViewer.setLabelProvider((IBaseLabelProvider)new ActivitySelectionLabelProvider());
        this.fActivityTreeViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        DynamicMenuManager menuManager = new DynamicMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(ActivitySelectionViewer.this.fCreateActivityAction);
            }
        });
        Menu menu = menuManager.createContextMenu(this.fActivityTreeViewer.getControl());
        this.fActivityTreeViewer.getTree().setMenu(menu);
        GC gc = new GC((Drawable)this.fParent);
        gc.setFont(this.fParent.getFont());
        int defaultMessageWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)300);
        gdata = new GridData(1808);
        gdata.horizontalSpan = colnum;
        gdata.widthHint = defaultMessageWidth;
        gdata.heightHint = defaultMessageWidth / 3;
        this.fActivityTreeViewer.getTree().setLayoutData((Object)gdata);
        label = new Label(dialogArea, 64);
        label.setText(LABEL_DESCRIPTION);
        gdata = new GridData();
        gdata.horizontalSpan = colnum;
        label.setLayoutData((Object)gdata);
        this.fTxDesc = new Text(dialogArea, 2632);
        gdata = new GridData(1808);
        gdata.horizontalSpan = colnum;
        gdata.heightHint = defaultMessageWidth / 5;
        this.fTxDesc.setLayoutData((Object)gdata);
        Composite messageArea = new Composite(this.fParent, 0);
        messageArea.setLayout((Layout)new GridLayout(2, false));
        messageArea.setLayoutData((Object)new GridData(768));
        this.fLbImage = new Label(messageArea, 0);
        this.fLbImage.setLayoutData((Object)new GridData(66));
        this.fLbImage.setImage(LayoutHelper.EMPTY_IMAGE.getImage());
        this.fLbMessage = new Label(messageArea, 64);
        this.fLbMessage.setLayoutData((Object)new GridData(768));
        this.fActivityTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActivitySelectionViewer.this.handleTreeSelection(event);
            }
        });
        this.setInput(this.fInput);
        this.fControl = dialogArea;
    }

    private void updateInfoLabelText() {
        if (this.fInput == null) {
            return;
        }
        if (this.fInput.fActivities == null) {
            try {
                if (this.fInput.fWorkspace == null) {
                    this.fInfoLabel.setText("Available activities under workspace:");
                } else {
                    this.fInfoLabel.setText("Available activities under workspace \"" + this.fInput.fWorkspace.getDisplayName() + "\":");
                }
                this.fInfoLabel.pack(true);
            }
            catch (VfsException x) {
                this.fInfoLabel.setText("Available activities under workspace \" ? \":");
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        } else {
            this.fInfoLabel.setText(LABEL_ACTIVITIES);
        }
    }

    private void setDescriptionText(IVfsActivity activity) {
        try {
            String description = activity.getDescription();
            if (description == null || description.trim().length() < 1) {
                description = NOT_EXISTS_STR;
            }
            this.fTxDesc.setText(description);
        }
        catch (VfsException x) {
            this.setErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    private void setErrorMessage(String message) {
        if (this.fLbMessage == null) {
            return;
        }
        this.fLbImage.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.fLbMessage.setText(message);
        this.fLbMessage.setForeground(this.fControl.getShell().getDisplay().getSystemColor(3));
    }

    private void handleTreeSelection(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.fValidSelection = false;
            return;
        }
        if (this.fLbMessage != null && !"".equals(this.fLbMessage.getText())) {
            this.fLbImage.setText("");
            this.fLbMessage.setText("");
        }
        if (!this.fMultipleSelection) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            IVfsActivity act = null;
            if (selection instanceof IVfsActivity) {
                act = (IVfsActivity)selection;
            } else if (selection instanceof IVfsActivityElement) {
                Set acts = this.getParentActivities((IVfsActivityElement)selection);
                if (acts.size() != 1) {
                    try {
                        this.setErrorMessage("Error: Could not find unambiguous parent activity for " + ((IVfsActivityRecordedFolderItem)selection).getBrowsePath());
                    }
                    catch (VfsException x) {
                        this.setErrorMessage(x.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    }
                    this.fValidSelection = false;
                } else {
                    act = (IVfsActivity)acts.toArray()[0];
                }
            }
            if (act != null) {
                this.fValidSelection = true;
                this.setDescriptionText(act);
                this.setActivitySelection(new IVfsActivity[]{act});
            } else {
                this.fValidSelection = false;
            }
        } else {
            HashSet<IVfsActivity> selectedActivities = new HashSet<IVfsActivity>();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (item instanceof IVfsActivity) {
                    selectedActivities.add((IVfsActivity)item);
                    continue;
                }
                if (!(item instanceof IVfsActivityElement)) continue;
                selectedActivities.addAll(this.getParentActivities((IVfsActivityElement)item));
            }
            if (selectedActivities.size() != 1) {
                this.fTxDesc.setText("");
            } else {
                this.setDescriptionText((IVfsActivity)selectedActivities.toArray()[0]);
            }
            this.fValidSelection = !selectedActivities.isEmpty();
            IVfsActivity[] acts = new IVfsActivity[selectedActivities.size()];
            int i = 0;
            Iterator iterator = selectedActivities.iterator();
            while (iterator.hasNext()) {
                acts[i++] = (IVfsActivity)iterator.next();
            }
            this.setActivitySelection(acts);
        }
    }

    private Set getParentActivities(IVfsActivityElement activityElement) {
        HashSet<Object> parentActivities = new HashSet<Object>();
        TreeItem[] selectedTreeItems = this.fActivityTreeViewer.getTree().getSelection();
        int i = 0;
        while (i < selectedTreeItems.length) {
            if (selectedTreeItems[i].getData().equals(activityElement)) {
                parentActivities.add(selectedTreeItems[i].getParentItem().getData());
            }
            ++i;
        }
        return parentActivities;
    }

    private void setActivitySelection(IVfsActivity[] activities) {
        this.fSelection = new StructuredSelection((Object[])activities);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.fSelection));
    }

    public Control getControl() {
        if (this.fControl == null) {
            this.createControl();
        }
        return this.fControl;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void refresh() {
        if (this.fInfoLabel != null) {
            this.updateInfoLabelText();
        }
        if (this.fActivityTreeViewer != null) {
            this.fActivityTreeViewer.refresh();
        }
    }

    public void setInput(Object input) {
        if (this.fActivityTreeViewer == null) {
            return;
        }
        if (input instanceof ActivityViewerInput) {
            Object data;
            TreeItem topItem;
            Tree tree;
            IVfsActivity currentActivity;
            this.fInput = (ActivityViewerInput)input;
            if (this.fInput.fActivities == null) {
                this.fActivityTreeViewer.setInput((Object)this.fInput.fWorkspace);
            } else {
                this.fActivityTreeViewer.setInput((Object)this.fInput.fActivities);
            }
            this.refresh();
            boolean somethingSelected = false;
            if (this.fInput.fWorkspace != null && (currentActivity = this.fInput.fWorkspace.getCurrentActivity()) != null) {
                this.setSelection((ISelection)new StructuredSelection((Object)currentActivity), true);
                somethingSelected = true;
            }
            if (!somethingSelected && this.fActivityTreeViewer != null && (tree = this.fActivityTreeViewer.getTree()) != null && tree.getItemCount() > 0 && (topItem = tree.getItems()[0]) != null && (data = topItem.getData()) != null) {
                this.setSelection((ISelection)new StructuredSelection(data), true);
            }
        } else {
            this.fActivityTreeViewer.setInput(input);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.fSelection = selection;
        this.fActivityTreeViewer.setSelection(selection, reveal);
    }

    public boolean isSelectionValid() {
        return this.fValidSelection;
    }

    public IAction getCreateActivityAction() {
        return this.fCreateActivityAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

