/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ActivitySelectionContentProvider
implements ITreeContentProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionContentProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionContentProvider = ActivitySelectionContentProvider.class$("com.tssap.dtr.client.eclipse.ui.ActivitySelectionContentProvider")) : class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionContentProvider));
    private IVfsActivity[] m_activities = null;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$ActivitySelectionContentProvider;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IVfsActivity) {
            IVfsActivity activity = (IVfsActivity)parentElement;
            try {
                if (!activity.isInvalid()) {
                    return activity.getElements();
                }
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IVfsActivity;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IVfsWorkspace) {
            return this.getEmptyAndOpenActivities((IVfsWorkspace)inputElement);
        }
        if (inputElement instanceof IVfsActivity[]) {
            return (IVfsActivity[])inputElement;
        }
        return new Object[0];
    }

    private IVfsActivity[] getEmptyAndOpenActivities(IVfsWorkspace workspace) {
        try {
            IVfsActivity[] emptyActs = workspace.getEmptyActivities();
            IVfsActivity[] openActs = workspace.getActivities(VfsActivityState.OPEN);
            if (emptyActs.length + openActs.length > 0) {
                this.m_activities = new IVfsActivity[emptyActs.length + openActs.length];
                if (emptyActs.length > 0) {
                    System.arraycopy(emptyActs, 0, this.m_activities, 0, emptyActs.length);
                    System.arraycopy(openActs, 0, this.m_activities, emptyActs.length, openActs.length);
                } else {
                    System.arraycopy(openActs, 0, this.m_activities, 0, openActs.length);
                }
                return this.m_activities;
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        return new IVfsActivity[0];
    }

    public IVfsActivity[] getAvailableActivities() {
        return this.m_activities;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

