/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.ObjectDescriptionDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.VfsException;
import org.eclipse.swt.widgets.Shell;

public class ActivityDescribeDialog
extends ObjectDescriptionDialog
implements ObjectDescriptionDialog.IInputCheck,
ObjectDescriptionDialog.IButtonPressedAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog = ActivityDescribeDialog.class$("com.tssap.dtr.client.eclipse.ui.DescribeActivityDialog")) : class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog));
    static final String defaultActionID = "SET_ACTIVITY_DESCRIPTION";
    private static final String TITLE_DESCRIBE = "Describe Activity";
    private static final String LABEL_NAME = "Display name:";
    private static final String LABEL_DESCRIPTION = "Description:";
    private static final String MSG_EMPTY_NAME = "Display name of activity cannot be empty!";
    private static final String MSG_SPECIFY = "Please specify the display name!";
    private IVfsActivity m_activity;
    private String m_originalDisplayName;
    private String m_originalDescription;
    private boolean m_checkDefaultName;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$DescribeActivityDialog;

    public boolean isCheckDefaultName() {
        return this.m_checkDefaultName;
    }

    public void setCheckDefaultName(boolean checkDefaultName) {
        this.m_checkDefaultName = checkDefaultName;
    }

    public IVfsActivity getActivity() {
        return this.m_activity;
    }

    public void setActivity(IVfsActivity activity) {
        this.m_activity = activity;
    }

    private String getOriginalDisplayName() {
        return this.m_originalDisplayName;
    }

    private String getOriginalDescription() {
        return this.m_originalDescription;
    }

    private void setOriginalDisplayName(String originalDisplayName) {
        this.m_originalDisplayName = originalDisplayName;
    }

    private void setOriginalDescription(String originalDescription) {
        this.m_originalDescription = originalDescription;
    }

    public ActivityDescribeDialog(Shell parentShell, String actionID, ObjectDescriptionDialog.IButtonPressedAction buttonPressedAction) {
        super(parentShell, actionID, TITLE_DESCRIBE, LABEL_NAME, LABEL_DESCRIPTION);
        this.setForceNameInput(true);
        this.setInputChecker(this);
        this.setCheckDefaultName(true);
        this.setButtonPressedAction(buttonPressedAction);
    }

    public ActivityDescribeDialog(Shell parentShell, IVfsActivity activity, boolean forceNameInput) {
        super(parentShell, defaultActionID, TITLE_DESCRIBE, LABEL_NAME, LABEL_DESCRIPTION);
        this.setForceNameInput(forceNameInput);
        this.setActivity(activity);
        try {
            this.setOriginalDisplayName(activity.getDisplayName());
            this.setName(this.getOriginalDisplayName());
            this.setOriginalDescription(activity.getDescription());
            this.setDescription(this.getOriginalDescription());
        }
        catch (VfsException e) {
            this.setErrorMessage(e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        this.setInputChecker(this);
        this.setButtonPressedAction(this);
    }

    public ActivityDescribeDialog(Shell parentShell, String actionID, IVfsActivity activity, boolean forceNameInput, boolean checkDefaultName, ObjectDescriptionDialog.IButtonPressedAction buttonPressedAction) {
        super(parentShell, actionID, TITLE_DESCRIBE, LABEL_NAME, LABEL_DESCRIPTION);
        this.setForceNameInput(forceNameInput);
        this.setActivity(activity);
        try {
            this.setOriginalDisplayName(activity.getDisplayName());
            this.setName(this.getOriginalDisplayName());
            this.setOriginalDescription(activity.getDescription());
            this.setDescription(this.getOriginalDescription());
        }
        catch (VfsException e) {
            this.setErrorMessage(e.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        if (forceNameInput || checkDefaultName) {
            this.setInputChecker(this);
        }
        this.setCheckDefaultName(checkDefaultName);
        this.setButtonPressedAction(buttonPressedAction);
    }

    public void checkName(String name) throws Exception {
        if (name.length() < 1) {
            throw new Exception(MSG_EMPTY_NAME);
        }
        if (this.isCheckDefaultName() && name.equalsIgnoreCase("[ not yet defined ]")) {
            throw new Exception(MSG_SPECIFY);
        }
    }

    public void okPressedAction(ObjectDescriptionDialog dialog) throws Exception {
        if (this.getActivity() != null) {
            String description;
            String name = this.getName();
            if (name != null && name.length() > 0 && !name.equals(this.getOriginalDisplayName())) {
                this.getActivity().setDisplayName(name);
            }
            if ((description = this.getDescription()) != null && !description.equals(this.getOriginalDescription())) {
                this.getActivity().setDescription(description);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

