/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.remoteeditor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class RemoteFileStorage
extends PlatformObject
implements IStorage {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$remoteeditor$RemoteFileStorage == null ? (class$com$tssap$dtr$client$eclipse$remoteeditor$RemoteFileStorage = RemoteFileStorage.class$("com.tssap.dtr.client.eclipse.remoteeditor.RemoteFileStorage")) : class$com$tssap$dtr$client$eclipse$remoteeditor$RemoteFileStorage));
    private IVfsFile fRemoteFile;
    private IVfsVersion fRemoteVersion;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$remoteeditor$RemoteFileStorage;

    public RemoteFileStorage(IVfsFile file) {
        this.fRemoteFile = file;
    }

    public RemoteFileStorage(IVfsVersion version) {
        this.fRemoteVersion = version;
    }

    public InputStream getContents() throws CoreException {
        try {
            if (this.fRemoteFile != null) {
                return this.fRemoteFile.getContent();
            }
            return this.getVersionInputStream(this.fRemoteVersion);
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        catch (FileNotFoundException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        return null;
    }

    private InputStream getVersionInputStream(IVfsVersion version) throws FileNotFoundException {
        File tmpFile = ExternalAction.createTmpFile(version, "tmpVersion");
        return new FileInputStream(tmpFile);
    }

    public IPath getFullPath() {
        if (this.fRemoteFile != null) {
            return new Path(this.fRemoteFile.getName());
        }
        return new Path(this.fRemoteVersion.getPath());
    }

    public String getName() {
        if (this.fRemoteFile != null) {
            return this.fRemoteFile.getName();
        }
        return this.fRemoteVersion.getDisplayName();
    }

    public boolean isReadOnly() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

