/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.preference.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.preference.ui.ExcludedElement;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExcludedResourcesLabelProvider
implements ITableLabelProvider {
    private Map imageTable;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$preference$ui$ExcludedResourcesLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$preference$ui$ExcludedResourcesLabelProvider = ExcludedResourcesLabelProvider.class$("com.tssap.dtr.client.eclipse.preference.ui.ExcludedResourcesLabelProvider")) : class$com$tssap$dtr$client$eclipse$preference$ui$ExcludedResourcesLabelProvider));
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$preference$ui$ExcludedResourcesLabelProvider;

    protected final IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ExcludedResourcesLabelProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
    }

    private Image getDTRResourceImage(File file) throws VfsException {
        IVfsContext context = Configuration.getConfiguration().getActiveClient().getContext();
        IVersionedFileSystemManager manager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(context);
        if (manager == null) {
            return null;
        }
        IVfsFolderItem folderItem = manager.getFolderItem(file.getAbsolutePath());
        if (folderItem == null) {
            return null;
        }
        return DAVDecorator.decorateFolderItem(null, folderItem);
    }

    private Image decorateImage(Image image, File file) {
        IResource eclipseResource = BluebirdPlugin.getResource(file);
        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(eclipseResource);
        IVfsFolderItem folderItem = null;
        if (provider != null) {
            folderItem = provider.getFolderItem(eclipseResource);
        }
        return DAVDecorator.decorateFolderItem(image, (IVfsFolderItem)(folderItem == null ? null : folderItem.asActivityRecordedFolderItem()));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            IWorkbenchAdapter adapter = null;
            IResource resource = null;
            if (element instanceof ExcludedElement) {
                Image image;
                ImageDescriptor descriptor;
                resource = ((ExcludedElement)element).fResource;
                adapter = this.getAdapter(resource);
                if (adapter == null) {
                    try {
                        return this.getDTRResourceImage(resource.getLocation().toFile());
                    }
                    catch (VfsException e) {
                        LOCATION.errorT("Catched: " + e.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                }
                if ((descriptor = adapter.getImageDescriptor((Object)resource)) == null) {
                    return null;
                }
                if (this.imageTable == null) {
                    this.imageTable = new Hashtable(40);
                }
                if ((image = (Image)this.imageTable.get(descriptor)) == null) {
                    image = descriptor.createImage();
                    this.imageTable.put(descriptor, image);
                }
                return this.decorateImage(image, resource.getLocation().toFile());
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ExcludedElement) {
            ExcludedElement excludedElement = (ExcludedElement)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return excludedElement.fResource.getLocation().toOSString();
                }
                case 2: {
                    return excludedElement.fType.toString();
                }
                case 3: {
                    return excludedElement.fDepth;
                }
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

