/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.preference.ui;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.preference.ui.ExcludedResourcesDialog;
import com.tssap.dtr.client.eclipse.preference.ui.Messages;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DtrPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fGeneralMonitorSwitch;
    private Button fAddMonitorSwitch;
    private Button fMoveMonitorSwitch;
    private Button fDeleteMonitorSwitch;
    private Button fEditMonitorSwitch;
    private Button fPromptSaveDirtyEditor;
    private Button fAutoSaveDirtyEditor;
    private Button fShowLocalIconIfCheckedOutForCreateDecoratorSwitch;
    private Button fShowRemoteIconIfCheckedOutForDeleteDecoratorSwitch;
    private Button fShowUpToDateIconDecoratorSwitch;
    private Button fUseApplicationFileIconsDecoratorSwitch;
    private Button fSingleActivityTrace;
    DtrPreferenceManager fManager = BluebirdPlugin.getDefault().getPreferenceManager();

    protected Control createContents(Composite parent) {
        Composite out = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        out.setLayout((Layout)gridLayout);
        Group monitorGroup = this.createGroup(out, Messages.getString("DtrPreferencePage.Workspace_Monitor_group.label"), 2);
        this.fGeneralMonitorSwitch = this.createCheckBox((Composite)monitorGroup, Messages.getString("DtrPreferencePage.Workspace_Monitor_GeneralSwitch.label"), 2, 2);
        this.fAddMonitorSwitch = this.createCheckBox((Composite)monitorGroup, Messages.getString("DtrPreferencePage.Workspace_Monitor_AddSwitch.label"), 20, 2);
        this.fEditMonitorSwitch = this.createCheckBox((Composite)monitorGroup, Messages.getString("DtrPreferencePage.Workspace_Monitor_EditSwitch.label"), 20, 2);
        this.fMoveMonitorSwitch = this.createCheckBox((Composite)monitorGroup, Messages.getString("DtrPreferencePage.Workspace_Monitor_MoveSwitch.label"), 20, 2);
        this.fDeleteMonitorSwitch = this.createCheckBox((Composite)monitorGroup, Messages.getString("DtrPreferencePage.Workspace_Monitor_DeleteSwitch.label"), 20, 1);
        Button showExcluded = new Button((Composite)monitorGroup, 8);
        showExcluded.setLayoutData((Object)new GridData(136));
        showExcluded.setText(Messages.getString("DtrPreferencePage.ShowExcludedFiles.label"));
        showExcluded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludedResourcesDialog dialog = new ExcludedResourcesDialog(DtrPreferencePage.this.getShell(), Messages.getString("DtrPreferencePage.ShowExcludedFiles.title"), null);
                dialog.open();
            }
        });
        this.fGeneralMonitorSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DtrPreferencePage.this.updateSubOptinsState();
            }
        });
        this.fGeneralMonitorSwitch.setSelection(this.fManager.isWorkspaceMonitorGeneral());
        this.fAddMonitorSwitch.setSelection(this.fManager.isWorkspaceMonitorAdd());
        this.fDeleteMonitorSwitch.setSelection(this.fManager.isWorkspaceMonitorDelete());
        this.fMoveMonitorSwitch.setSelection(this.fManager.isWorkspaceMonitorMove());
        this.fEditMonitorSwitch.setSelection(this.fManager.isWorkspaceMonitorEdit());
        this.updateSubOptinsState();
        Group dirtyEditorGroup = this.createGroup(out, "Save dirty editors before check-in", 2);
        this.fPromptSaveDirtyEditor = this.createRadioButton((Composite)dirtyEditorGroup, "Prompt", 1, 1);
        this.fAutoSaveDirtyEditor = this.createRadioButton((Composite)dirtyEditorGroup, "Auto-save", 1, 1);
        boolean autoSave = this.getDtrPreferenceStore().getBoolean("autoSave_beforeCheckin");
        this.fPromptSaveDirtyEditor.setSelection(!autoSave);
        this.fAutoSaveDirtyEditor.setSelection(autoSave);
        Group decoratorGroup = this.createGroup(out, Messages.getString("DtrPreferencePage.Decorator_group.label"), 1);
        this.fShowLocalIconIfCheckedOutForCreateDecoratorSwitch = this.createCheckBox((Composite)decoratorGroup, Messages.getString("DtrPreferencePage.Decorators.Show_local_icon_if_checked_out.label"), 1, 1);
        this.fShowLocalIconIfCheckedOutForCreateDecoratorSwitch.setSelection(this.fManager.isShowLocalIconIfCheckedOutForCreateDecorator());
        this.fShowRemoteIconIfCheckedOutForDeleteDecoratorSwitch = this.createCheckBox((Composite)decoratorGroup, Messages.getString("DtrPreferencePage.Decorators.Show_remote_icon_if_checked_out.label"), 1, 1);
        this.fShowRemoteIconIfCheckedOutForDeleteDecoratorSwitch.setSelection(this.fManager.isShowRemoteIconIfCheckedOutForDeleteDecorator());
        this.fShowUpToDateIconDecoratorSwitch = this.createCheckBox((Composite)decoratorGroup, Messages.getString("DtrPreferencePage.Decorators.Show_uptodate_icon.label"), 1, 1);
        this.fShowUpToDateIconDecoratorSwitch.setSelection(this.fManager.isShowUpToDateIconDecorator());
        this.fUseApplicationFileIconsDecoratorSwitch = this.createCheckBox((Composite)decoratorGroup, Messages.getString("DtrPreferencePage.Decorators.Use_application_file_icons.label"), 1, 1);
        this.fUseApplicationFileIconsDecoratorSwitch.setSelection(this.fManager.isUseApplicationFileIconsDecorator());
        Group grSingleActivityTrace = this.createGroup(out, "Session Trace", 1);
        this.createLabel((Composite)grSingleActivityTrace, "If this preference is enabled DTR servers will write trace messages for each\nrequest sent by this workbench.");
        this.fSingleActivityTrace = this.createCheckBox((Composite)grSingleActivityTrace, "Enable Session Trace on DTR servers", 1, 1);
        this.fSingleActivityTrace.setSelection(this.getDtrPreferenceStore().getBoolean("dtrSingleActivityTraceSwitchedOn"));
        Composite noteArea = new Composite((Composite)grSingleActivityTrace, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        noteArea.setLayout((Layout)gridLayout);
        noteArea.setLayoutData((Object)new GridData(768));
        Label lbNote = this.createLabel(noteArea, "Note:");
        lbNote.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        this.createLabel(noteArea, "This setting will be disabled when the workbench closes.");
        return out;
    }

    private void updateSubOptinsState() {
        boolean enabled = this.fGeneralMonitorSwitch.getSelection();
        this.fAddMonitorSwitch.setEnabled(enabled);
        this.fDeleteMonitorSwitch.setEnabled(enabled);
        this.fEditMonitorSwitch.setEnabled(enabled);
        this.fMoveMonitorSwitch.setEnabled(enabled);
    }

    private Button createCheckBox(Composite parent, String text, int indent, int horizontalSpan) {
        Button out = new Button(parent, 32);
        out.setText(text);
        GridData layoutData = new GridData(544);
        layoutData.horizontalIndent = indent;
        layoutData.horizontalSpan = horizontalSpan;
        out.setLayoutData((Object)layoutData);
        return out;
    }

    private Button createRadioButton(Composite parent, String text, int indent, int horizontalSpan) {
        Button out = new Button(parent, 16);
        out.setText(text);
        GridData layoutData = new GridData(544);
        layoutData.horizontalIndent = indent;
        layoutData.horizontalSpan = horizontalSpan;
        out.setLayoutData((Object)layoutData);
        return out;
    }

    Button createButton(Composite parent, final Shell shell, String text, final Text textField) {
        Button out = new Button(parent, 8);
        out.setText(text);
        GridData gridData = new GridData(128);
        gridData.widthHint = LayoutHelper.getButtonWidthHint(out);
        out.setLayoutData((Object)gridData);
        out.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog d = new FileDialog(shell);
                d.setText(Messages.getString("DtrPreferencePage.Choose_file_dialog.label"));
                String file = d.open();
                if (file != null) {
                    textField.setText(file);
                }
            }
        });
        return out;
    }

    Text createTextField(Composite parent, String text, int span) {
        Text out = new Text(parent, 2052);
        out.setText(text);
        GridData data = new GridData(768);
        data.widthHint = 250;
        if (span > 0) {
            data.horizontalSpan = span;
        }
        out.setLayoutData((Object)data);
        return out;
    }

    Group createGroup(Composite parent, String text, int columns) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(800));
        return group;
    }

    Label createLabel(Composite parent, String text) {
        Label l = new Label(parent, 0);
        l.setText(text);
        l.setLayoutData((Object)new GridData(34));
        return l;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        this.fManager.setWorkspaceMonitorAdd(this.fAddMonitorSwitch.getSelection());
        this.fManager.setWorkspaceMonitorDelete(this.fDeleteMonitorSwitch.getSelection());
        this.fManager.setWorkspaceMonitorGeneral(this.fGeneralMonitorSwitch.getSelection());
        this.fManager.setWorkspaceMonitorMove(this.fMoveMonitorSwitch.getSelection());
        this.fManager.setWorkspaceMonitorEdit(this.fEditMonitorSwitch.getSelection());
        this.getDtrPreferenceStore().setValue("autoSave_beforeCheckin", this.fAutoSaveDirtyEditor.getSelection());
        this.fManager.setShowLocalIconIfCheckedOutForCreateDecorator(this.fShowLocalIconIfCheckedOutForCreateDecoratorSwitch.getSelection());
        this.fManager.setShowRemoteIconIfCheckedOutForDeleteDecorator(this.fShowRemoteIconIfCheckedOutForDeleteDecoratorSwitch.getSelection());
        this.fManager.setShowUpToDateIconDecorator(this.fShowUpToDateIconDecoratorSwitch.getSelection());
        this.fManager.setUseApplicationFileIconsDecorator(this.fUseApplicationFileIconsDecoratorSwitch.getSelection());
        boolean singleActivityTraceSwitchedOn = this.fSingleActivityTrace.getSelection();
        this.getDtrPreferenceStore().setValue("dtrSingleActivityTraceSwitchedOn", singleActivityTraceSwitchedOn);
        Configuration.getConfiguration().setSingleActivityTrace(singleActivityTraceSwitchedOn);
        return true;
    }

    IPreferenceStore getDtrPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }
}

