/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.preference.ui;

import com.tssap.dtr.client.eclipse.preference.ui.DtrPreferencePage;
import com.tssap.dtr.client.eclipse.preference.ui.Messages;
import com.tssap.dtr.client.eclipse.ui.conflict.ParameterHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiffMergePreferencePage
extends DtrPreferencePage {
    private Group myMergeGroup;
    private Group myDiffGroup;
    private Button myInternalDiffSwitch;
    private Button myInternalMergeSwitch;
    private Text fExtDiffCmd;
    private String fExtDiffParam;
    private Text fExtMergeCmd;
    private String fExtMergeParam;
    private String fExtMergeParamType;
    private Label myInfoLabel;

    protected Control createContents(Composite parent) {
        this.fExtMergeParamType = this.fManager.getExternalMergeParametersType();
        this.fExtMergeParam = this.fManager.getExternalMergeParameters();
        Composite out = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        out.setLayout((Layout)gridLayout);
        this.myDiffGroup = this.createGroup(out, Messages.getString("DtrPreferencePage.ExtDiffCMDGroup.label"), 3);
        this.myInternalDiffSwitch = new Button((Composite)this.myDiffGroup, 32);
        this.myInternalDiffSwitch.setText(Messages.getString("DtrPreferencePage.Use_external_Diff.label"));
        this.myInternalDiffSwitch.setSelection(this.fManager.isUseExternalDiff());
        GridData layoutData = new GridData(32);
        layoutData.horizontalSpan = 3;
        this.myInternalDiffSwitch.setLayoutData((Object)layoutData);
        this.createLabel((Composite)this.myDiffGroup, Messages.getString("DtrPreferencePage.ExtDiffCMD.command"));
        this.fExtDiffCmd = this.createTextField((Composite)this.myDiffGroup, this.fManager.getExternalDiffCommand(), 0);
        this.createButton((Composite)this.myDiffGroup, this.getShell(), Messages.getString("DtrPreferencePage.ExtDiffCMD.browse"), this.fExtDiffCmd);
        this.myMergeGroup = this.createGroup(out, Messages.getString("DtrPreferencePage.ExtMergeCMDGroup.label"), 3);
        this.myInternalMergeSwitch = new Button((Composite)this.myMergeGroup, 32);
        this.myInternalMergeSwitch.setText(Messages.getString("DtrPreferencePage.Use_external_Merge.label"));
        this.myInternalMergeSwitch.setSelection(this.fManager.isUseExternalMerge());
        layoutData = new GridData(32);
        layoutData.horizontalSpan = 3;
        this.myInternalMergeSwitch.setLayoutData((Object)layoutData);
        this.createLabel((Composite)this.myMergeGroup, Messages.getString("DtrPreferencePage.ExtMergeCMD.command"));
        this.fExtMergeCmd = this.createTextField((Composite)this.myMergeGroup, this.fManager.getExternalMergeCommand(), 0);
        this.createButton((Composite)this.myMergeGroup, this.getShell(), Messages.getString("DtrPreferencePage.ExtMergeCMD.browse"), this.fExtMergeCmd);
        Composite advanced = new Composite((Composite)this.myMergeGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        advanced.setLayout((Layout)layout);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        advanced.setLayoutData((Object)layoutData);
        this.myInfoLabel = new Label(advanced, 0);
        this.myInfoLabel.setLayoutData((Object)new GridData(32));
        this.myInfoLabel.setEnabled(false);
        this.fillInfoLablel();
        Button adv = new Button(advanced, 8);
        layoutData = new GridData(640);
        adv.setLayoutData((Object)layoutData);
        adv.setText(Messages.getString("DtrPreferencePage.Advanced_button.label"));
        adv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffMergePreferencePage.this.openAdvancedSettingsDialog();
            }
        });
        this.myInternalDiffSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffMergePreferencePage.this.changeGroupChildrenState((Composite)DiffMergePreferencePage.this.myDiffGroup, DiffMergePreferencePage.this.myInternalDiffSwitch.getSelection());
            }
        });
        this.myInternalMergeSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffMergePreferencePage.this.changeGroupChildrenState((Composite)DiffMergePreferencePage.this.myMergeGroup, DiffMergePreferencePage.this.myInternalMergeSwitch.getSelection());
            }
        });
        this.changeGroupChildrenState((Composite)this.myDiffGroup, this.myInternalDiffSwitch.getSelection());
        this.changeGroupChildrenState((Composite)this.myMergeGroup, this.myInternalMergeSwitch.getSelection());
        return out;
    }

    public boolean performOk() {
        this.fManager.setExternalDiffCommand(this.fExtDiffCmd.getText());
        if (this.fExtDiffParam != null) {
            this.fManager.setExternalDiffParameters(this.fExtDiffParam);
        }
        this.fManager.setExternalMergeCommand(this.fExtMergeCmd.getText());
        if (this.fExtMergeParam != null) {
            this.fManager.setExternalMergeParameters(this.fExtMergeParam);
        }
        if (this.fExtMergeParamType != null) {
            this.fManager.setExternalMergeParametersType(this.fExtMergeParamType);
        }
        this.fManager.setUseExternalDiff(this.myInternalDiffSwitch.getSelection());
        this.fManager.setUseExternalMerge(this.myInternalMergeSwitch.getSelection());
        return true;
    }

    private void changeGroupChildrenState(Composite group, boolean state) {
        Control[] childrens = group.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] != this.myInternalDiffSwitch && childrens[i] != this.myInternalMergeSwitch) {
                childrens[i].setEnabled(state);
            }
            if (childrens[i] instanceof Composite && ((Composite)childrens[i]).getChildren().length > 0) {
                this.changeGroupChildrenState((Composite)childrens[i], state);
            }
            ++i;
        }
    }

    protected void openAdvancedSettingsDialog() {
        AdvancedSettingsDialog dialog = new AdvancedSettingsDialog(this.getShell());
        if (dialog.open() == 0) {
            this.fExtMergeCmd.setText(dialog.getExtCommand());
            this.fExtMergeParam = dialog.getParamTemplate();
            this.fExtMergeParamType = dialog.getParamType();
        }
        this.fillInfoLablel();
    }

    private void fillInfoLablel() {
        if (this.fExtMergeParam.equals("")) {
            this.myInfoLabel.setText(Messages.getString("DtrPreferencePage.Default_parameters.message"));
        } else {
            this.myInfoLabel.setText(Messages.getString("DtrPreferencePage.Parameters_configured_manually.message"));
        }
        this.myInfoLabel.getParent().layout(true);
    }

    private class AdvancedSettingsDialog
    extends Dialog {
        private Text myParam;
        private Text myCommand;
        private String myParamTemplate;
        private String myParamType;
        private String myExtCommand;

        public AdvancedSettingsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.getString("DtrPreferencePage.Advanced.external_Merge_settings.title"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = new Composite((Composite)super.createDialogArea(parent), 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            parentComposite.setLayout((Layout)layout);
            DiffMergePreferencePage.this.createLabel(parentComposite, Messages.getString("DtrPreferencePage.ExtMergeCMD.command"));
            this.myCommand = DiffMergePreferencePage.this.createTextField(parentComposite, DiffMergePreferencePage.this.fExtMergeCmd.getText(), 0);
            DiffMergePreferencePage.this.createButton(parentComposite, this.getShell(), Messages.getString("DtrPreferencePage.ExtMergeCMD.browse"), this.myCommand);
            DiffMergePreferencePage.this.createLabel(parentComposite, Messages.getString("DtrPreferencePage.ExtMergeCMD.param"));
            this.myParam = DiffMergePreferencePage.this.createTextField(parentComposite, DiffMergePreferencePage.this.fExtMergeParam, 2);
            this.myParam.setEnabled(ParameterHandler.isParameterAvailable(DiffMergePreferencePage.this.fExtMergeParamType));
            Group help = DiffMergePreferencePage.this.createGroup(parentComposite, Messages.getString("DtrPreferencePage.Advanced.Parameter_help.label"), 1);
            DiffMergePreferencePage.this.createLabel((Composite)help, Messages.getString("DtrPreferencePage.Advanced.Parameter_help.first"));
            DiffMergePreferencePage.this.createLabel((Composite)help, Messages.getString("DtrPreferencePage.Advanced.Parameter_help.second"));
            DiffMergePreferencePage.this.createLabel((Composite)help, Messages.getString("DtrPreferencePage.Advanced.Parameter_help.third"));
            DiffMergePreferencePage.this.createLabel((Composite)help, Messages.getString("DtrPreferencePage.Advanced.Parameter_help.fourth"));
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = 3;
            help.setLayoutData((Object)layoutData);
            return parentComposite;
        }

        protected void okPressed() {
            this.myParamTemplate = this.myParam.getText();
            this.myExtCommand = this.myCommand.getText();
            super.okPressed();
        }

        public String getExtCommand() {
            if (this.myExtCommand == null) {
                return "";
            }
            return this.myExtCommand;
        }

        public String getParamType() {
            if (this.myParamType == null) {
                return "";
            }
            return this.myParamType;
        }

        public String getParamTemplate() {
            return this.myParamTemplate;
        }
    }
}

