/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.preference.ui;

import com.tssap.dtr.client.eclipse.preference.ui.DtrPreferencePage;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ConnectionSettingPreferencePage
extends DtrPreferencePage
implements IConfigurationListener {
    private static final int FIELD_WIDTH = 50;
    private static final String[] INTEGER_FIELD_LABELS = new String[]{"Read Timeout", "Connect Timeout", "Ping Timeout", "Ping Repetitions"};
    private static final int[] INTEGER_FIELD_MIN_VALUES = new int[]{1, 1, 1, 0};
    private Control m_clientSelector;
    private Composite m_editArea;
    private Text m_txUrl;
    private Text[] m_integerFields;
    private Button m_cxCompress;
    private IRepositoryServer m_server;
    private Map m_mapTOsAndRepeat = new HashMap();
    private Map m_mapCompress = new HashMap();
    private boolean m_currentSettingChanged;
    private Set m_setChangedServers = new HashSet();

    protected Control createContents(Composite parent) {
        Composite out = new Composite(parent, 0);
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            out.setLayout((Layout)gridLayout);
            out.setLayoutData((Object)new GridData(1808));
            Composite selectArea = new Composite(out, 0);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            selectArea.setLayout((Layout)gridLayout);
            selectArea.setLayoutData((Object)new GridData(128));
            new Label(selectArea, 0).setText("DTR Client:");
            this.m_clientSelector = ClientConfigurationUtil.createClientSelector(selectArea);
            this.m_clientSelector.setLayoutData((Object)new GridData());
            new Label(out, 258).setLayoutData((Object)new GridData(768));
            this.m_integerFields = new Text[4];
            this.m_editArea = new Composite(out, 0);
            this.m_editArea.setLayout((Layout)new GridLayout(2, false));
            this.m_editArea.setLayoutData((Object)new GridData(768));
            new Label(this.m_editArea, 0).setText("Repository Server:");
            this.m_txUrl = new Text(this.m_editArea, 72);
            this.m_txUrl.setLayoutData((Object)new GridData(768));
            new Label(this.m_editArea, 0).setText(INTEGER_FIELD_LABELS[0] + " (in s):");
            this.m_integerFields[0] = new Text(this.m_editArea, 133120);
            GridData gridData = new GridData();
            gridData.widthHint = 50;
            this.m_integerFields[0].setLayoutData((Object)gridData);
            new Label(this.m_editArea, 0).setText(INTEGER_FIELD_LABELS[1] + " (in s):");
            this.m_integerFields[1] = new Text(this.m_editArea, 133120);
            gridData = new GridData();
            gridData.widthHint = 50;
            this.m_integerFields[1].setLayoutData((Object)gridData);
            new Label(this.m_editArea, 0).setText(INTEGER_FIELD_LABELS[2] + " (in s):");
            this.m_integerFields[2] = new Text(this.m_editArea, 133120);
            gridData = new GridData();
            gridData.widthHint = 50;
            this.m_integerFields[2].setLayoutData((Object)gridData);
            new Label(this.m_editArea, 0).setText(INTEGER_FIELD_LABELS[3] + ":");
            this.m_integerFields[3] = new Text(this.m_editArea, 133120);
            gridData = new GridData();
            gridData.widthHint = 50;
            this.m_integerFields[3].setLayoutData((Object)gridData);
            this.m_cxCompress = new Button(this.m_editArea, 32);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.m_cxCompress.setLayoutData((Object)gridData);
            this.m_cxCompress.setText("Enable Compression");
            this.m_server = this.getCorrespondingRepositoryServer(activeClient);
            if (this.m_server != null) {
                this.fillEditArea(this.m_server);
            } else {
                this.m_editArea.setVisible(false);
                this.setErrorMessage("Could not determine repository server of DTR client \"" + activeClient.getName() + "\".");
            }
            int i = 0;
            while (i < this.m_integerFields.length) {
                this.addIntegerFieldModifyListener(this.m_integerFields[i], INTEGER_FIELD_MIN_VALUES[i], INTEGER_FIELD_LABELS[i]);
                ++i;
            }
            this.m_cxCompress.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionSettingPreferencePage.this.m_currentSettingChanged = true;
                }
            });
            Composite noteArea = new Composite(out, 0);
            noteArea.setLayout((Layout)new GridLayout(2, false));
            noteArea.setLayoutData((Object)new GridData(768));
            Label lbNote = new Label(noteArea, 0);
            lbNote.setFont(JFaceResources.getBannerFont());
            lbNote.setText("Note:");
            lbNote.setLayoutData((Object)new GridData(2));
            Label lbText = new Label(noteArea, 64);
            lbText.setText("Changes on the settings are only applied on workbench restart.");
            lbText.setLayoutData((Object)new GridData(512));
        } else {
            this.setMessage("No DTR client configured.");
        }
        return out;
    }

    public boolean performOk() {
        this.cacheChangedSettings();
        Iterator iter = this.m_mapTOsAndRepeat.keySet().iterator();
        while (iter.hasNext()) {
            IRepositoryServer server = (IRepositoryServer)iter.next();
            int[] tosAndRepeat = (int[])this.m_mapTOsAndRepeat.get(server);
            Boolean compressed = (Boolean)this.m_mapCompress.get(server);
            server.setReadTimeout(tosAndRepeat[0]);
            server.setConnectTimeout(tosAndRepeat[1]);
            server.setTransientPingTimeout(tosAndRepeat[2]);
            server.setTransientPingRepetitions(tosAndRepeat[3]);
            server.setCompression(compressed.booleanValue());
            String serverUrl = server.getUrl();
            this.getDtrPreferenceStore().setValue(this.fManager.getPreferenceKeyOfPingTimeout(serverUrl), tosAndRepeat[2]);
            this.getDtrPreferenceStore().setValue(this.fManager.getPreferenceKeyOfPingRepetitions(serverUrl), tosAndRepeat[3]);
        }
        try {
            Configuration.getConfiguration().saveAll();
        }
        catch (IOException x) {
            this.setErrorMessage("Persist connection settings failed: " + x.getMessage());
            return false;
        }
        this.m_mapTOsAndRepeat.clear();
        this.m_mapCompress.clear();
        this.m_setChangedServers.clear();
        return true;
    }

    protected void performDefaults() {
        if (this.m_server != null) {
            this.m_integerFields[0].setText("" + this.getSeconds(this.m_server.getDefaultReadTimeout()));
            this.m_integerFields[1].setText("" + this.getSeconds(this.m_server.getDefaultConnectTimeout()));
            this.m_integerFields[2].setText("" + this.getSeconds(this.m_server.getDefaultTransientPingTimeout()));
            this.m_integerFields[3].setText("" + this.m_server.getDefaultTransientPingRepetitions());
            this.m_cxCompress.setSelection(this.m_server.getDefaultCompressionSetting());
        }
    }

    public void init(IWorkbench workbench) {
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
    }

    public void dispose() {
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        this.m_mapTOsAndRepeat.clear();
        this.m_mapCompress.clear();
        this.m_setChangedServers.clear();
        super.dispose();
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        this.cacheChangedSettings();
        this.m_server = this.getCorrespondingRepositoryServer(newClient);
        if (this.m_server != null) {
            if (this.getErrorMessage() != null) {
                this.m_editArea.setVisible(true);
                this.setErrorMessage(null);
            }
            this.fillEditArea(this.m_server);
            this.m_currentSettingChanged = this.m_setChangedServers.contains(this.m_server);
        } else {
            this.m_currentSettingChanged = false;
            this.m_editArea.setVisible(false);
            this.setErrorMessage("Could not determine repository server of DTR client \"" + newClient.getName() + "\".");
        }
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    private void addIntegerFieldModifyListener(final Text text, final int minimum, final String label) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newValue = ConnectionSettingPreferencePage.this.getIntegerFieldValue(text, minimum, label);
                if (ConnectionSettingPreferencePage.this.isValid() && newValue == -1) {
                    ConnectionSettingPreferencePage.this.setValid(false);
                    ConnectionSettingPreferencePage.this.getContainer().updateButtons();
                }
                if (!ConnectionSettingPreferencePage.this.isValid() && newValue != -1) {
                    int i = 0;
                    while (i < ConnectionSettingPreferencePage.this.m_integerFields.length) {
                        int value = ConnectionSettingPreferencePage.this.getIntegerFieldValue(ConnectionSettingPreferencePage.this.m_integerFields[i], INTEGER_FIELD_MIN_VALUES[i], INTEGER_FIELD_LABELS[i]);
                        if (value == -1) {
                            ConnectionSettingPreferencePage.this.m_integerFields[i].setFocus();
                            ConnectionSettingPreferencePage.this.m_integerFields[i].selectAll();
                            return;
                        }
                        ++i;
                    }
                    ConnectionSettingPreferencePage.this.setValid(true);
                    ConnectionSettingPreferencePage.this.setErrorMessage(null);
                    ConnectionSettingPreferencePage.this.getContainer().updateButtons();
                }
                ConnectionSettingPreferencePage.this.m_clientSelector.setEnabled(ConnectionSettingPreferencePage.this.isValid());
                ConnectionSettingPreferencePage.this.m_currentSettingChanged = true;
            }
        });
    }

    private int getIntegerFieldValue(Text text, int minimum, String fieldLabel) {
        try {
            int value = Integer.parseInt(text.getText());
            if (value < minimum) {
                this.setErrorMessage("The minimal value for \"" + fieldLabel + "\" is " + minimum + ".");
                return -1;
            }
            return value;
        }
        catch (NumberFormatException x) {
            this.setErrorMessage("Enter a integer value for \"" + fieldLabel + "\".");
            return -1;
        }
    }

    private IRepositoryServer getCorrespondingRepositoryServer(IClient client) {
        Object obj;
        Iterator iter;
        if (client != null && (iter = client.getLogicalSystem().repositoryServers()) != null && (obj = iter.next()) instanceof IRepositoryServer) {
            return (IRepositoryServer)obj;
        }
        return null;
    }

    private int getMilliseconds(int seconds) {
        return seconds * 1000;
    }

    private int getSeconds(int milliseconds) {
        return milliseconds / 1000;
    }

    private void fillEditArea(IRepositoryServer server) {
        boolean compressed;
        int pingRepeat;
        int pingTO;
        int connectTO;
        int readTO;
        String serverUrl = server.getUrl();
        if (this.m_mapTOsAndRepeat.containsKey(server)) {
            int[] tosAndRepeat = (int[])this.m_mapTOsAndRepeat.get(server);
            readTO = tosAndRepeat[0];
            connectTO = tosAndRepeat[1];
            pingTO = tosAndRepeat[2];
            pingRepeat = tosAndRepeat[3];
            compressed = (Boolean)this.m_mapCompress.get(server);
        } else {
            String keyPingTO = this.fManager.getPreferenceKeyOfPingTimeout(serverUrl);
            String keyPingRepeat = this.fManager.getPreferenceKeyOfPingRepetitions(serverUrl);
            IPreferenceStore dtrPreferenceStore = this.getDtrPreferenceStore();
            readTO = server.getReadTimeout();
            connectTO = server.getConnectTimeout();
            pingTO = dtrPreferenceStore.contains(keyPingTO) ? dtrPreferenceStore.getInt(keyPingTO) : server.getTransientPingTimeout();
            pingRepeat = dtrPreferenceStore.contains(keyPingRepeat) ? dtrPreferenceStore.getInt(keyPingRepeat) : server.getTransientPingRepetitions();
            compressed = server.getCompressionSetting();
        }
        this.m_txUrl.setText(serverUrl);
        this.m_integerFields[0].setText("" + this.getSeconds(readTO));
        this.m_integerFields[1].setText("" + this.getSeconds(connectTO));
        this.m_integerFields[2].setText("" + this.getSeconds(pingTO));
        this.m_integerFields[3].setText("" + pingRepeat);
        this.m_cxCompress.setSelection(compressed);
        this.m_integerFields[0].setFocus();
    }

    private void cacheChangedSettings() {
        if (this.m_server != null && this.m_currentSettingChanged) {
            int readTO = this.getMilliseconds(this.getIntegerFieldValue(this.m_integerFields[0], INTEGER_FIELD_MIN_VALUES[0], INTEGER_FIELD_LABELS[0]));
            int connectTO = this.getMilliseconds(this.getIntegerFieldValue(this.m_integerFields[1], INTEGER_FIELD_MIN_VALUES[1], INTEGER_FIELD_LABELS[1]));
            int pingTO = this.getMilliseconds(this.getIntegerFieldValue(this.m_integerFields[2], INTEGER_FIELD_MIN_VALUES[2], INTEGER_FIELD_LABELS[2]));
            int pingRepeat = this.getIntegerFieldValue(this.m_integerFields[3], INTEGER_FIELD_MIN_VALUES[3], INTEGER_FIELD_LABELS[3]);
            this.m_mapTOsAndRepeat.put(this.m_server, new int[]{readTO, connectTO, pingTO, pingRepeat});
            this.m_mapCompress.put(this.m_server, new Boolean(this.m_cxCompress.getSelection()));
            this.m_setChangedServers.add(this.m_server);
        }
    }
}

