/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.preference;

import org.eclipse.jface.preference.IPreferenceStore;

public class DtrPreferenceManager {
    private IPreferenceStore fStore;
    private String fExternalDiffCommand;
    private String fExternalDiffParameters;
    private String fExternalDiffParametersType;
    private String fExternalMergeCommand;
    private String fExternalMergeParameters;
    private String fExternalMergeParametersType;
    private boolean fUseExternalDiff;
    private boolean fUseExternalMerge;
    private boolean fUse3wayDiff;
    private boolean fWorkspaceMonitorGeneral;
    private boolean fWorkspaceMonitorAdd;
    private boolean fWorkspaceMonitorDelete;
    private boolean fWorkspaceMonitorMove;
    private boolean fWorkspaceMonitorEdit;
    private boolean fShowProjectDecorator;
    private boolean fShowLocalIconIfCheckedOutForCreateDecorator;
    private boolean fShowRemoteIconIfCheckedOutForDeleteDecorator;
    private boolean fShowUpToDateIconDecorator;
    private boolean fUseApplicationFileIconsDecorator;
    private boolean fAutomergeMarkAsResolved;
    private boolean fAutomergeForce;
    private static final String EXT_DIFF = "externalDiff";
    private static final String EXT_DIFF_PARAM = "externalDiffParameters";
    private static final String EXT_DIFF_PARAM_TYPE = "externalDiffParametersType";
    private static final String EXT_MERGE = "externalMerge";
    private static final String EXT_MERGE_PARAM = "externalMergeParameters";
    private static final String EXT_MERGE_PARAM_TYPE = "externalMergeParametersType";
    private static final String INT_EXT_SWITCH_DIFF = "useExternalDIFF";
    private static final String INT_EXT_SWITCH_MERGE = "useExternalMERGE";
    private static final String THREE_WAY_DIFF_SWITCH = "use3way";
    private static final String WORKSPACE_MONITOR_GENERAL = "workspaceMonitor_GENERAL";
    private static final String WORKSPACE_MONITOR_ADD = "workspaceMonitor_ADD";
    private static final String WORKSPACE_MONITOR_DELETE = "workspaceMonitor_DELETE";
    private static final String WORKSPACE_MONITOR_MOVE = "workspaceMonitor_MOVE";
    private static final String WORKSPACE_MONITOR_EDIT = "workspaceMonitor_EDIT";
    public static final String SHOW_PROJECT_DECORATOR = "showProjectDecorator";
    public static final String SHOW_LOCAL_DECORATOR = "showLocalDecorator";
    public static final String SHOW_REMOTE_DECORATOR = "showRemoteDecorator";
    private static final String SHOW_UPTODATE_DECORATOR = "showUpToDateDecorator";
    public static final String USE_APPLICATION_ICONS = "useApplicationIcons";
    private static final String AUTOMERGE_MARK_CONFLICT_AS_RESOLVED = "MarkAsresolved";
    private static final String AUTOMERGE_FORCE = "ForceAutomerge";
    public static final String KEY_SINGLE_ACTIVITY_TRACE = "dtrSingleActivityTraceSwitchedOn";
    public static final String KEY_AUTOSAVE_BEFORE_CHECKIN = "autoSave_beforeCheckin";
    private static final String KEYPART_PING_TIMEOUT = "pingTimeout_";
    private static final String KEYPART_PING_REPETITIONS = "pingRepetitions_";

    public DtrPreferenceManager(IPreferenceStore store) {
        this.fStore = store;
        this.setDefaultValues();
        this.loadValues();
    }

    protected void setDefaultValues() {
        if (!this.fStore.contains(WORKSPACE_MONITOR_GENERAL)) {
            this.fStore.setValue(WORKSPACE_MONITOR_GENERAL, true);
        }
        if (!this.fStore.contains(WORKSPACE_MONITOR_ADD)) {
            this.fStore.setValue(WORKSPACE_MONITOR_ADD, true);
        }
        if (!this.fStore.contains(WORKSPACE_MONITOR_MOVE)) {
            this.fStore.setValue(WORKSPACE_MONITOR_MOVE, true);
        }
        if (!this.fStore.contains(WORKSPACE_MONITOR_DELETE)) {
            this.fStore.setValue(WORKSPACE_MONITOR_DELETE, true);
        }
        if (!this.fStore.contains(WORKSPACE_MONITOR_EDIT)) {
            this.fStore.setValue(WORKSPACE_MONITOR_EDIT, true);
        }
        if (!this.fStore.contains(SHOW_PROJECT_DECORATOR)) {
            this.fStore.setValue(SHOW_PROJECT_DECORATOR, false);
        }
        if (!this.fStore.contains(AUTOMERGE_FORCE)) {
            this.fStore.setValue(AUTOMERGE_FORCE, false);
        }
        if (!this.fStore.contains(AUTOMERGE_MARK_CONFLICT_AS_RESOLVED)) {
            this.fStore.setValue(AUTOMERGE_MARK_CONFLICT_AS_RESOLVED, false);
        }
        this.fStore.setValue(KEY_SINGLE_ACTIVITY_TRACE, false);
    }

    protected void loadValues() {
        this.fExternalDiffCommand = this.fStore.getString(EXT_DIFF);
        this.fExternalMergeCommand = this.fStore.getString(EXT_MERGE);
        this.fExternalDiffParameters = this.fStore.getString(EXT_DIFF_PARAM);
        this.fExternalMergeParameters = this.fStore.getString(EXT_MERGE_PARAM);
        this.fUseExternalDiff = this.fStore.getBoolean(INT_EXT_SWITCH_DIFF);
        this.fUse3wayDiff = this.fStore.getBoolean(THREE_WAY_DIFF_SWITCH);
        this.fUseExternalMerge = this.fStore.getBoolean(INT_EXT_SWITCH_MERGE);
        this.fWorkspaceMonitorDelete = this.fStore.getBoolean(WORKSPACE_MONITOR_DELETE);
        this.fWorkspaceMonitorAdd = this.fStore.getBoolean(WORKSPACE_MONITOR_ADD);
        this.fWorkspaceMonitorGeneral = this.fStore.getBoolean(WORKSPACE_MONITOR_GENERAL);
        this.fWorkspaceMonitorEdit = this.fStore.getBoolean(WORKSPACE_MONITOR_EDIT);
        this.fWorkspaceMonitorMove = this.fStore.getBoolean(WORKSPACE_MONITOR_MOVE);
        this.fExternalMergeParametersType = this.fStore.getString(EXT_MERGE_PARAM_TYPE);
        this.fExternalDiffParametersType = this.fStore.getString(EXT_DIFF_PARAM_TYPE);
        this.fShowProjectDecorator = this.fStore.getBoolean(SHOW_PROJECT_DECORATOR);
        this.fShowLocalIconIfCheckedOutForCreateDecorator = this.fStore.getBoolean(SHOW_LOCAL_DECORATOR);
        this.fShowRemoteIconIfCheckedOutForDeleteDecorator = this.fStore.getBoolean(SHOW_REMOTE_DECORATOR);
        this.fShowUpToDateIconDecorator = this.fStore.getBoolean(SHOW_UPTODATE_DECORATOR);
        this.fUseApplicationFileIconsDecorator = this.fStore.getBoolean(USE_APPLICATION_ICONS);
        this.fAutomergeForce = this.fStore.getBoolean(AUTOMERGE_FORCE);
        this.fAutomergeMarkAsResolved = this.fStore.getBoolean(AUTOMERGE_MARK_CONFLICT_AS_RESOLVED);
    }

    public String getExternalDiffCommand() {
        return this.fExternalDiffCommand;
    }

    public String getExternalMergeCommand() {
        return this.fExternalMergeCommand;
    }

    public void setExternalDiffCommand(String externalDiffCommand) {
        this.fExternalDiffCommand = externalDiffCommand;
        this.fStore.setValue(EXT_DIFF, externalDiffCommand);
    }

    public void setExternalMergeCommand(String externalMergeCommand) {
        this.fExternalMergeCommand = externalMergeCommand;
        this.fStore.setValue(EXT_MERGE, externalMergeCommand);
    }

    public String getExternalDiffParameters() {
        return this.fExternalDiffParameters;
    }

    public String getExternalMergeParameters() {
        return this.fExternalMergeParameters;
    }

    public void setExternalDiffParameters(String externalDiffParameters) {
        this.fExternalDiffParameters = externalDiffParameters;
        this.fStore.setValue(EXT_DIFF_PARAM, externalDiffParameters);
    }

    public void setExternalMergeParameters(String externalMergeParameters) {
        this.fExternalMergeParameters = externalMergeParameters;
        this.fStore.setValue(EXT_MERGE_PARAM, externalMergeParameters);
    }

    public boolean isUseExternalDiff() {
        return this.fUseExternalDiff;
    }

    public void setUseExternalDiff(boolean useExternalDiff) {
        this.fUseExternalDiff = useExternalDiff;
        this.fStore.setValue(INT_EXT_SWITCH_DIFF, this.fUseExternalDiff);
    }

    public boolean isUse3wayDiff() {
        return this.fUse3wayDiff;
    }

    public void setUse3wayDiff(boolean use3wayDiff) {
        this.fUse3wayDiff = use3wayDiff;
        this.fStore.setValue(THREE_WAY_DIFF_SWITCH, this.fUse3wayDiff);
    }

    public boolean isUseExternalMerge() {
        return this.fUseExternalMerge;
    }

    public void setUseExternalMerge(boolean useExternalMerge) {
        this.fUseExternalMerge = useExternalMerge;
        this.fStore.setValue(INT_EXT_SWITCH_MERGE, this.fUseExternalMerge);
    }

    public boolean isWorkspaceMonitorAdd() {
        return this.fWorkspaceMonitorAdd;
    }

    public boolean isWorkspaceMonitorDelete() {
        return this.fWorkspaceMonitorDelete;
    }

    public boolean isWorkspaceMonitorGeneral() {
        return this.fWorkspaceMonitorGeneral;
    }

    public boolean isWorkspaceMonitorMove() {
        return this.fWorkspaceMonitorMove;
    }

    public void setWorkspaceMonitorAdd(boolean workspaceMonitorAdd) {
        this.fWorkspaceMonitorAdd = workspaceMonitorAdd;
        this.fStore.setValue(WORKSPACE_MONITOR_ADD, workspaceMonitorAdd);
    }

    public void setWorkspaceMonitorDelete(boolean workspaceMonitorDelete) {
        this.fWorkspaceMonitorDelete = workspaceMonitorDelete;
        this.fStore.setValue(WORKSPACE_MONITOR_DELETE, workspaceMonitorDelete);
    }

    public void setWorkspaceMonitorGeneral(boolean workspaceMonitorGeneral) {
        this.fWorkspaceMonitorGeneral = workspaceMonitorGeneral;
        this.fStore.setValue(WORKSPACE_MONITOR_GENERAL, workspaceMonitorGeneral);
    }

    public void setWorkspaceMonitorMove(boolean workspaceMonitorMove) {
        this.fWorkspaceMonitorMove = workspaceMonitorMove;
        this.fStore.setValue(WORKSPACE_MONITOR_MOVE, workspaceMonitorMove);
    }

    public boolean isWorkspaceMonitorEdit() {
        return this.fWorkspaceMonitorEdit;
    }

    public void setWorkspaceMonitorEdit(boolean workspaceMonitorEdit) {
        this.fWorkspaceMonitorEdit = workspaceMonitorEdit;
        this.fStore.setValue(WORKSPACE_MONITOR_EDIT, workspaceMonitorEdit);
    }

    public String getExternalMergeParametersType() {
        return this.fExternalMergeParametersType;
    }

    public void setExternalMergeParametersType(String externalMergeParameterType) {
        this.fExternalMergeParametersType = externalMergeParameterType;
        this.fStore.setValue(EXT_MERGE_PARAM_TYPE, externalMergeParameterType);
    }

    public String getExternalDiffParametersType() {
        return this.fExternalDiffParametersType;
    }

    public void setExternalDiffParametersType(String externalDiffParametersType) {
        this.fExternalDiffParametersType = externalDiffParametersType;
        this.fStore.setValue(EXT_DIFF_PARAM_TYPE, externalDiffParametersType);
    }

    public boolean isShowProjectDecorator() {
        return this.fShowProjectDecorator;
    }

    public void setShowProjectDecorator(boolean showProjectDecorator) {
        this.fShowProjectDecorator = showProjectDecorator;
        this.fStore.setValue(SHOW_PROJECT_DECORATOR, this.fShowProjectDecorator);
    }

    public boolean isShowLocalIconIfCheckedOutForCreateDecorator() {
        return this.fShowLocalIconIfCheckedOutForCreateDecorator;
    }

    public void setShowLocalIconIfCheckedOutForCreateDecorator(boolean showLocalDecorator) {
        this.fShowLocalIconIfCheckedOutForCreateDecorator = showLocalDecorator;
        this.fStore.setValue(SHOW_LOCAL_DECORATOR, this.fShowLocalIconIfCheckedOutForCreateDecorator);
    }

    public boolean isShowRemoteIconIfCheckedOutForDeleteDecorator() {
        return this.fShowRemoteIconIfCheckedOutForDeleteDecorator;
    }

    public void setShowRemoteIconIfCheckedOutForDeleteDecorator(boolean showRemoteDecorator) {
        this.fShowRemoteIconIfCheckedOutForDeleteDecorator = showRemoteDecorator;
        this.fStore.setValue(SHOW_REMOTE_DECORATOR, this.fShowRemoteIconIfCheckedOutForDeleteDecorator);
    }

    public boolean isUseApplicationFileIconsDecorator() {
        return this.fUseApplicationFileIconsDecorator;
    }

    public void setUseApplicationFileIconsDecorator(boolean useApplicationIcons) {
        this.fUseApplicationFileIconsDecorator = useApplicationIcons;
        this.fStore.setValue(USE_APPLICATION_ICONS, this.fUseApplicationFileIconsDecorator);
    }

    public boolean isShowUpToDateIconDecorator() {
        return this.fShowUpToDateIconDecorator;
    }

    public void setShowUpToDateIconDecorator(boolean showUpToDateDecorator) {
        this.fShowUpToDateIconDecorator = showUpToDateDecorator;
        this.fStore.setValue(SHOW_UPTODATE_DECORATOR, this.fShowUpToDateIconDecorator);
    }

    public boolean isAutomergeForce() {
        return this.fAutomergeForce;
    }

    public boolean isAutomergeMarkAsResolved() {
        return this.fAutomergeMarkAsResolved;
    }

    public void setAutomergeForce(boolean force) {
        this.fAutomergeForce = force;
        this.fStore.setValue(AUTOMERGE_FORCE, force);
    }

    public void setAutomergeMarkAsResolved(boolean markAsResolved) {
        this.fAutomergeMarkAsResolved = markAsResolved;
        this.fStore.setValue(AUTOMERGE_MARK_CONFLICT_AS_RESOLVED, markAsResolved);
    }

    public String getPreferenceKeyOfPingTimeout(String serverUrl) {
        return KEYPART_PING_TIMEOUT + serverUrl;
    }

    public String getPreferenceKeyOfPingRepetitions(String serverUrl) {
        return KEYPART_PING_REPETITIONS + serverUrl;
    }
}

