/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.automerge;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class DocumentComparator
implements ITokenComparator {
    private IDocument fDocument;
    private int fLineOffset;
    private int fLineCount;
    private int fLength;
    private boolean fIgnoreWhiteSpace;
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$automerge$DocumentComparator == null ? (class$com$tssap$dtr$client$eclipse$automerge$DocumentComparator = DocumentComparator.class$("com.tssap.dtr.client.eclipse.automerge.DocumentComparator")) : class$com$tssap$dtr$client$eclipse$automerge$DocumentComparator));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$automerge$DocumentComparator;

    public DocumentComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace) {
        this.fDocument = document;
        this.fIgnoreWhiteSpace = ignoreWhiteSpace;
        this.fLineOffset = 0;
        if (region != null) {
            this.fLength = region.getLength();
            int start = region.getOffset();
            try {
                this.fLineOffset = this.fDocument.getLineOfOffset(start);
            }
            catch (BadLocationException ex) {
                LogUtil.logException((Location)LOCATION, (Throwable)ex);
            }
            if (this.fLength == 0) {
                this.fLineCount = 0;
            } else {
                int endLine = this.fDocument.getNumberOfLines();
                try {
                    endLine = this.fDocument.getLineOfOffset(start + this.fLength);
                }
                catch (BadLocationException ex) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ex);
                }
                this.fLineCount = endLine - this.fLineOffset + 1;
            }
        } else {
            this.fLength = document.getLength();
            this.fLineCount = this.fDocument.getNumberOfLines();
        }
    }

    public int getRangeCount() {
        return this.fLineCount;
    }

    public int getTokenStart(int line) {
        try {
            IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
            return r.getOffset();
        }
        catch (BadLocationException ex) {
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
            return this.fDocument.getLength();
        }
    }

    public int getTokenLength(int line) {
        return this.getTokenStart(line + 1) - this.getTokenStart(line);
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other0, int otherIndex) {
        if (other0 != null && other0.getClass() == this.getClass()) {
            int olen;
            DocumentComparator other = (DocumentComparator)other0;
            if (this.fIgnoreWhiteSpace) {
                String s1 = this.extract(thisIndex);
                String s2 = other.extract(otherIndex);
                return this.compare(s1, s2);
            }
            int tlen = this.getTokenLength(thisIndex);
            if (tlen == (olen = other.getTokenLength(otherIndex))) {
                String s1 = this.extract(thisIndex);
                String s2 = other.extract(otherIndex);
                return s1.equals(s2);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        return false;
    }

    private String extract(int line) {
        if (line < this.fLineCount) {
            try {
                IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
                return this.fDocument.get(r.getOffset(), r.getLength());
            }
            catch (BadLocationException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return "";
    }

    private boolean compare(String s1, String s2) {
        int i1 = 0;
        int i2 = 0;
        int l1 = s1.length();
        int l2 = s2.length();
        char c1 = ' ';
        char c2 = ' ';
        while (i1 < l1 || i2 < l2) {
            if (i1 < l1 && Character.isWhitespace(c1 = (char)s1.charAt(i1))) {
                ++i1;
                continue;
            }
            if (i2 < l2 && Character.isWhitespace(c2 = (char)s2.charAt(i2))) {
                ++i2;
                continue;
            }
            if (c1 != c2) {
                return false;
            }
            ++i1;
            ++i2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

