/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.automerge;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.AutomergeLogType;
import com.tssap.dtr.client.eclipse.automerge.CollisionState;
import com.tssap.dtr.client.eclipse.automerge.DocumentComparator;
import com.tssap.dtr.client.eclipse.automerge.IAutomergeLogListener;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.conflict.ConflictUtility;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.eclipse.util.RemoteFileVersionInputStream;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.Assert;

public class Collision {
    private IVfsVersion fAncestorVersion;
    private IVfsVersion fRepositoryVersion;
    private IVfsVersion fCompareVersion;
    private File fMergeFile;
    private IVfsFile fCollisionFile;
    private boolean fBinaryContent;
    private CollisionState fState;
    private boolean fLocalFileContantChanged = false;
    private int fActiveDifferencers = 0;
    private int fMergeDifferences = 0;
    private int fIntersectingDifferences = 0;
    private int fPseudoConflict = 0;
    private RangeDifference[] fDifferences;
    private List fAllDifs = new ArrayList();
    private IDocument fAncestorDocument;
    private IDocument fMergeDocument;
    private IDocument fCompareDocument;
    private boolean fResolved = false;
    private IVfsCollision fOriginalCollision;
    private List fLogListeners = new ArrayList();
    private DtrPreferenceManager fPreferenceManager = BluebirdPlugin.getDefault().getPreferenceManager();
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$automerge$Collision == null ? (class$com$tssap$dtr$client$eclipse$automerge$Collision = Collision.class$("com.tssap.dtr.client.eclipse.automerge.Collision")) : class$com$tssap$dtr$client$eclipse$automerge$Collision));
    private static final String MSG_SEPARATOR = " ... ";
    private boolean fMergeVersionCreated;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$automerge$Collision;

    public Collision(IVfsIntegrateCollision integrateCollision, boolean mergeVersionCreated) {
        IVfsMergeVersion mergeVersion = integrateCollision.getMergeVersion();
        Assert.isNotNull((Object)mergeVersion, (String)"Merge version must be created before.");
        this.fOriginalCollision = integrateCollision;
        this.fAncestorVersion = integrateCollision.getCommonAncestor();
        this.fCompareVersion = integrateCollision.getCollidingVersion();
        this.fRepositoryVersion = integrateCollision.getActiveVersion();
        this.fMergeFile = new File(mergeVersion.getLocalFile().getAbsolutePath());
        this.fMergeVersionCreated = mergeVersionCreated;
        this.setContentType();
        this.fState = CollisionState.OPEN;
    }

    public Collision(IVfsCheckinCollision checkinCollision) {
        this.fOriginalCollision = checkinCollision;
        this.fAncestorVersion = checkinCollision.getCommonAncestor();
        this.fCompareVersion = checkinCollision.getValidSourceVersion();
        this.fMergeFile = new File(checkinCollision.getFolderItemForCollidingVersion().getLocalFile().getAbsolutePath());
        this.setContentType();
        this.fState = CollisionState.OPEN;
    }

    private void setContentType() {
        try {
            this.fBinaryContent = ConflictUtility.guessType(new FileInputStream(this.fMergeFile)) != "txt";
        }
        catch (FileNotFoundException e) {
            this.fBinaryContent = false;
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    public String getMergeFilePath() {
        return this.fMergeFile.getAbsolutePath();
    }

    public File getMergeFile() {
        return this.fMergeFile;
    }

    public boolean isBinary() {
        return this.fBinaryContent;
    }

    protected void executeDifferencer() {
        if (this.isResolved() || this.isBinary()) {
            return;
        }
        this.fAllDifs.clear();
        this.fActiveDifferencers = 0;
        this.fMergeDifferences = 0;
        this.fIntersectingDifferences = 0;
        this.fPseudoConflict = 0;
        this.fAncestorDocument = new Document(this.getContentAsString(this.fAncestorVersion));
        this.fMergeDocument = new Document(this.getContentAsString(this.fMergeFile));
        this.fCompareDocument = new Document(this.getContentAsString(this.fCompareVersion));
        boolean ignoreWhiteSpaces = CompareUI.getPlugin().getPluginPreferences().getBoolean("org.eclipse.compare.IgnoreWhitespace");
        DocumentComparator ancestorComparator = new DocumentComparator(this.fAncestorDocument, null, ignoreWhiteSpaces);
        DocumentComparator mergeComparator = new DocumentComparator(this.fMergeDocument, null, ignoreWhiteSpaces);
        DocumentComparator activeComparator = new DocumentComparator(this.fCompareDocument, null, ignoreWhiteSpaces);
        this.fDifferences = RangeDifferencer.findRanges((IRangeComparator)ancestorComparator, (IRangeComparator)mergeComparator, (IRangeComparator)activeComparator);
        int i = 0;
        while (i < this.fDifferences.length) {
            RangeDifference current = this.fDifferences[i];
            int ancStart = ancestorComparator.getTokenStart(current.ancestorStart());
            int ancEnd = this.getTokenEnd2(ancestorComparator, current.ancestorStart(), current.ancestorLength());
            int ancLen = current.ancestorLength();
            int leftStart = mergeComparator.getTokenStart(current.leftStart());
            int leftEnd = this.getTokenEnd2(mergeComparator, current.leftStart(), current.leftLength());
            int leftLen = current.leftLength();
            int rightStart = activeComparator.getTokenStart(current.rightStart());
            int rightEnd = this.getTokenEnd2(activeComparator, current.rightStart(), current.rightLength());
            int rightLen = rightEnd - rightStart;
            Diff diff = new Diff(this.fDifferences[i], this.fDifferences[i].kind(), this.fAncestorDocument, ancStart, ancEnd, ancLen, this.fMergeDocument, leftStart, leftEnd, leftLen, this.fCompareDocument, rightStart, rightEnd, rightLen);
            this.fAllDifs.add(diff);
            switch (this.fDifferences[i].kind()) {
                case 3: {
                    ++this.fMergeDifferences;
                    break;
                }
                case 2: {
                    ++this.fActiveDifferencers;
                    break;
                }
                case 1: {
                    ++this.fIntersectingDifferences;
                    ++this.fActiveDifferencers;
                    ++this.fMergeDifferences;
                    break;
                }
                case 4: {
                    ++this.fPseudoConflict;
                }
            }
            ++i;
        }
    }

    protected void runAutomerge(boolean preview, boolean resolve, boolean forceIntersecting) throws AutomergeException {
        this.startLog();
        this.logToConsole("", true, false, AutomergeLogType.INFO);
        Object[] param = new String[]{preview ? "in PREVIEW mode" : ""};
        String message = MessageFormat.format("Starting Auto Merge {0}", param);
        this.logToConsole(message, false, true, AutomergeLogType.INFO);
        this.executeDifferencer();
        try {
            Iterator i = this.fAllDifs.iterator();
            while (i.hasNext()) {
                Diff currentDiff = (Diff)i.next();
                Position leftPos = currentDiff.getLeftPosition();
                Position rightPos = currentDiff.getRightPosition();
                Position ancestorPos = currentDiff.getAncestorPosition();
                switch (currentDiff.kind()) {
                    case 3: {
                        this.logToConsole("CONFLICTING VERSION differs in lines: " + currentDiff.getOriginalDifference().leftStart() + " - " + currentDiff.getOriginalDifference().leftEnd(), false, true, AutomergeLogType.INFO);
                        break;
                    }
                    case 2: {
                        this.logToConsole("ACTIVE VERSION differs in lines: " + currentDiff.getOriginalDifference().rightStart() + " - " + currentDiff.getOriginalDifference().rightEnd(), false, true, AutomergeLogType.INFO);
                        String change = this.fCompareDocument.get(rightPos.getOffset(), rightPos.getLength());
                        this.fMergeDocument.replace(leftPos.getOffset(), leftPos.getLength(), change);
                        leftPos.setOffset(leftPos.getOffset());
                        leftPos.setLength(change.length());
                        this.logToConsole("Copying Active version differences to merge version.", false, true, AutomergeLogType.INFO);
                        break;
                    }
                    case 4: {
                        this.logToConsole("PSEUDO CONFLICT found in lines: " + currentDiff.getOriginalDifference().leftStart() + " - " + currentDiff.getOriginalDifference().leftEnd(), false, true, AutomergeLogType.INFO);
                        break;
                    }
                    case 1: {
                        String change;
                        if (forceIntersecting) {
                            change = this.constructIntersectingText(currentDiff);
                            this.fMergeDocument.replace(leftPos.getOffset(), leftPos.getLength(), change);
                            leftPos.setOffset(leftPos.getOffset());
                            leftPos.setLength(change.length());
                            this.logToConsole("INTERSECTING CONFLICT found in lines: " + currentDiff.getOriginalDifference().leftStart() + " - " + currentDiff.getOriginalDifference().leftEnd() + " - Conflict resolved, but manual post-processing needed!", false, true, AutomergeLogType.WARNING);
                            break;
                        }
                        this.logToConsole("INTERSECTING CONFLICT found in lines: " + currentDiff.getOriginalDifference().leftStart() + " - " + currentDiff.getOriginalDifference().leftEnd() + " - Conflict unresolved, manual merge needed!", false, true, AutomergeLogType.ERROR);
                    }
                }
            }
        }
        catch (BadLocationException e) {
            throw new AutomergeException(e.getMessage());
        }
        if (!preview) {
            this.writeContentToFile(this.fMergeDocument, this.fMergeFile);
            this.fState = CollisionState.PARTIALLY_RESOLVED;
            if (resolve && (this.getIntersectingDifferences() == 0 || forceIntersecting)) {
                IVfsCheckinCollision collision;
                this.fState = CollisionState.RESOLVED;
                this.fResolved = true;
                if (this.fOriginalCollision instanceof IVfsCheckinCollision) {
                    collision = (IVfsCheckinCollision)this.fOriginalCollision;
                    try {
                        collision.acceptCollidingVersion();
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                } else if (this.fOriginalCollision instanceof IVfsIntegrateCollision) {
                    collision = (IVfsIntegrateCollision)this.fOriginalCollision;
                }
            }
            if (this.fResolved) {
                this.logToConsole("Marking Conflict as resolved.", false, true, AutomergeLogType.INFO);
            }
        } else if (resolve && (this.getIntersectingDifferences() == 0 || forceIntersecting)) {
            this.logToConsole("Marking Conflict as resolved.", false, true, AutomergeLogType.INFO);
        }
        this.printTailMessage(preview, forceIntersecting);
        this.endLog();
    }

    private String getLeadText(String versionType, IVfsVersion version) {
        SimpleDateFormat formatter = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return MessageFormat.format("++++++++ code from {0} #{1} in workspace ''{2}'' created by ''{3}'' at {4} ++++++++\n", versionType, new Integer(version.getBranchSequenceNumber()), version.getCreatorWorkspaceName(), version.getAuthor(), formatter.format(version.getLastModifiedDate()));
    }

    private String constructIntersectingText(Diff current) throws BadLocationException {
        Position leftPos = current.getLeftPosition();
        Position rightPos = current.getRightPosition();
        Position ancestorPos = current.getAncestorPosition();
        String out = "";
        String tail = "++++++++++++++++++++++++++++++++++++++++++++\n";
        if (this.getOriginalCollision() instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision collision = (IVfsIntegrateCollision)this.getOriginalCollision();
            String ancestorLead = this.getLeadText("common ancestor", this.fAncestorVersion);
            String activeLead = this.getLeadText("active version", collision.getActiveVersion());
            String collidingLead = this.getLeadText("conflicting version", collision.getCollidingVersion());
            String ancestorChange = this.fAncestorDocument.get(ancestorPos.getOffset(), ancestorPos.getLength());
            String activeChange = this.fMergeDocument.get(leftPos.getOffset(), leftPos.getLength());
            String collidingChange = this.fCompareDocument.get(rightPos.getOffset(), rightPos.getLength());
            out = ancestorLead + ancestorChange + activeLead + activeChange + collidingLead + collidingChange + tail;
        } else if (this.getOriginalCollision() instanceof IVfsCheckinCollision) {
            IVfsCheckinCollision collision = (IVfsCheckinCollision)this.getOriginalCollision();
            IVfsVersion collidingVersion = collision.getFolderItemForCollidingVersion().asFile().getSyncedVersion();
            String ancestorLead = this.getLeadText("common ancestor", this.fAncestorVersion);
            String activeLead = this.getLeadText("active version", this.fCompareVersion);
            String collidingLead = this.getLeadText("conflicting version", collidingVersion);
            String ancestorChange = this.fAncestorDocument.get(ancestorPos.getOffset(), ancestorPos.getLength());
            String activeChange = this.fCompareDocument.get(rightPos.getOffset(), rightPos.getLength());
            String collidingChange = this.fMergeDocument.get(leftPos.getOffset(), leftPos.getLength());
            out = ancestorLead + ancestorChange + activeLead + activeChange + collidingLead + collidingChange + tail;
        }
        return out;
    }

    private void printTailMessage(boolean preview, boolean forceIntersecting) {
        AutomergeLogType type = this.getIntersectingDifferences() > 0 ? (forceIntersecting ? AutomergeLogType.WARNING : AutomergeLogType.ERROR) : AutomergeLogType.INFO;
        Object[] objectArray = new String[2];
        String string = objectArray[0] = preview ? "PREVIEW " : "";
        objectArray[1] = this.getIntersectingDifferences() > 0 ? (forceIntersecting ? "Intersecting regions have been merged, but manual post-processing is needed!" : "Intersecting regions of the file have to be resolved manually!") : "";
        Object[] param = objectArray;
        String message = MessageFormat.format("Auto Merge {0}is finished. {1}", param);
        this.logToConsole(message, false, true, type);
    }

    private void writeContentToFile(IDocument document, File file) {
        String content = document.get();
        try {
            DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(file));
            outputStream.writeBytes(content);
            outputStream.close();
            IResource res = BluebirdPlugin.getResource(file);
            if (res != null) {
                res.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException e) {
            Logbook.getErrorChapter().println("IOException occured during writing content to file: " + file + ": " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        catch (CoreException ex) {
            Logbook.getErrorChapter().println("CoreException occured during writing content to file: " + file + "\n" + ex.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
        }
    }

    public boolean isResolved() {
        return this.fResolved;
    }

    public void setResolved(boolean resolved) {
        this.fState = resolved ? CollisionState.RESOLVED : CollisionState.OPEN;
        this.fResolved = resolved;
    }

    public CollisionState getCollisionState() {
        return this.fState;
    }

    protected String getContentAsString(File fille) {
        try {
            FileInputStream input = new FileInputStream(fille);
            return this.getContent(input);
        }
        catch (FileNotFoundException e) {
            Logbook.getErrorChapter().println("File : " + fille.getAbsolutePath() + " not found!");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    protected String getContentAsString(IVfsVersion version) {
        InputStream input = RemoteFileVersionInputStream.getInputStream(version);
        return this.getContent(input);
    }

    protected String getPreviewResult(boolean forceIntersecting) throws AutomergeException {
        this.runAutomerge(true, false, forceIntersecting);
        return this.fMergeDocument.get();
    }

    public IVfsVersion getAncestorVersion() {
        return this.fAncestorVersion;
    }

    public IVfsVersion getCompareVersion() {
        return this.fCompareVersion;
    }

    public IVfsVersion getRepositoryVersion() {
        return this.fRepositoryVersion;
    }

    public String getCompareVersionTitle() {
        if (this.fCompareVersion == null) {
            return "";
        }
        if (this.getOriginalCollision() instanceof IVfsIntegrateCollision) {
            return "[ Colliding Version ] - " + this.fCompareVersion.getLocationInGraph(this.fCompareVersion.getCreatorWorkspaceName());
        }
        return "[ Active (Remote) Version ] -  " + this.fCompareVersion.getLocationInGraph(this.fCompareVersion.getCreatorWorkspaceName());
    }

    public String getRepositoryVersionTitle() {
        if (this.fRepositoryVersion == null) {
            return "";
        }
        if (this.getOriginalCollision() instanceof IVfsIntegrateCollision) {
            return "[ Active Version ] - " + this.fRepositoryVersion.getLocationInGraph(this.fRepositoryVersion.getCreatorWorkspaceName());
        }
        return this.fRepositoryVersion.getLocationInGraph(this.fRepositoryVersion.getCreatorWorkspaceName());
    }

    protected String getContentAsString(IVfsFile file) {
        try {
            return this.getContent(file.getContent());
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return new String();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getContent(InputStream input) {
        StringBuffer out = new StringBuffer();
        try {
            int ch;
            while ((ch = input.read()) >= 0) {
                void var3_3;
                out.append((char)var3_3);
            }
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        return out.toString();
    }

    public int getActiveVersionDifferences() {
        return this.fActiveDifferencers;
    }

    public int getPseudoDifferences() {
        return this.fPseudoConflict;
    }

    protected void finish() {
        if (this.fOriginalCollision instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision integrateCollision = (IVfsIntegrateCollision)this.fOriginalCollision;
            try {
                if (this.fState == CollisionState.OPEN && this.fMergeVersionCreated && !this.fLocalFileContantChanged) {
                    IntegrateCollisionUtil.undoMerge(integrateCollision);
                } else if (this.fResolved) {
                    integrateCollision.markAsResolved();
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        this.fLogListeners.clear();
    }

    protected void logToConsole(String message, boolean includeFilename, boolean indent, AutomergeLogType type) {
        StringBuffer msg = new StringBuffer();
        if (includeFilename) {
            msg.append(this.fMergeFile.getAbsolutePath() + MSG_SEPARATOR + message);
        } else if (indent) {
            int i = 0;
            while (i < 5) {
                msg.append(' ');
                ++i;
            }
            msg.append("> ");
            msg.append(message);
        } else {
            msg.append(message);
        }
        Iterator iter = this.fLogListeners.iterator();
        while (iter.hasNext()) {
            IAutomergeLogListener listener = (IAutomergeLogListener)iter.next();
            listener.log(msg.toString(), type);
        }
    }

    protected void startLog() {
        Iterator iter = this.fLogListeners.iterator();
        while (iter.hasNext()) {
            IAutomergeLogListener listener = (IAutomergeLogListener)iter.next();
            listener.logStart();
        }
    }

    protected void endLog() {
        Iterator iter = this.fLogListeners.iterator();
        while (iter.hasNext()) {
            IAutomergeLogListener listener = (IAutomergeLogListener)iter.next();
            listener.logEnd();
        }
    }

    public int getMergeVersionDifferences() {
        return this.fMergeDifferences;
    }

    public int getIntersectingDifferences() {
        return this.fIntersectingDifferences;
    }

    public IVfsCollision getOriginalCollision() {
        return this.fOriginalCollision;
    }

    public void addLogListener(IAutomergeLogListener listener) {
        this.fLogListeners.add(listener);
    }

    public void removeLogListener(IAutomergeLogListener listener) {
        this.fLogListeners.remove(listener);
    }

    public void setLocalFileContentChanged(boolean changed) {
        this.fLocalFileContantChanged = changed;
    }

    private int getTokenEnd(ITokenComparator tc, int start, int count) {
        if (count <= 0) {
            return tc.getTokenStart(start);
        }
        int index = start + count - 1;
        return tc.getTokenStart(index) + tc.getTokenLength(index);
    }

    private int getTokenEnd2(ITokenComparator tc, int start, int length) {
        return tc.getTokenStart(start + length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Diff {
        private IDocument fLeftDoc;
        private IDocument fRightDoc;
        private IDocument fAncDoc;
        private int fType;
        private RangeDifference fOriginalDifference;
        private Position fLeftPos;
        private Position fRightPos;
        private Position fAncestorPos;

        protected Diff(RangeDifference diference, int type, IDocument ancestorDoc, int ancStart, int ancEnd, int ancLen, IDocument leftDoc, int leftStart, int leftEnd, int leftLen, IDocument rightDoc, int rightStart, int rightEnd, int rightLen) {
            this.fOriginalDifference = diference;
            this.fType = type;
            this.fLeftDoc = leftDoc;
            this.fLeftPos = this.createPosition(leftDoc, leftStart, leftEnd);
            this.fRightDoc = rightDoc;
            this.fRightPos = this.createPosition(rightDoc, rightStart, rightEnd);
            this.fAncDoc = ancestorDoc;
            this.fAncestorPos = this.createPosition(ancestorDoc, ancStart, ancEnd);
        }

        Position createPosition(IDocument doc, int start, int end) {
            try {
                int l = end - start;
                int dl = doc.getLength();
                if (start + l > dl) {
                    l = dl - start;
                }
                Position p = null;
                try {
                    p = new Position(start, l);
                }
                catch (RuntimeException ex) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ex);
                }
                try {
                    doc.addPosition("__dflt_position_category", p);
                }
                catch (BadPositionCategoryException ex) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ex);
                }
                return p;
            }
            catch (BadLocationException ee) {
                LogUtil.logException((Location)LOCATION, (Throwable)ee);
                return null;
            }
        }

        public Position getLeftPosition() {
            return this.fLeftPos;
        }

        public Position getRightPosition() {
            return this.fRightPos;
        }

        public Position getAncestorPosition() {
            return this.fAncestorPos;
        }

        public IDocument getAncestor() {
            return this.fAncDoc;
        }

        public IDocument getLeft() {
            return this.fLeftDoc;
        }

        public IDocument getRight() {
            return this.fRightDoc;
        }

        public int kind() {
            return this.fType;
        }

        public RangeDifference getOriginalDifference() {
            return this.fOriginalDifference;
        }
    }
}

